/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage.linking.database;

import dcshadow.com.google.gson.JsonArray;
import dcshadow.com.google.gson.JsonElement;
import dcshadow.com.google.gson.JsonParser;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.database.DBInterface;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class JSONInterface
extends DBInterface {
    public static final File jsonFile = new File(DiscordIntegration.discordDataDir, "LinkedPlayers.json");

    @Override
    public void connect() {
    }

    @Override
    public void initialize() {
        block15: {
            try {
                if (!jsonFile.getParentFile().exists()) {
                    jsonFile.getParentFile().mkdirs();
                }
                if (jsonFile.exists()) break block15;
                jsonFile.createNewFile();
                try (FileWriter writer = new FileWriter(jsonFile);){
                    gson.toJson((JsonElement)new JsonArray(), (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return jsonFile.exists();
    }

    @Override
    public void addLink(PlayerLink link) {
        DiscordIntegration.LOGGER.debug("JSONInterface addLink | Saving " + link);
        JsonArray json = JSONInterface.getJson();
        DiscordIntegration.LOGGER.debug("JSONInterface addLink | json (old): " + json);
        for (JsonElement e : json) {
            PlayerLink o = gson.fromJson(e, PlayerLink.class);
            if (!o.discordID.equals(link.discordID) && (o.floodgateUUID == null || o.floodgateUUID.isEmpty() || !o.floodgateUUID.equals(link.floodgateUUID)) && (o.mcPlayerUUID == null || o.mcPlayerUUID.isEmpty() || !o.mcPlayerUUID.equals(link.mcPlayerUUID))) continue;
            json.remove(e);
            DiscordIntegration.LOGGER.debug("JSONInterface addLink | Removing old link from json " + o.discordID);
            break;
        }
        json.add(gson.toJsonTree(link).getAsJsonObject());
        DiscordIntegration.LOGGER.debug("JSONInterface addLink | json (new): " + json);
        try (FileWriter writer = new FileWriter(jsonFile);){
            gson.toJson((JsonElement)json, (Appendable)writer);
            DiscordIntegration.LOGGER.debug("JSONInterface addLink | Written to File");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeLink(String id) {
        for (JsonElement e : JSONInterface.getJson()) {
            PlayerLink o = gson.fromJson(e, PlayerLink.class);
            if (o.discordID == null || !o.discordID.equals(id)) continue;
            JsonArray json = JSONInterface.getJson();
            json.remove(e);
            try {
                FileWriter writer = new FileWriter(jsonFile);
                Throwable throwable = null;
                try {
                    gson.toJson((JsonElement)json, (Appendable)writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    @Override
    public PlayerLink[] getAllLinks() {
        return gson.fromJson((JsonElement)JSONInterface.getJson(), PlayerLink[].class);
    }

    private static JsonArray getJson() {
        try {
            FileReader is = new FileReader(jsonFile);
            JsonArray a = JsonParser.parseReader(is).getAsJsonArray();
            is.close();
            return a;
        }
        catch (IOException e) {
            return new JsonArray();
        }
    }
}

