/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.PatternReplacementResult;
import dcshadow.net.kyori.adventure.text.TextComponent;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.format.TextDecoration;
import dcshadow.org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import dcshadow.org.intellij.lang.annotations.RegExp;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;

public class ComponentUtils {
    public static Style addUserHoverClick(Style styleIn, Member m) {
        return ComponentUtils.addUserHoverClick(styleIn, m.getId(), m.getEffectiveName(), m.getUser().getAsTag());
    }

    public static Style addUserHoverClick(Style styleIn, User u, Member m) {
        return ComponentUtils.addUserHoverClick(styleIn, u.getId(), m == null ? u.getName() : m.getEffectiveName(), u.getAsTag());
    }

    public static Style addUserHoverClick(Style styleIn, String userID, String displayName, String tag) {
        return styleIn.clickEvent(ClickEvent.suggestCommand("<@" + userID + ">")).hoverEvent(HoverEvent.showText(Component.text(Localization.instance().discordUserHover.replace("%user#tag%", tag).replace("%user%", displayName))));
    }

    public static Component makeURLsClickable(Component in) {
        return in.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(MessageUtils.URL_PATTERN).replacement(url -> (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)url.decorate(TextDecoration.UNDERLINED)).color(TextColor.color(6, 69, 173))).clickEvent(ClickEvent.openUrl(url.content()))).build());
    }

    public static TextReplacementConfig replace(@RegExp String a, String b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).build();
    }

    public static TextReplacementConfig replaceLiteral(String a, String b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).build();
    }

    public static TextReplacementConfig replace(@RegExp String a, String b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).times(times).build();
    }

    public static TextReplacementConfig replaceLiteral(String a, String b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).times(times).build();
    }

    public static TextReplacementConfig replace(@RegExp String a, Component b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).build();
    }

    public static TextReplacementConfig replaceLiteral(String a, Component b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).build();
    }

    public static TextReplacementConfig replace(@RegExp String a, Component b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).times(times).build();
    }

    public static TextReplacementConfig replaceLiteral(String a, Component b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).times(times).build();
    }

    public static Map.Entry<Boolean, Component> parsePing(Component msg, UUID uuid, String name) {
        AtomicBoolean hasPing = new AtomicBoolean(false);
        msg = msg.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@" + name).replacement(Component.text("@" + name).style(Style.style(TextColors.PING).decorate(TextDecoration.BOLD))).condition((a, b) -> {
            hasPing.set(true);
            return PatternReplacementResult.REPLACE;
        }).build());
        if (!hasPing.get() && LinkManager.isPlayerLinked(uuid)) {
            String dcname = ((Member)DiscordIntegration.INSTANCE.getChannel().getGuild().retrieveMemberById(LinkManager.getLink(null, (UUID)uuid).discordID).complete()).getEffectiveName();
            msg = msg.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@" + dcname).replacement(Component.text("@" + dcname).style(Style.style(TextColors.PING).decorate(TextDecoration.BOLD))).condition((a, b) -> {
                hasPing.set(true);
                return PatternReplacementResult.REPLACE;
            }).build());
        }
        return new DefaultMapEntry<Boolean, Component>(hasPing.get(), msg);
    }

    public static Component append(Component base, Component toAppend) {
        return base.append(toAppend);
    }
}

