/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common;

import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;

public final class WorkThread {
    private static final LinkedList<Job> jobQueue = new LinkedList();
    private static final Thread runner = WorkThread.do_start(new Thread(WorkThread::thread, "DiscordIntegration-Core WorkerThread"));

    private WorkThread() {
    }

    private static Thread do_start(Thread thr) {
        thr.setDaemon(true);
        thr.start();
        return thr;
    }

    private static void thread() {
        while (true) {
            Job j;
            if ((j = jobQueue.poll()) != null) {
                j.run();
                continue;
            }
            LockSupport.park();
        }
    }

    private static void pushJob(Job job) {
        boolean unpark = jobQueue.isEmpty();
        jobQueue.addLast(job);
        boolean bl = unpark = unpark || jobQueue.peekLast() == jobQueue.peekFirst();
        if (unpark) {
            LockSupport.unpark(runner);
        }
    }

    public static JobHandle executeJob(Runnable action) {
        JobHandle handle = new JobHandle();
        final class JobAction
        implements Job {
            final Runnable action;
            final JobHandle handle;

            public JobAction(Runnable action, JobHandle handle) {
                this.action = action;
                this.handle = handle;
            }

            @Override
            public void run() {
                try {
                    this.action.run();
                }
                catch (Exception ex) {
                    this.handle.error = ex;
                }
                this.handle.completed = true;
            }
        }
        JobAction job = new JobAction(action, handle);
        if (Thread.currentThread() == runner) {
            job.run();
        } else {
            WorkThread.pushJob(job);
        }
        return handle;
    }

    public static <R> JobHandleWithResult<R> executeJobWithReturn(Supplier<R> action) {
        JobHandleWithResult handle = new JobHandleWithResult();
        final class JobActionWithReturn
        implements Job {
            final Supplier<R> action;
            final JobHandleWithResult<R> handle;

            public JobActionWithReturn(Supplier<R> action, JobHandleWithResult<R> handle) {
                this.action = action;
                this.handle = handle;
            }

            @Override
            public void run() {
                try {
                    this.handle.result = this.action.get();
                }
                catch (Exception ex) {
                    this.handle.error = ex;
                }
                this.handle.completed = true;
            }
        }
        JobActionWithReturn job = new JobActionWithReturn(action, handle);
        if (Thread.currentThread() == runner) {
            job.run();
        } else {
            WorkThread.pushJob(job);
        }
        return handle;
    }

    private static interface Job {
        public void run();
    }

    public static class JobHandle {
        private Boolean completed = false;
        private Exception error = null;

        public Boolean isCompleted() {
            return this.completed;
        }

        public Optional<Exception> getError() {
            return Optional.ofNullable(this.error);
        }
    }

    public static class JobHandleWithResult<R> {
        private Boolean completed;
        private Exception error = null;
        private R result;

        public Boolean isCompleted() {
            return this.completed;
        }

        public Optional<Exception> getError() {
            return Optional.ofNullable(this.error);
        }

        public Optional<R> getResult() {
            return Optional.ofNullable(this.result);
        }
    }
}

