/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.addon;

import dcshadow.com.moandjiezana.toml.Toml;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonClassLoader;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordAddonMeta;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordIntegrationAddon;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddonLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"Discord Integration Addon-Loader");
    private static final File addonDir = new File(DiscordIntegration.discordDataDir, "addons");
    private static final FilenameFilter jarFilter = (dir, name) -> !new File(dir, name).isDirectory() && name.toLowerCase().endsWith(".jar");
    private static final HashMap<DiscordAddonMeta, DiscordIntegrationAddon> addons = new HashMap();
    private static final AddonClassLoader classLoader = new AddonClassLoader(AddonLoader.class.getClassLoader());

    public static AddonClassLoader getAddonClassLoader() {
        return classLoader;
    }

    public static void loadAddon(DiscordIntegration dc, File jar) {
        block10: {
            try {
                JarFile jf = new JarFile(jar);
                JarEntry entry = jf.getJarEntry("DiscordIntegrationAddon.toml");
                if (entry != null) {
                    InputStream is = jf.getInputStream(entry);
                    DiscordAddonMeta addonMeta = new Toml().read(is).to(DiscordAddonMeta.class);
                    is.close();
                    if (addonMeta.getClassPath() == null || addonMeta.getName() == null || addonMeta.getVersion() == null) {
                        LOGGER.error("Failed to load Addon '" + jar.getName() + "'! Toml is missing parameters! (Required are name, version, classPath)");
                        return;
                    }
                    if (addonMeta.getAPIVersion() < 3) {
                        LOGGER.error("Failed to load Addon '" + jar.getName() + "' as it was meant for an older API version (addon: " + addonMeta.getAPIVersion() + ", current: " + 3 + ")!");
                        return;
                    }
                    try {
                        classLoader.add(jar.toURI().toURL());
                        Class<DiscordIntegrationAddon> addonClass = Class.forName(addonMeta.getClassPath(), true, classLoader).asSubclass(DiscordIntegrationAddon.class);
                        DiscordIntegrationAddon addon = addonClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        addons.put(addonMeta, addon);
                        try {
                            addon.load(dc);
                        }
                        catch (Exception e) {
                            LOGGER.error("An exception occurred while loading addon " + addonMeta.getName());
                            e.printStackTrace();
                        }
                        break block10;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        LOGGER.error("Failed to load Addon '" + addonMeta.getName() + "' version '" + addonMeta.getVersion() + "'!");
                        e.printStackTrace();
                        break block10;
                    }
                    catch (NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                LOGGER.error("Found non-addon jar file " + jar.getName());
            }
            catch (IOException e) {
                LOGGER.error("Failed to load addon " + jar.getName());
                e.printStackTrace();
            }
        }
    }

    public static void loadAddons(DiscordIntegration dc) {
        File[] jars;
        if (!addonDir.exists()) {
            addonDir.mkdirs();
        }
        if ((jars = addonDir.listFiles(jarFilter)) != null) {
            for (File jar : jars) {
                AddonLoader.loadAddon(dc, jar);
            }
        }
    }

    public static void unloadAddons(DiscordIntegration discord) {
        for (DiscordIntegrationAddon addon : addons.values()) {
            try {
                addon.unload(discord);
            }
            catch (Exception e) {
                LOGGER.error("An exception occurred while unloading addon class " + addon.getClass().getName());
                e.printStackTrace();
            }
        }
        addons.clear();
    }

    public static DiscordAddonMeta getAddonMeta(DiscordIntegrationAddon inst) {
        AtomicReference meta = new AtomicReference();
        addons.forEach((a, b) -> {
            if (b.equals(inst)) {
                meta.set(a);
            }
        });
        return (DiscordAddonMeta)meta.get();
    }

    public static Set<DiscordAddonMeta> getAddonMetas() {
        return addons.keySet();
    }

    public static Collection<DiscordIntegrationAddon> getAddons() {
        return addons.values();
    }

    public static void reloadAll() {
        AddonLoader.getAddons().forEach(DiscordIntegrationAddon::reload);
    }

    public static File getAddonDir() {
        return addonDir;
    }
}

