/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.minecraftCommands;

import dcshadow.net.kyori.adventure.text.Component;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.MCSubCommand;
import java.util.ArrayList;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;

public class RawMsgCommand
implements MCSubCommand {
    @Override
    public String getName() {
        return "rawmsg";
    }

    @Override
    public Component execute(String[] params, UUID playerUUID) {
        GuildMessageChannel c;
        if (params.length == 0) {
            return Component.text("Not enough arguments");
        }
        if (params[0].startsWith("{")) {
            c = DiscordIntegration.INSTANCE.getChannel();
        } else {
            try {
                long id = Long.parseLong(params[0]);
                c = DiscordIntegration.INSTANCE.getChannel(String.valueOf(id));
                params[0] = "";
            }
            catch (NumberFormatException e) {
                return Component.text("Invalid argument. First argument must be either the channel or the json.");
            }
        }
        StringBuilder b = new StringBuilder();
        for (String param : params) {
            b.append(param).append(" ");
        }
        DataObject dataObject = DataObject.fromJson(b.toString().trim());
        c.sendMessage(this.fromJson(dataObject)).queue();
        return Component.empty();
    }

    private MessageCreateData fromJson(DataObject json) {
        MessageCreateBuilder message = new MessageCreateBuilder();
        if (json.hasKey("content")) {
            message.setContent(json.getString("content"));
        }
        if (json.hasKey("embeds")) {
            DataArray embedsArray = json.getArray("embeds");
            ArrayList<MessageEmbed> embeds = new ArrayList<MessageEmbed>();
            for (int i = 0; i < embedsArray.length(); ++i) {
                DataObject embedJson = embedsArray.getObject(i);
                EmbedBuilder embed = EmbedBuilder.fromData(embedJson);
                embeds.add(embed.build());
            }
            message.setEmbeds(embeds);
        }
        if (json.hasKey("tts")) {
            message.setTTS(json.getBoolean("tts"));
        }
        return message.build();
    }

    @Override
    public MCSubCommand.CommandType getType() {
        return MCSubCommand.CommandType.BOTH;
    }

    @Override
    public boolean needsOP() {
        return true;
    }
}

