/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.com.vdurmont.emoji.EmojiParser;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEventSource;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import dcshadow.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import de.erdbeerbaerlp.dcintegration.architectury.DiscordIntegrationMod;
import de.erdbeerbaerlp.dcintegration.architectury.command.DCCommandSender;
import de.erdbeerbaerlp.dcintegration.architectury.util.SerializeComponentUtils;
import de.erdbeerbaerlp.dcintegration.architectury.util.fabric.ServerInterfaceImpl;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.util.ComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.util.McServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.requests.RestAction;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7887;

public class ServerInterface
implements McServerInterface {
    public int getMaxPlayers() {
        return DiscordIntegrationMod.server.method_3802();
    }

    public int getOnlinePlayers() {
        return DiscordIntegrationMod.server.method_3788();
    }

    public void sendIngameMessage(Component msg) {
        List l = DiscordIntegrationMod.server.method_3760().method_14571();
        try {
            for (class_3222 p : l) {
                if (!this.playerHasPermissions((class_1657)p, MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER) || DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.method_5667())) continue;
                Map.Entry ping = ComponentUtils.parsePing((Component)msg, (UUID)p.method_5667(), (String)p.method_5477().getString());
                String jsonComp = ((String)GsonComponentSerializer.gson().serialize((Component)ping.getValue())).replace("\\\\n", "\n");
                class_5250 comp = SerializeComponentUtils.fromJson(jsonComp, p.method_51469().method_30349());
                if (LinkManager.isPlayerLinked((UUID)p.method_5667())) {
                    PlayerLink link = LinkManager.getLink(null, (UUID)p.method_5667());
                    if (link.settings.ignoreDiscordChatIngame) continue;
                    if (((Boolean)ping.getKey()).booleanValue() && LinkManager.isPlayerLinked((UUID)p.method_5667()) && link.settings.pingSound) {
                        p.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_14622, class_3419.field_15250, p.method_73189().field_1352, p.method_73189().field_1351, p.method_73189().field_1350, 1.0f, 1.0f, DiscordIntegrationMod.server.method_30002().method_8412()));
                    }
                }
                p.method_43502((class_2561)comp, false);
            }
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msg)).replace("\\\\n", "\n");
            class_5250 comp = SerializeComponentUtils.fromJson(jsonComp, class_7887.method_46817());
            DiscordIntegrationMod.server.method_43496((class_2561)comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendIngameReaction(Member member, RestAction<Message> retrieveMessage, UUID targetUUID, EmojiUnion reactionEmote) {
        List l = DiscordIntegrationMod.server.method_3760().method_14571();
        for (class_3222 p : l) {
            if (!this.playerHasPermissions((class_1657)p, MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER) || !p.method_5667().equals(targetUUID) || DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.method_5667())) continue;
            if (LinkManager.isPlayerLinked((UUID)p.method_5667())) {
                PlayerLink link = LinkManager.getLink(null, (UUID)p.method_5667());
                if (link.settings.ignoreDiscordChatIngame || link.settings.ignoreReactions) continue;
            }
            Object emote = reactionEmote.getType() == Emoji.Type.UNICODE ? EmojiParser.parseToAliases((String)reactionEmote.getName()) : ":" + reactionEmote.getName() + ":";
            Style.Builder memberStyle = Style.style();
            if (Configuration.instance().messages.discordRoleColorIngame) {
                memberStyle = memberStyle.color(TextColor.color((int)member.getColorRaw()));
            }
            Component user = Component.text((String)member.getEffectiveName()).style(memberStyle.clickEvent(ClickEvent.suggestCommand((String)("@" + (member.getUser().getDiscriminator().equals("0000") ? member.getUser().getName() : member.getUser().getAsTag())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)Localization.instance().discordUserHover.replace("%user#tag%", member.getUser().getDiscriminator().equals("0000") ? member.getUser().getName() : member.getUser().getAsTag()).replace("%user%", member.getEffectiveName()).replace("%id%", member.getUser().getId())))));
            TextReplacementConfig userReplacer = ComponentUtils.replaceLiteral((String)"%user%", (Component)user);
            TextReplacementConfig usernameReplacer = ComponentUtils.replaceLiteral((String)"%name%", (Component)user);
            TextReplacementConfig emoteReplacer = ComponentUtils.replaceLiteral((String)"%emote%", (String)emote);
            Component out = LegacyComponentSerializer.legacySection().deserialize(Localization.instance().reactionMessage).replaceText(userReplacer).replaceText(usernameReplacer).replaceText(emoteReplacer);
            if (Localization.instance().reactionMessage.contains("%msg%")) {
                retrieveMessage.submit().thenAccept(m -> {
                    String msg = MessageUtils.formatEmoteMessage((List)m.getMentions().getCustomEmojis(), (String)m.getContentDisplay());
                    TextReplacementConfig msgReplacer = ComponentUtils.replaceLiteral((String)"%msg%", (String)msg);
                    this.sendReactionMCMessage(p, out.replaceText(msgReplacer));
                });
                continue;
            }
            this.sendReactionMCMessage(p, out);
        }
    }

    private void sendReactionMCMessage(class_3222 target, Component msgComp) {
        String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msgComp)).replace("\\\\n", "\n");
        try {
            class_5250 comp = SerializeComponentUtils.fromJson(jsonComp, target.method_51469().method_30349());
            target.method_43502((class_2561)comp, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runMcCommand(String cmd, CompletableFuture<InteractionHook> cmdMsg, User user) {
        DCCommandSender s = new DCCommandSender(cmdMsg, user);
        try {
            DiscordIntegrationMod.server.method_3734().method_9235().execute(cmd.trim(), (Object)s.createCommandSourceStack());
        }
        catch (CommandSyntaxException e) {
            s.method_43496((class_2561)class_2561.method_43470((String)e.getMessage()));
        }
    }

    public HashMap<UUID, String> getPlayers() {
        HashMap<UUID, String> players = new HashMap<UUID, String>();
        for (class_3222 p : DiscordIntegrationMod.server.method_3760().method_14571()) {
            players.put(p.method_5667(), p.method_5476().getString().isEmpty() ? p.method_5477().getString() : p.method_5476().getString());
        }
        return players;
    }

    public void sendIngameMessage(String msg, UUID player) {
        class_3222 p = DiscordIntegrationMod.server.method_3760().method_14602(player);
        if (p != null) {
            p.method_64398((class_2561)class_2561.method_43470((String)msg));
        }
    }

    public boolean isOnlineMode() {
        return Configuration.instance().bungee.isBehindBungee || DiscordIntegrationMod.server.method_3828();
    }

    public String getNameFromUUID(UUID uuid) {
        return ((GameProfile)DiscordIntegrationMod.server.method_73550().comp_4624().method_73290(uuid).orElseThrow()).name();
    }

    public boolean playerHasPermissions(UUID player, String ... permissions) {
        return ServerInterface.playerHasPermissionsX(player, permissions);
    }

    public boolean playerHasPermissions(class_1657 player, String ... permissions) {
        return ServerInterface.playerHasPermissionsX(player, permissions);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean playerHasPermissionsX(UUID player, String ... permissions) {
        void var1_1;
        return ServerInterfaceImpl.playerHasPermissionsX(player, (String[])var1_1);
    }

    public String runMCCommand(String cmd) {
        DCCommandSender s = new DCCommandSender();
        try {
            DiscordIntegrationMod.server.method_3734().method_9235().execute(cmd.trim(), (Object)s.createCommandSourceStack());
            return s.message.toString();
        }
        catch (CommandSyntaxException e) {
            return e.getMessage();
        }
    }

    public boolean isPlayerVanish(UUID player) {
        return ServerInterface.checkVanish(player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean checkVanish(UUID player) {
        return ServerInterfaceImpl.checkVanish(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean playerHasPermissionsX(class_1657 player, String ... permissions) {
        void var1_1;
        return ServerInterfaceImpl.playerHasPermissionsX(player, (String[])var1_1);
    }

    public boolean playerHasPermissions(class_1657 player, MinecraftPermission ... permissions) {
        String[] permissionStrings = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            permissionStrings[i] = permissions[i].getAsString();
        }
        return this.playerHasPermissions(player, permissionStrings);
    }

    public String getLoaderName() {
        return ServerInterface.getLoaderNameX();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static String getLoaderNameX() {
        return ServerInterfaceImpl.getLoaderNameX();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getLoaderVersion() {
        return ServerInterfaceImpl.getLoaderVersion();
    }
}

