/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury;

import com.mojang.brigadier.CommandDispatcher;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.architectury.api.ArchitecturyDiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.architectury.command.McCommandDiscord;
import de.erdbeerbaerlp.dcintegration.architectury.metrics.Metrics;
import de.erdbeerbaerlp.dcintegration.architectury.util.MessageUtilsImpl;
import de.erdbeerbaerlp.dcintegration.architectury.util.SerializeComponentUtils;
import de.erdbeerbaerlp.dcintegration.architectury.util.ServerInterface;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonLoader;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordAddonMeta;
import de.erdbeerbaerlp.dcintegration.common.storage.CommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.DownloadSourceChecker;
import de.erdbeerbaerlp.dcintegration.common.util.McServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import de.erdbeerbaerlp.dcintegration.common.util.UpdateChecker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;

public final class DiscordIntegrationMod {
    public static final String MOD_ID = "dcintegration";
    public static MinecraftServer server = null;
    public static Metrics bstats;
    public static boolean stopped;
    public static final ArrayList<UUID> timeouts;
    private static final Pattern mentionPattern;
    private static final Pattern legacyMentionPattern;

    public static void init() {
        try {
            DiscordIntegration.loadConfigs();
        }
        catch (IOException e) {
            DiscordIntegration.LOGGER.error("Config loading failed");
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            DiscordIntegration.LOGGER.error("Failed to read config file! Please check your config file!\nError description: " + e.getMessage());
            DiscordIntegration.LOGGER.error("\nStacktrace: ");
            e.printStackTrace();
        }
    }

    public static void serverStarting(MinecraftServer minecraftServer) {
        server = minecraftServer;
        DiscordIntegration.INSTANCE = new DiscordIntegration((McServerInterface)new ServerInterface());
        try {
            DiscordIntegration.LOGGER.info("Waiting for JDA to initialize to send starting message... (max 5 seconds before skipping)");
            for (int i = 0; i <= 5 && DiscordIntegration.INSTANCE.getJDA() == null; ++i) {
                Thread.sleep(1000L);
            }
            if (DiscordIntegration.INSTANCE.getJDA() != null) {
                Thread.sleep(2000L);
                CommandRegistry.registerDefaultCommands();
                if (!Localization.instance().serverStarting.isEmpty() && !Localization.instance().serverStarting.isBlank() && DiscordIntegration.INSTANCE.getChannel() != null) {
                    MessageCreateData m = Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed ? ((MessageCreateBuilder)new MessageCreateBuilder().setEmbeds(new MessageEmbed[]{Configuration.instance().embedMode.startMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStarting).build()})).build() : new MessageCreateBuilder().addContent(Localization.instance().serverStarting).build();
                    DiscordIntegration.startingMsg = DiscordIntegration.INSTANCE.sendMessageReturns(m, DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
        }
        catch (InterruptedException | NullPointerException exception) {
            // empty catch block
        }
        new McCommandDiscord((CommandDispatcher<class_2168>)minecraftServer.method_3734().method_9235());
    }

    public static void serverStarted(MinecraftServer minecraftServer) {
        DiscordIntegration.LOGGER.info("Started");
        if (DiscordIntegration.INSTANCE != null) {
            DiscordIntegration.started = new Date().getTime();
            if (!Localization.instance().serverStarted.isBlank()) {
                if (DiscordIntegration.startingMsg != null) {
                    if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed) {
                        if (!Configuration.instance().embedMode.startMessages.customJSON.isBlank()) {
                            EmbedBuilder b = Configuration.instance().embedMode.startMessages.toEmbedJson(Configuration.instance().embedMode.startMessages.customJSON);
                            DiscordIntegration.startingMsg.thenAccept(a -> a.editMessageEmbeds(new MessageEmbed[]{b.build()}).queue());
                        } else {
                            DiscordIntegration.startingMsg.thenAccept(a -> a.editMessageEmbeds(new MessageEmbed[]{Configuration.instance().embedMode.startMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStarted).build()}).queue());
                        }
                    } else {
                        DiscordIntegration.startingMsg.thenAccept(a -> a.editMessage((CharSequence)Localization.instance().serverStarted).queue());
                    }
                } else if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.startMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.startMessages.toEmbedJson(Configuration.instance().embedMode.startMessages.customJSON);
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    } else {
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(Configuration.instance().embedMode.startMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStarted).build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().serverStarted, (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
            DiscordIntegration.INSTANCE.startThreads();
        }
        UpdateChecker.runUpdateCheck((String)"https://raw.githubusercontent.com/ErdbeerbaerLP/DiscordIntegration/1.21.1/update-checker.json");
        if (!DownloadSourceChecker.checkDownloadSource((File)new File(DiscordIntegrationMod.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("%")[0]))) {
            DiscordIntegration.LOGGER.warn("You likely got this mod from a third party website.");
            DiscordIntegration.LOGGER.warn("Some of such websites are distributing malware or old versions.");
            DiscordIntegration.LOGGER.warn("Download this mod from an official source (https://modrinth.com/plugin/dcintegration) to hide this message");
            DiscordIntegration.LOGGER.warn("This warning can also be suppressed in the config file");
        }
        if (minecraftServer != null) {
            Metrics.capturedServer.set(minecraftServer);
            if (bstats == null) {
                bstats = new Metrics(9765);
            }
        }
        bstats.addCustomChart(new Metrics.DrilldownPie("addons", () -> {
            HashMap map = new HashMap();
            if (Configuration.instance().bstats.sendAddonStats) {
                for (DiscordAddonMeta m : AddonLoader.getAddonMetas()) {
                    HashMap<String, Integer> entry = new HashMap<String, Integer>();
                    entry.put(m.getVersion(), 1);
                    map.put(m.getName(), entry);
                }
            }
            return map;
        }));
    }

    public static void serverStopping(MinecraftServer minecraftServer) {
        Metrics.MetricsBase.scheduler.shutdownNow();
        if (DiscordIntegration.INSTANCE != null) {
            if (!Localization.instance().serverStopped.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.stopMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.stopMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.stopMessages.toEmbedJson(Configuration.instance().embedMode.stopMessages.customJSON);
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(Configuration.instance().embedMode.stopMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverStopped).build()));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().serverStopped);
                }
            }
            DiscordIntegration.INSTANCE.stopThreads();
        }
        stopped = true;
    }

    public static void serverStopped(MinecraftServer minecraftServer) {
        Metrics.MetricsBase.scheduler.shutdownNow();
        if (DiscordIntegration.INSTANCE != null) {
            if (!stopped && DiscordIntegration.INSTANCE.getJDA() != null) {
                minecraftServer.execute(() -> {
                    DiscordIntegration.INSTANCE.stopThreads();
                    if (!Localization.instance().serverCrash.isBlank()) {
                        try {
                            if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.stopMessages.asEmbed) {
                                DiscordIntegration.INSTANCE.sendMessageReturns(((MessageCreateBuilder)new MessageCreateBuilder().addEmbeds(new MessageEmbed[]{Configuration.instance().embedMode.stopMessages.toEmbed().setDescription((CharSequence)Localization.instance().serverCrash).build()})).build(), DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID)).get();
                            } else {
                                DiscordIntegration.INSTANCE.sendMessageReturns(((MessageCreateBuilder)new MessageCreateBuilder().setContent(Localization.instance().serverCrash)).build(), DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID)).get();
                            }
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            // empty catch block
                        }
                    }
                });
            }
            DiscordIntegration.INSTANCE.kill(false);
        }
    }

    public static void vanish(class_3222 player, boolean vanished) {
        if (vanished) {
            if (LinkManager.isPlayerLinked((UUID)player.method_5667()) && LinkManager.getLink(null, (UUID)player.method_5667()).settings.hideFromDiscord) {
                return;
            }
            String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", player.method_5477().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
            if (DiscordIntegration.INSTANCE != null && !timeouts.contains(player.method_5667()) && !Localization.instance().playerLeave.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerLeaveMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.playerLeaveMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbedJson(Configuration.instance().embedMode.playerLeaveMessages.customJSON.replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(player)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID((UUID)player.method_5667()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbed().setAuthor(MessageUtilsImpl.formatPlayerName(player), null, avatarURL).setDescription((CharSequence)Localization.instance().playerLeave.replace("%player%", MessageUtilsImpl.formatPlayerName(player)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerLeave.replace("%player%", MessageUtilsImpl.formatPlayerName(player)), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
        } else {
            if (LinkManager.isPlayerLinked((UUID)player.method_5667()) && LinkManager.getLink(null, (UUID)player.method_5667()).settings.hideFromDiscord) {
                return;
            }
            if (!Localization.instance().playerJoin.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerJoinMessage.asEmbed) {
                    String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", player.method_5477().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.playerJoinMessage.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbedJson(Configuration.instance().embedMode.playerJoinMessage.customJSON.replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(player)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID((UUID)player.method_5667()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbed();
                        b.setAuthor(MessageUtilsImpl.formatPlayerName(player), null, avatarURL).setDescription((CharSequence)Localization.instance().playerJoin.replace("%player%", MessageUtilsImpl.formatPlayerName(player)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerJoin.replace("%player%", MessageUtilsImpl.formatPlayerName(player)), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
        }
    }

    public static class_7471 handleChatMessage(class_7471 message, class_3222 player) {
        if (DiscordIntegration.INSTANCE == null) {
            return message;
        }
        if (DiscordIntegration.INSTANCE.getServerInterface().isPlayerVanish(player.method_5667())) {
            return message;
        }
        if (!((ServerInterface)DiscordIntegration.INSTANCE.getServerInterface()).playerHasPermissions((class_1657)player, MinecraftPermission.SEMD_MESSAGES, MinecraftPermission.USER)) {
            return message;
        }
        if (LinkManager.isPlayerLinked((UUID)player.method_5667()) && LinkManager.getLink(null, (UUID)player.method_5667()).settings.hideFromDiscord) {
            return message;
        }
        class_7471 finalMessage = message;
        MessageEmbed embed = MessageUtilsImpl.genItemStackEmbedIfAvailable(message.method_46291(), (class_1937)player.method_51469());
        if (DiscordIntegration.INSTANCE != null) {
            String text = message.method_46291().getString();
            if (DiscordIntegration.INSTANCE.callEvent(e -> {
                if (e instanceof ArchitecturyDiscordEventHandler) {
                    return ((ArchitecturyDiscordEventHandler)((Object)e)).onMcChatMessage(finalMessage.method_46291(), player);
                }
                return false;
            })) {
                return message;
            }
            GuildMessageChannel channel = DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID);
            if (channel == null) {
                return message;
            }
            String json = SerializeComponentUtils.toJson(message.method_46291(), player.method_51469().method_30349());
            Component comp = GsonComponentSerializer.gson().deserialize((Object)json);
            if (DiscordIntegration.INSTANCE.callEvent(e -> e.onMinecraftMessage(comp, player.method_5667()))) {
                return message;
            }
            if (!Configuration.instance().compatibility.disableParsingMentionsIngame && text.contains("@") && (text = mentionPattern.matcher(text).replaceAll(mr -> {
                String username = mr.group(1);
                DiscordIntegration.LOGGER.info(username);
                Iterator iterator = DiscordIntegration.INSTANCE.getChannel().getGuild().getMembersByName(username, false).iterator();
                if (iterator.hasNext()) {
                    Member member = (Member)iterator.next();
                    return member.getAsMention();
                }
                iterator = DiscordIntegration.INSTANCE.getJDA().getUsersByName(username, false).iterator();
                if (iterator.hasNext()) {
                    User user = (User)iterator.next();
                    return user.getAsMention();
                }
                return mr.group(0);
            })).contains("#")) {
                text = legacyMentionPattern.matcher(text).replaceAll(mr -> {
                    String tag = mr.group(1);
                    DiscordIntegration.LOGGER.info(tag);
                    Member member = DiscordIntegration.INSTANCE.getChannel().getGuild().getMemberByTag(tag);
                    if (member != null) {
                        return member.getAsMention();
                    }
                    User user = DiscordIntegration.INSTANCE.getJDA().getUserByTag(tag);
                    if (user != null) {
                        return user.getAsMention();
                    }
                    return mr.group(0);
                });
            }
            text = MessageUtils.escapeMarkdown((String)text);
            if (!Localization.instance().discordChatMessage.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.chatMessages.asEmbed) {
                    String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", player.method_5477().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.chatMessages.customJSON.isBlank()) {
                        b = Configuration.instance().embedMode.chatMessages.toEmbedJson(Configuration.instance().embedMode.chatMessages.customJSON.replace("%uuid%", player.method_5667().toString()).replace("%uuid_dashless%", player.method_5667().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(player)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%msg%", text).replace("%playerColor%", "" + TextColors.generateFromUUID((UUID)player.method_5667()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID));
                    } else {
                        b = Configuration.instance().embedMode.chatMessages.toEmbed();
                        if (Configuration.instance().embedMode.chatMessages.generateUniqueColors) {
                            b = b.setColor(TextColors.generateFromUUID((UUID)player.method_5667()));
                        }
                        b = b.setAuthor(MessageUtilsImpl.formatPlayerName(player), null, avatarURL).setDescription((CharSequence)text);
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(MessageUtilsImpl.formatPlayerName(player), player.method_5667().toString(), new DiscordMessage(embed, text, true), (MessageChannel)channel);
                }
            }
            if (!Configuration.instance().compatibility.disableParsingMentionsIngame) {
                String editedJson = (String)GsonComponentSerializer.gson().serialize(MessageUtils.mentionsToNames((Component)comp, (Guild)channel.getGuild()));
                class_5250 txt = SerializeComponentUtils.fromJson(editedJson, player.method_51469().method_30349());
                message = message.method_44863((class_2561)txt);
            }
        }
        return message;
    }

    static {
        stopped = false;
        timeouts = new ArrayList();
        mentionPattern = Pattern.compile("@([a-z0-9_.]{2,32})");
        legacyMentionPattern = Pattern.compile("@(.{3,32}#[0-9]{4})");
    }
}

