/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.mixin;

import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.architectury.util.MessageUtilsImpl;
import de.erdbeerbaerlp.dcintegration.architectury.util.SerializeComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.WorkThread;
import de.erdbeerbaerlp.dcintegration.common.compat.FloodgateUtils;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import java.net.SocketAddress;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.minecraft.class_11560;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7887;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Inject(method={"canPlayerLogin"}, at={@At(value="HEAD")}, cancellable=true)
    public void canJoin(SocketAddress socketAddress, class_11560 nameAndId, CallbackInfoReturnable<class_2561> cir) {
        if (DiscordIntegration.INSTANCE == null) {
            return;
        }
        LinkManager.checkGlobalAPI((UUID)nameAndId.comp_4422());
        Component eventKick = (Component)DiscordIntegration.INSTANCE.callEventO(e -> e.onPlayerJoin(nameAndId.comp_4422()));
        if (eventKick != null) {
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(eventKick)).replace("\\\\n", "\n");
            try {
                class_5250 comp = SerializeComponentUtils.fromJson(jsonComp, class_7887.method_46817());
                cir.setReturnValue((Object)comp);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (Configuration.instance().linking.whitelistMode && DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            try {
                if (!LinkManager.isPlayerLinked((UUID)nameAndId.comp_4422())) {
                    cir.setReturnValue((Object)class_2561.method_43470((String)Localization.instance().linking.notWhitelistedCode.replace("%code%", "" + (FloodgateUtils.isBedrockPlayer((UUID)nameAndId.comp_4422()) ? LinkManager.genBedrockLinkNumber((UUID)nameAndId.comp_4422()) : LinkManager.genLinkNumber((UUID)nameAndId.comp_4422())))));
                } else if (!DiscordIntegration.INSTANCE.canPlayerJoin(nameAndId.comp_4422())) {
                    cir.setReturnValue((Object)class_2561.method_43470((String)Localization.instance().linking.notWhitelistedRole));
                }
            }
            catch (IllegalStateException e3) {
                cir.setReturnValue((Object)class_2561.method_43470((String)("An error occured\nPlease check Server Log for more information\n\n" + String.valueOf(e3))));
                e3.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"placeNewPlayer"})
    private void onPlayerJoin(class_2535 connection, class_3222 p, class_8792 commonListenerCookie, CallbackInfo ci) {
        if (DiscordIntegration.INSTANCE != null) {
            if (DiscordIntegration.INSTANCE.getServerInterface().isPlayerVanish(p.method_5667())) {
                return;
            }
            if (LinkManager.isPlayerLinked((UUID)p.method_5667()) && LinkManager.getLink(null, (UUID)p.method_5667()).settings.hideFromDiscord) {
                return;
            }
            LinkManager.checkGlobalAPI((UUID)p.method_5667());
            if (!Localization.instance().playerJoin.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerJoinMessage.asEmbed) {
                    String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", p.method_5667().toString()).replace("%uuid_dashless%", p.method_5667().toString().replace("-", "")).replace("%name%", p.method_5477().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.playerJoinMessage.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbedJson(Configuration.instance().embedMode.playerJoinMessage.customJSON.replace("%uuid%", p.method_5667().toString()).replace("%uuid_dashless%", p.method_5667().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(p)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID((UUID)p.method_5667()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbed();
                        b.setAuthor(MessageUtilsImpl.formatPlayerName(p), null, avatarURL).setDescription((CharSequence)Localization.instance().playerJoin.replace("%player%", MessageUtilsImpl.formatPlayerName(p)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerJoin.replace("%player%", MessageUtilsImpl.formatPlayerName(p)), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
            WorkThread.executeJob(() -> {
                UUID uuid = p.method_5667();
                if (!LinkManager.isPlayerLinked((UUID)uuid)) {
                    return;
                }
                Member member = DiscordIntegration.INSTANCE.getMemberById(LinkManager.getLink(null, (UUID)uuid).discordID);
                if (Configuration.instance().linking.shouldNickname) {
                    member.modifyNickname(MessageUtilsImpl.formatPlayerName(p)).queue();
                }
                if (Configuration.instance().linking.linkedRoleID.equals("0")) {
                    return;
                }
                Guild guild = DiscordIntegration.INSTANCE.getChannel().getGuild();
                Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
                if (!member.getRoles().contains(linkedRole)) {
                    guild.addRoleToMember((UserSnowflake)member, linkedRole).queue();
                }
            });
        }
    }
}

