/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.shaded.styledchat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.StyledChatMod;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.StyledChatUtils;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.ConfigManager;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.ChatStyleData;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.other.GenericModInfo;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class Commands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"styledchat").requires(Permissions.require((String)"styledchat.main", (boolean)true))).executes(Commands::about)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"styledchat.reload", (int)3))).executes(Commands::reloadConfig))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(Permissions.require((String)"styledchat.set", (int)2))).then(Commands.fillWithProperties(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()), (x, p) -> x.then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Commands.setProperty((CommandContext<class_2168>)ctx, (ChatStyleData.PropertyGetSet)p.apply(ctx)))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(Permissions.require((String)"styledchat.get", (int)2))).then(Commands.fillWithProperties(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()), (x, p) -> x.executes(ctx -> Commands.getProperty((CommandContext<class_2168>)ctx, (ChatStyleData.PropertyGetSet)p.apply(ctx))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(Permissions.require((String)"styledchat.clear", (int)3))).then(Commands.fillWithProperties(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()), (x, p) -> x.executes(ctx -> Commands.clearProperty((CommandContext<class_2168>)ctx, (ChatStyleData.PropertyGetSet)p.apply(ctx)))).then(class_2170.method_9247((String)"*").executes(ctx -> Commands.clearProperty((CommandContext<class_2168>)ctx, null))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tellform").requires(Permissions.require((String)"styledchat.tellform", (int)2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            int i = 0;
            class_2561 parsed = Placeholders.parseText((TextNode)TextNode.asSingle((TextNode[])StyledChatUtils.createParser((class_2168)context.getSource()).parseNodes(TextNode.of((String)StringArgumentType.getString((CommandContext)context, (String)"message")))), (PlaceholderContext)PlaceholderContext.of((class_2168)((class_2168)context.getSource())));
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"targets")) {
                player.method_64398(parsed);
            }
            return i;
        }))));
    }

    private static int getProperty(CommandContext<class_2168> context, ChatStyleData.PropertyGetSet propertyGetSet) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        ChatStyleData data = StyledChatUtils.getPersonalData(player);
        if (data == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"<not set>").method_27692(class_124.field_1056), false);
            return 0;
        }
        String val = propertyGetSet.get(data);
        if (val == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"<not set>").method_27692(class_124.field_1056), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)val), false);
        return 1;
    }

    private static int setProperty(CommandContext<class_2168> context, ChatStyleData.PropertyGetSet propertySet) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        String val = StringArgumentType.getString(context, (String)"value");
        for (class_3222 player : players) {
            propertySet.set(StyledChatUtils.getOrCreatePersonalData(player), val);
            StyledChatUtils.updateStyle(player);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Changed style of " + players.size() + " player(s)")), false);
        return players.size();
    }

    private static int clearProperty(CommandContext<class_2168> context, ChatStyleData.PropertyGetSet propertySet) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        for (class_3222 player : players) {
            if (propertySet != null) {
                propertySet.set(StyledChatUtils.getOrCreatePersonalData(player), null);
            } else {
                StyledChatUtils.clearPersonalStyleData(player);
            }
            StyledChatUtils.updateStyle(player);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Cleared style for " + players.size() + " player(s)")), false);
        return players.size();
    }

    private static ArgumentBuilder<class_2168, ?> fillWithProperties(ArgumentBuilder<class_2168, ?> base, BiConsumer<ArgumentBuilder<class_2168, ?>, Function<CommandContext<class_2168>, ChatStyleData.PropertyGetSet>> command) {
        for (Map.Entry<String, ChatStyleData.PropertyGetSet> prop : ChatStyleData.PROPERTIES.entrySet()) {
            LiteralArgumentBuilder x = class_2170.method_9247((String)prop.getKey());
            command.accept((ArgumentBuilder<class_2168, ?>)x, (Function<CommandContext<class_2168>, ChatStyleData.PropertyGetSet>)((Function<CommandContext, ChatStyleData.PropertyGetSet>)ctx -> (ChatStyleData.PropertyGetSet)prop.getValue()));
            base = base.then((ArgumentBuilder)x);
        }
        RequiredArgumentBuilder x = class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            for (class_2960 id : ((class_2168)context.getSource()).method_9211().method_30611().method_30530(class_7924.field_41237).method_10235()) {
                if (id.method_12836().equals("minecraft") || id.equals((Object)StyledChatMod.MESSAGE_TYPE_ID.method_29177())) continue;
                builder.suggest(id.toString());
            }
            return builder.buildFuture();
        });
        command.accept((ArgumentBuilder<class_2168, ?>)x, (Function<CommandContext<class_2168>, ChatStyleData.PropertyGetSet>)((Function<CommandContext, ChatStyleData.PropertyGetSet>)ctx -> ChatStyleData.PropertyGetSet.ofCustom(class_2232.method_9443((CommandContext)ctx, (String)"id").toString())));
        base = base.then(class_2170.method_9247((String)"custom").then((ArgumentBuilder)x));
        return base;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        Set<String> old = ConfigManager.getConfig().allPossibleAutoCompletionKeys;
        if (ConfigManager.loadConfig((class_7225.class_7874)((class_2168)context.getSource()).method_30497())) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloaded config!"), false);
            for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                StyledChatUtils.sendAutoCompletion(player, old);
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error occurred while reloading config! Check console for more information!").method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int about(CommandContext<class_2168> context) {
        for (class_2561 text : ((class_2168)context.getSource()).method_9228() instanceof class_3222 ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((class_2168)context.getSource()).method_9226(() -> text, false);
        }
        return 1;
    }
}

