/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.shaded.styledchat.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.StyledChatUtils;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.ConfigManager;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.ChatStyleData;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.ConfigData;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.DynamicTextNode;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.PatternPlaceholderParser;
import eu.pb4.placeholders.api.parsers.StaticPreParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.MinecraftPredicate;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1321;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ChatStyle {
    public static final ParserContext.Key<Function<String, class_2561>> DYN_KEY = DynamicTextNode.key((String)"styled_chat");
    public static final ChatStyle EMPTY = new ChatStyle(new ChatStyleData());
    public static final NodeParser PARSER = NodeParser.builder().simplifiedTextFormat().quickText().globalPlaceholders().placeholders(TagLikeParser.PLACEHOLDER_USER, DYN_KEY).staticPreParsing().build();
    public final MinecraftPredicate require;
    public final TextNode displayName;
    public final TextNode chat;
    public final TextNode join;
    public final TextNode joinFirstTime;
    public final TextNode joinRenamed;
    public final TextNode left;
    public final TextNode death;
    public final TextNode advancementTask;
    public final TextNode advancementChallenge;
    public final TextNode advancementGoal;
    public final TextNode privateMessageSent;
    public final TextNode privateMessageReceived;
    public final TextNode teamChatSent;
    public final TextNode teamChatReceived;
    public final TextNode sayCommand;
    public final TextNode meCommand;
    public final TextNode petDeath;
    public final TextNode spoilerStyle;
    public final String spoilerSymbol;
    public final TextNode linkStyle;
    public final TextNode mentionStyle;
    public final Map<String, TextNode> emoticons = new HashMap<String, TextNode>();
    public final Object2BooleanMap<String> formatting = new Object2BooleanOpenHashMap();
    public final Map<class_2960, TextNode> custom = new HashMap<class_2960, TextNode>();

    public ChatStyle(ChatStyleData data, ChatStyle defaultStyle) {
        MinecraftPredicate minecraftPredicate;
        if (data instanceof ConfigData.RequireChatStyleData) {
            ConfigData.RequireChatStyleData data1 = (ConfigData.RequireChatStyleData)data;
            minecraftPredicate = data1.require;
        } else {
            minecraftPredicate = BuiltinPredicates.operatorLevel((int)0);
        }
        this.require = minecraftPredicate;
        this.displayName = data.displayName != null ? ChatStyle.parseText(data.displayName) : defaultStyle.displayName;
        this.chat = data.messages.chat != null ? ChatStyle.parseText(data.messages.chat) : defaultStyle.chat;
        this.join = data.messages.joinedGame != null ? ChatStyle.parseText(data.messages.joinedGame) : defaultStyle.join;
        this.joinFirstTime = data.messages.joinedForFirstTime != null ? ChatStyle.parseText(data.messages.joinedForFirstTime) : this.join;
        this.joinRenamed = data.messages.joinedAfterNameChange != null ? ChatStyle.parseText(data.messages.joinedAfterNameChange) : defaultStyle.joinRenamed;
        this.left = data.messages.leftGame != null ? ChatStyle.parseText(data.messages.leftGame) : defaultStyle.left;
        this.death = data.messages.baseDeath != null ? ChatStyle.parseText(data.messages.baseDeath) : defaultStyle.death;
        this.advancementTask = data.messages.advancementTask != null ? ChatStyle.parseText(data.messages.advancementTask) : defaultStyle.advancementTask;
        this.advancementChallenge = data.messages.advancementChallenge != null ? ChatStyle.parseText(data.messages.advancementChallenge) : defaultStyle.advancementChallenge;
        this.advancementGoal = data.messages.advancementGoal != null ? ChatStyle.parseText(data.messages.advancementGoal) : defaultStyle.advancementGoal;
        this.privateMessageSent = data.messages.privateMessageSent != null ? ChatStyle.parseText(data.messages.privateMessageSent) : defaultStyle.privateMessageSent;
        this.privateMessageReceived = data.messages.privateMessageReceived != null ? ChatStyle.parseText(data.messages.privateMessageReceived) : defaultStyle.privateMessageReceived;
        this.teamChatSent = data.messages.sentTeamChat != null ? ChatStyle.parseText(data.messages.sentTeamChat) : defaultStyle.teamChatSent;
        this.teamChatReceived = data.messages.receivedTeamChat != null ? ChatStyle.parseText(data.messages.receivedTeamChat) : defaultStyle.teamChatReceived;
        this.sayCommand = data.messages.sayCommandMessage != null ? ChatStyle.parseText(data.messages.sayCommandMessage) : defaultStyle.sayCommand;
        this.meCommand = data.messages.meCommandMessage != null ? ChatStyle.parseText(data.messages.meCommandMessage) : defaultStyle.meCommand;
        this.petDeath = data.messages.petDeathMessage != null ? ChatStyle.parseText(data.messages.petDeathMessage) : defaultStyle.petDeath;
        this.spoilerStyle = data.spoilerStyle != null ? ChatStyle.parseText(data.spoilerStyle) : defaultStyle.spoilerStyle;
        this.spoilerSymbol = data.spoilerSymbol != null ? data.spoilerSymbol : defaultStyle.spoilerSymbol;
        this.linkStyle = data.linkStyle != null ? ChatStyle.parseText(data.linkStyle) : defaultStyle.linkStyle;
        this.mentionStyle = data.mentionStyle != null ? ChatStyle.parseText(data.mentionStyle) : defaultStyle.mentionStyle;
        for (Map.Entry<String, String> entry : data.emoticons.entrySet()) {
            if (entry.getKey().startsWith("$")) {
                this.decodeSpecialEmoticon(entry.getKey(), entry.getValue());
                continue;
            }
            this.emoticons.put(entry.getKey(), ChatStyle.parseText(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : data.formatting.entrySet()) {
            this.formatting.put((Object)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        if (data.custom != null) {
            for (Map.Entry<String, Object> entry : data.custom.entrySet()) {
                class_2960 id = class_2960.method_12829((String)entry.getKey());
                if (id == null) continue;
                this.custom.put(id, ChatStyle.parseText((String)entry.getValue()));
            }
        }
    }

    public ChatStyle(ChatStyleData data) {
        MinecraftPredicate minecraftPredicate;
        if (data instanceof ConfigData.RequireChatStyleData) {
            ConfigData.RequireChatStyleData data1 = (ConfigData.RequireChatStyleData)data;
            minecraftPredicate = data1.require;
        } else {
            minecraftPredicate = BuiltinPredicates.operatorLevel((int)0);
        }
        this.require = minecraftPredicate;
        this.displayName = data.displayName != null ? ChatStyle.parseText(data.displayName) : null;
        this.chat = data.messages.chat != null ? ChatStyle.parseText(data.messages.chat) : null;
        this.join = data.messages.joinedGame != null ? ChatStyle.parseText(data.messages.joinedGame) : null;
        this.joinRenamed = data.messages.joinedAfterNameChange != null ? ChatStyle.parseText(data.messages.joinedAfterNameChange) : null;
        this.joinFirstTime = data.messages.joinedForFirstTime != null ? ChatStyle.parseText(data.messages.joinedForFirstTime) : null;
        this.left = data.messages.leftGame != null ? ChatStyle.parseText(data.messages.leftGame) : null;
        this.death = data.messages.baseDeath != null ? ChatStyle.parseText(data.messages.baseDeath) : null;
        this.advancementTask = data.messages.advancementTask != null ? ChatStyle.parseText(data.messages.advancementTask) : null;
        this.advancementChallenge = data.messages.advancementChallenge != null ? ChatStyle.parseText(data.messages.advancementChallenge) : null;
        this.advancementGoal = data.messages.advancementGoal != null ? ChatStyle.parseText(data.messages.advancementGoal) : null;
        this.privateMessageSent = data.messages.privateMessageSent != null ? ChatStyle.parseText(data.messages.privateMessageSent) : null;
        this.privateMessageReceived = data.messages.privateMessageReceived != null ? ChatStyle.parseText(data.messages.privateMessageReceived) : null;
        this.teamChatSent = data.messages.sentTeamChat != null ? ChatStyle.parseText(data.messages.sentTeamChat) : null;
        this.teamChatReceived = data.messages.receivedTeamChat != null ? ChatStyle.parseText(data.messages.receivedTeamChat) : null;
        this.sayCommand = data.messages.sayCommandMessage != null ? ChatStyle.parseText(data.messages.sayCommandMessage) : null;
        this.meCommand = data.messages.meCommandMessage != null ? ChatStyle.parseText(data.messages.meCommandMessage) : null;
        this.petDeath = data.messages.petDeathMessage != null ? ChatStyle.parseText(data.messages.petDeathMessage) : null;
        this.spoilerStyle = data.spoilerStyle != null ? ChatStyle.parseText(data.spoilerStyle) : null;
        this.spoilerSymbol = data.spoilerSymbol != null ? data.spoilerSymbol : null;
        this.linkStyle = data.linkStyle != null ? ChatStyle.parseText(data.linkStyle) : null;
        this.mentionStyle = data.mentionStyle != null ? ChatStyle.parseText(data.mentionStyle) : null;
        for (Map.Entry<String, String> entry : data.emoticons.entrySet()) {
            if (entry.getKey().startsWith("$")) {
                this.decodeSpecialEmoticon(entry.getKey(), entry.getValue());
                continue;
            }
            this.emoticons.put(entry.getKey(), ChatStyle.parseText(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : data.formatting.entrySet()) {
            this.formatting.put((Object)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        if (data.custom != null) {
            for (Map.Entry<String, Object> entry : data.custom.entrySet()) {
                class_2960 id = class_2960.method_12829((String)entry.getKey());
                if (id == null) continue;
                this.custom.put(id, ChatStyle.parseText((String)entry.getValue()));
            }
        }
    }

    private static TextNode parseText(String input) {
        return !input.isEmpty() ? PARSER.parseNode(input) : EmptyNode.INSTANCE;
    }

    private void decodeSpecialEmoticon(String baseKey, String baseValue) {
        JsonObject json;
        String[] parts = baseKey.substring(1).split(":", 3);
        if (parts.length != 3) {
            return;
        }
        if (parts[1].equals("from_file")) {
            json = ConfigManager.loadJson(parts[2]);
        } else if (parts[1].equals("builtin")) {
            json = ConfigManager.loadJsonBuiltin(parts[2]);
        } else {
            return;
        }
        if (parts[0].equals("default")) {
            try {
                for (Map.Entry entry : json.entrySet()) {
                    this.emoticons.put((String)entry.getKey(), NodeParser.merge((NodeParser[])new NodeParser[]{TextParserV1.DEFAULT, Placeholders.DEFAULT_PLACEHOLDER_PARSER, new PatternPlaceholderParser(PatternPlaceholderParser.PREDEFINED_PLACEHOLDER_PATTERN, x -> ChatStyle.parseText(((JsonElement)entry.getValue()).getAsString())), StaticPreParser.INSTANCE}).parseNode(baseValue));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (parts[0].equals("emojibase") || parts[1].equals("emojibase_unlocked")) {
            try {
                boolean validate = parts[0].equals("emojibase");
                block9: for (Map.Entry entry : json.entrySet()) {
                    StringBuilder b = new StringBuilder();
                    for (String x2 : ((String)entry.getKey()).split("-")) {
                        int i = Integer.parseInt(x2, 16);
                        if (validate && (i >= 127995 && i <= 127999 || i == 65039 || i == 8205)) continue block9;
                        b.appendCodePoint(Integer.parseInt(x2, 16));
                    }
                    TextNode output = NodeParser.merge((NodeParser[])new NodeParser[]{TextParserV1.DEFAULT, Placeholders.DEFAULT_PLACEHOLDER_PARSER, new PatternPlaceholderParser(PatternPlaceholderParser.PREDEFINED_PLACEHOLDER_PATTERN, x -> TextNode.of((String)b.toString())), StaticPreParser.INSTANCE}).parseNode(baseValue);
                    if (((JsonElement)entry.getValue()).isJsonArray()) {
                        for (JsonElement x3 : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                            this.emoticons.put(x3.getAsString(), output);
                        }
                        continue;
                    }
                    this.emoticons.put(((JsonElement)entry.getValue()).getAsString(), output);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (parts[0].equals("cldr")) {
            try {
                json = json.getAsJsonObject("annotations").getAsJsonObject("annotations");
                for (Map.Entry entry : json.entrySet()) {
                    try {
                        TextNode value = NodeParser.merge((NodeParser[])new NodeParser[]{TextParserV1.DEFAULT, Placeholders.DEFAULT_PLACEHOLDER_PARSER, new PatternPlaceholderParser(PatternPlaceholderParser.PREDEFINED_PLACEHOLDER_PATTERN, x -> TextNode.of((String)((String)entry.getKey()))), StaticPreParser.INSTANCE}).parseNode(baseValue);
                        for (JsonElement key : ((JsonElement)entry.getValue()).getAsJsonObject().getAsJsonArray("default")) {
                            this.emoticons.put(key.getAsString().replace(' ', '_').replace(':', '_'), value);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public class_2561 getDisplayName(class_3222 player, class_2561 vanillaDisplayName) {
        if (this.displayName == null) {
            return null;
        }
        if (this.displayName == EmptyNode.INSTANCE) {
            return vanillaDisplayName;
        }
        ParserContext context = PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("vanillaDisplayName", vanillaDisplayName, "player", vanillaDisplayName, "default", vanillaDisplayName, "name", player.method_5477())::get);
        return this.displayName.toText(context);
    }

    @Nullable
    public class_2561 getChat(class_3222 player, class_2561 message) {
        if (this.chat == null) {
            return null;
        }
        if (this.chat == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.chat.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476(), "message", message)::get));
    }

    @Nullable
    public class_2561 getJoin(class_3222 player) {
        if (this.join == null) {
            return null;
        }
        if (this.join == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.join.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476())::get));
    }

    @Nullable
    public class_2561 getJoinFirstTime(class_3222 player) {
        if (this.joinFirstTime == null) {
            return null;
        }
        if (this.joinFirstTime == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.joinFirstTime.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476())::get));
    }

    @Nullable
    public class_2561 getJoinRenamed(class_3222 player, String oldName) {
        if (this.joinRenamed == null) {
            return null;
        }
        if (this.joinRenamed == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.joinRenamed.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476(), "old_name", class_2561.method_43470((String)oldName))::get));
    }

    @Nullable
    public class_2561 getLeft(class_3222 player) {
        if (this.left == null) {
            return null;
        }
        if (this.left == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.left.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476())::get));
    }

    @Nullable
    public class_2561 getDeath(class_3222 player, class_2561 vanillaMessage) {
        if (this.death == null) {
            return null;
        }
        if (this.death == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.death.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476(), "default_message", vanillaMessage)::get));
    }

    @Nullable
    public class_2561 getAdvancementGoal(class_3222 player, class_2561 advancement) {
        if (this.advancementGoal == null) {
            return null;
        }
        if (this.advancementGoal == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.advancementGoal.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476(), "advancement", advancement)::get));
    }

    @Nullable
    public class_2561 getAdvancementTask(class_3222 player, class_2561 advancement) {
        if (this.advancementTask == null) {
            return null;
        }
        if (this.advancementTask == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.advancementTask.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476(), "advancement", advancement)::get));
    }

    @Nullable
    public class_2561 getAdvancementChallenge(class_3222 player, class_2561 advancement) {
        if (this.advancementChallenge == null) {
            return null;
        }
        if (this.advancementChallenge == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.advancementChallenge.toText(PlaceholderContext.of((class_3222)player).asParserContext().with(DYN_KEY, Map.of("player", player.method_5476(), "advancement", advancement)::get));
    }

    @Nullable
    public class_2561 getSayCommand(class_2168 source, class_2561 message) {
        if (this.sayCommand == null) {
            return null;
        }
        if (this.sayCommand == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.sayCommand.toText(PlaceholderContext.of((class_2168)source).asParserContext().with(DYN_KEY, Map.of("player", source.method_9223(), "displayName", source.method_9223(), "message", message)::get));
    }

    @Nullable
    public class_2561 getMeCommand(class_2168 source, class_2561 message) {
        if (this.meCommand == null) {
            return null;
        }
        if (this.meCommand == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.meCommand.toText(PlaceholderContext.of((class_2168)source).asParserContext().with(DYN_KEY, Map.of("player", source.method_9223(), "displayName", source.method_9223(), "message", message)::get));
    }

    @Nullable
    public class_2561 getPrivateMessageSent(class_2561 sender, class_2561 receiver, class_2561 message, PlaceholderContext context) {
        if (this.privateMessageSent == null) {
            return null;
        }
        if (this.privateMessageSent == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.privateMessageSent.toText(context.asParserContext().with(DYN_KEY, Map.of("sender", sender, "receiver", receiver, "message", message)::get));
    }

    @Nullable
    public class_2561 getPrivateMessageReceived(class_2561 sender, class_2561 receiver, class_2561 message, PlaceholderContext context) {
        if (this.privateMessageReceived == null) {
            return null;
        }
        if (this.privateMessageReceived == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.privateMessageReceived.toText(context.asParserContext().with(DYN_KEY, Map.of("sender", sender, "receiver", receiver, "message", message)::get));
    }

    @Nullable
    public class_2561 getTeamChatSent(class_2561 team, class_2561 displayName, class_2561 message, class_2168 context) {
        if (this.teamChatSent == null) {
            return null;
        }
        if (this.teamChatSent == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.teamChatSent.toText(PlaceholderContext.of((class_2168)context).asParserContext().with(DYN_KEY, Map.of("team", team, "displayName", displayName, "message", message)::get));
    }

    @Nullable
    public class_2561 getTeamChatReceived(class_2561 team, class_2561 displayName, class_2561 message, class_2168 context) {
        if (this.teamChatReceived == null) {
            return null;
        }
        if (this.teamChatReceived == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return this.teamChatReceived.toText(PlaceholderContext.of((class_2168)context).asParserContext().with(DYN_KEY, Map.of("team", team, "displayName", displayName, "message", message)::get));
    }

    @Nullable
    public class_2561 getCustom(class_2960 identifier, class_2561 displayName, class_2561 message, @Nullable class_2561 receiver, class_2168 source) {
        TextNode node = this.custom.get(identifier);
        if (node == null) {
            return null;
        }
        if (node == EmptyNode.INSTANCE) {
            return StyledChatUtils.IGNORED_TEXT;
        }
        return node.toText(PlaceholderContext.of((class_2168)source).asParserContext().with(DYN_KEY, Map.of("receiver", receiver == null ? class_2561.method_43473() : receiver, "displayName", displayName, "message", message)::get));
    }

    @Nullable
    public TextNode getLink() {
        return this.linkStyle;
    }

    @Nullable
    public TextNode getMention() {
        return this.mentionStyle;
    }

    @Nullable
    public TextNode getSpoilerStyle() {
        return this.spoilerStyle;
    }

    @Nullable
    public String getSpoilerSymbol() {
        return this.spoilerSymbol;
    }

    public class_2561 getPetDeath(class_1321 entity, class_2561 vanillaMessage) {
        if (this.petDeath == null) {
            return null;
        }
        return this.petDeath.toText(PlaceholderContext.of((class_1297)entity).asParserContext().with(DYN_KEY, Map.of("pet", entity.method_5476(), "default_message", vanillaMessage)::get));
    }
}

