/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.shaded.styledchat.config;

import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.ChatStyle;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.ChatStyleData;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.ConfigData;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.PredicateContext;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1321;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class Config {
    public static final Config DEFAULT = new Config(new ConfigData());
    public final ConfigData configData;
    private final ChatStyle defaultStyle;
    private final List<ChatStyle> permissionStyle;
    public final Set<String> allPossibleAutoCompletionKeys;

    public Config(ConfigData data) {
        this.configData = data;
        this.defaultStyle = new ChatStyle(data.defaultStyle, new ChatStyle(ChatStyleData.DEFAULT));
        this.permissionStyle = new ArrayList<ChatStyle>();
        this.allPossibleAutoCompletionKeys = new HashSet<String>();
        for (String key : this.defaultStyle.emoticons.keySet()) {
            this.allPossibleAutoCompletionKeys.add(":" + key + ":");
        }
        for (ConfigData.RequireChatStyleData entry : data.permissionStyles) {
            if (entry.require == null) {
                entry.require = BuiltinPredicates.operatorLevel((int)4);
            }
            ChatStyle style = new ChatStyle(entry);
            this.permissionStyle.add(style);
            for (String key : style.emoticons.keySet()) {
                this.allPossibleAutoCompletionKeys.add(":" + key + ":");
            }
        }
        for (TextTag tag : TagRegistry.DEFAULT.getTags()) {
            this.allPossibleAutoCompletionKeys.add("<" + tag.name() + ">");
            if (tag.aliases() == null) continue;
            for (String a : tag.aliases()) {
                this.allPossibleAutoCompletionKeys.add("<" + a + ">");
            }
        }
    }

    public class_2561 getDisplayName(class_3222 player, class_2561 vanillaDisplayName) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getDisplayName(player, vanillaDisplayName)) == null) continue;
            return text;
        }
        return this.defaultStyle.getDisplayName(player, vanillaDisplayName);
    }

    public class_2561 getChat(class_3222 player, class_2561 message) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getChat(player, message)) == null) continue;
            return text;
        }
        return this.defaultStyle.getChat(player, message);
    }

    public class_2561 getJoin(class_3222 player) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getJoin(player)) == null) continue;
            return text;
        }
        return this.defaultStyle.getJoin(player);
    }

    public class_2561 getJoinFirstTime(class_3222 player) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getJoinFirstTime(player)) == null) continue;
            return text;
        }
        class_2561 text = this.defaultStyle.getJoinFirstTime(player);
        if (text != null) {
            return text;
        }
        return this.getJoin(player);
    }

    public class_2561 getJoinRenamed(class_3222 player, String oldName) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getJoinRenamed(player, oldName)) == null) continue;
            return text;
        }
        return this.defaultStyle.getJoinRenamed(player, oldName);
    }

    public class_2561 getLeft(class_3222 player) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getLeft(player)) == null) continue;
            return text;
        }
        return this.defaultStyle.getLeft(player);
    }

    public class_2561 getDeath(class_3222 player, class_2561 vanillaMessage) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getDeath(player, vanillaMessage)) == null) continue;
            return text;
        }
        return this.defaultStyle.getDeath(player, vanillaMessage);
    }

    public class_2561 getAdvancementTask(class_3222 player, class_2561 advancement) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getAdvancementTask(player, advancement)) == null) continue;
            return text;
        }
        return this.defaultStyle.getAdvancementTask(player, advancement);
    }

    public class_2561 getAdvancementGoal(class_3222 player, class_2561 advancement) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getAdvancementGoal(player, advancement)) == null) continue;
            return text;
        }
        return this.defaultStyle.getAdvancementGoal(player, advancement);
    }

    public class_2561 getAdvancementChallenge(class_3222 player, class_2561 advancement) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getAdvancementChallenge(player, advancement)) == null) continue;
            return text;
        }
        return this.defaultStyle.getAdvancementChallenge(player, advancement);
    }

    public class_2561 getSayCommand(class_2168 source, class_2561 message) {
        PredicateContext context = PredicateContext.of((class_2168)source);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getSayCommand(source, message)) == null) continue;
            return text;
        }
        return this.defaultStyle.getSayCommand(source, message);
    }

    public class_2561 getMeCommand(class_2168 source, class_2561 message) {
        PredicateContext context = PredicateContext.of((class_2168)source);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context).success() || (text = entry.getMeCommand(source, message)) == null) continue;
            return text;
        }
        return this.defaultStyle.getMeCommand(source, message);
    }

    public class_2561 getPrivateMessageSent(class_2561 sender, class_2561 receiver, class_2561 message, class_2168 context) {
        PlaceholderContext placeholderContext = PlaceholderContext.of((class_2168)context);
        PredicateContext context2 = PredicateContext.of((class_2168)context);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context2).success() || (text = entry.getPrivateMessageSent(sender, receiver, message, placeholderContext)) == null) continue;
            return text;
        }
        return this.defaultStyle.getPrivateMessageSent(sender, receiver, message, placeholderContext);
    }

    public class_2561 getPrivateMessageReceived(class_2561 sender, class_2561 receiver, class_2561 message, class_2168 context) {
        PlaceholderContext placeholderContext = PlaceholderContext.of((class_2168)context);
        PredicateContext context2 = PredicateContext.of((class_2168)context);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context2).success() || (text = entry.getPrivateMessageReceived(sender, receiver, message, placeholderContext)) == null) continue;
            return text;
        }
        return this.defaultStyle.getPrivateMessageReceived(sender, receiver, message, placeholderContext);
    }

    public class_2561 getTeamChatSent(class_2561 team, class_2561 displayName, class_2561 message, class_2168 context) {
        PredicateContext context2 = PredicateContext.of((class_2168)context);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context2).success() || (text = entry.getTeamChatSent(team, displayName, message, context)) == null) continue;
            return text;
        }
        return this.defaultStyle.getTeamChatSent(team, displayName, message, context);
    }

    public class_2561 getTeamChatReceived(class_2561 team, class_2561 displayName, class_2561 message, class_2168 context) {
        PredicateContext context2 = PredicateContext.of((class_2168)context);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context2).success() || (text = entry.getTeamChatReceived(team, displayName, message, context)) == null) continue;
            return text;
        }
        return this.defaultStyle.getTeamChatReceived(team, displayName, message, context);
    }

    public TextNode getSpoilerStyle(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((class_2168)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            TextNode text;
            if (!entry.require.test(context2).success() || (text = entry.getSpoilerStyle()) == null) continue;
            return text;
        }
        return this.defaultStyle.getSpoilerStyle();
    }

    public String getSpoilerSymbole(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((class_2168)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            String text;
            if (!entry.require.test(context2).success() || (text = entry.getSpoilerSymbol()) == null) continue;
            return text;
        }
        return this.defaultStyle.getSpoilerSymbol();
    }

    public TextNode getLinkStyle(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((class_2168)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            TextNode text;
            if (!entry.require.test(context2).success() || (text = entry.getLink()) == null) continue;
            return text;
        }
        return this.defaultStyle.getLink();
    }

    public TextNode getMentionStyle(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((class_2168)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            TextNode text;
            if (!entry.require.test(context2).success() || (text = entry.getMention()) == null) continue;
            return text;
        }
        return this.defaultStyle.getMention();
    }

    public class_2561 getPetDeath(class_1321 entity, class_2561 vanillaMessage) {
        PredicateContext context2 = PredicateContext.of((class_1297)entity);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context2).success() || (text = this.defaultStyle.getPetDeath(entity, vanillaMessage)) == null) continue;
            return text;
        }
        return this.defaultStyle.getPetDeath(entity, vanillaMessage);
    }

    public Map<String, TextNode> getEmotes(class_2168 source) {
        HashMap<String, TextNode> base = new HashMap<String, TextNode>(this.defaultStyle.emoticons);
        PredicateContext context = PredicateContext.of((class_2168)source);
        for (ChatStyle entry : this.permissionStyle) {
            if (!entry.require.test(context).success()) continue;
            for (Map.Entry<String, TextNode> emoticon : entry.emoticons.entrySet()) {
                if (base.containsKey(emoticon.getKey())) continue;
                base.put(emoticon.getKey(), emoticon.getValue());
            }
        }
        return base;
    }

    public Object2BooleanOpenHashMap<String> getAllowedFormatting(class_2168 source) {
        Object2BooleanOpenHashMap base = new Object2BooleanOpenHashMap(this.defaultStyle.formatting);
        PredicateContext context = PredicateContext.of((class_2168)source);
        for (ChatStyle entry : this.permissionStyle) {
            if (!entry.require.test(context).success()) continue;
            for (Object2BooleanMap.Entry formatting : entry.formatting.object2BooleanEntrySet()) {
                if (base.containsKey(formatting.getKey())) continue;
                base.put((Object)((String)formatting.getKey()), formatting.getBooleanValue());
            }
        }
        return base;
    }

    @Nullable
    public class_2561 getCustom(class_2960 identifier, class_2561 displayName, class_2561 message, @Nullable class_2561 receiver, class_2168 source) {
        PredicateContext context2 = PredicateContext.of((class_2168)source);
        for (ChatStyle entry : this.permissionStyle) {
            class_2561 text;
            if (!entry.require.test(context2).success() || (text = entry.getCustom(identifier, displayName, message, receiver, source)) == null) continue;
            return text;
        }
        return this.defaultStyle.getCustom(identifier, displayName, message, receiver, source);
    }
}

