/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.shaded.styledchat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.StyledChatMod;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.Config;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.ConfigData;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.VersionConfigData;
import de.erdbeerbaerlp.dcintegration.shaded.styledchat.config.data.old.ConfigDataV2;
import eu.pb4.predicate.api.GsonPredicateSerializer;
import eu.pb4.predicate.api.MinecraftPredicate;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_7225;

public class ConfigManager {
    private static Config config = null;
    private static ConfigData configData = null;

    public static Config getConfig() {
        if (config == null) {
            if (configData == null) {
                return Config.DEFAULT;
            }
            config = new Config(configData);
        }
        return config;
    }

    public static void clearCached() {
        config = null;
    }

    public static boolean loadConfig(class_7225.class_7874 lookup) {
        config = null;
        try {
            ConfigData config;
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().registerTypeHierarchyAdapter(MinecraftPredicate.class, (Object)GsonPredicateSerializer.create((class_7225.class_7874)lookup)).create();
            Path configFile = FabricLoader.getInstance().getConfigDir().resolve("styled-chat.json");
            if (Files.exists(configFile, new LinkOption[0])) {
                String json = Files.readString(configFile, StandardCharsets.UTF_8);
                VersionConfigData versionConfigData = (VersionConfigData)gson.fromJson(json, VersionConfigData.class);
                if (versionConfigData.version < 3) {
                    config = ((ConfigDataV2)gson.fromJson(json, ConfigDataV2.class)).update();
                    Files.writeString(FabricLoader.getInstance().getConfigDir().resolve("styled-chat.json_old_v2"), (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    config = (ConfigData)gson.fromJson(json, ConfigData.class);
                }
                config.defaultStyle.fillMissing();
            } else {
                config = new ConfigData();
            }
            Files.writeString(configFile, (CharSequence)gson.toJson((Object)config), StandardCharsets.UTF_8, new OpenOption[0]);
            configData = config;
            return true;
        }
        catch (Exception exception) {
            StyledChatMod.LOGGER.error("Something went wrong while reading config! Make sure format is correct!");
            exception.printStackTrace();
            if (configData == null) {
                configData = new ConfigData();
            }
            return false;
        }
    }

    public static JsonObject loadJson(String key) {
        Path path = FabricLoader.getInstance().getConfigDir().resolve(key);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return JsonParser.parseReader((Reader)Files.newBufferedReader(path)).getAsJsonObject();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return new JsonObject();
    }

    public static JsonObject loadJsonBuiltin(String baseValue) {
        Optional path = StyledChatMod.CONTAINER.findPath("emoji/" + baseValue + ".json");
        if (path.isPresent()) {
            try {
                return JsonParser.parseReader((Reader)Files.newBufferedReader((Path)path.get())).getAsJsonObject();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return new JsonObject();
    }
}

