/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.command;

import de.erdbeerbaerlp.dcintegration.architectury.DiscordIntegrationMod;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class DCCommandSender
implements CommandSource {
    private final CompletableFuture<InteractionHook> cmdMsg;
    private final Component name;
    private CompletableFuture<Message> cmdMessage;
    public final StringBuilder message = new StringBuilder();

    public DCCommandSender(CompletableFuture<InteractionHook> cmdMsg, User user) {
        String hoverText;
        String tag;
        Member member = DiscordIntegration.INSTANCE.getMemberById(user.getId());
        String string = tag = user.getDiscriminator().equals("0000") ? user.getEffectiveName() : user.getAsTag();
        if (member != null) {
            tag = member.getUser().getDiscriminator().equals("0000") ? member.getEffectiveName() : member.getUser().getAsTag();
            hoverText = Localization.instance().discordUserHover.replace("%user#tag%", tag).replace("%user%", member.getEffectiveName()).replace("%id%", member.getId());
        } else {
            hoverText = Localization.instance().discordUserHover.replace("%user#tag%", tag).replace("%user%", user.getEffectiveName()).replace("%id%", user.getId());
        }
        this.name = Component.literal((String)("@" + tag)).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)hoverText))));
        this.cmdMsg = cmdMsg;
    }

    public DCCommandSender() {
        this.cmdMsg = null;
        this.name = Component.literal((String)"Discord Integration");
    }

    private static String textComponentToDiscordMessage(Component component) {
        if (component == null) {
            return "";
        }
        return MessageUtils.convertMCToMarkdown(component.getString());
    }

    public void sendSystemMessage(Component p_215097_) {
        this.message.append(DCCommandSender.textComponentToDiscordMessage(p_215097_)).append("\n");
        if (this.cmdMsg != null) {
            if (this.cmdMessage == null) {
                this.cmdMsg.thenAccept(msg -> {
                    this.cmdMessage = msg.editOriginal(this.message.toString().trim()).submit();
                });
            } else {
                this.cmdMessage.thenAccept(msg -> {
                    this.cmdMessage = msg.editMessage(this.message.toString().trim()).submit();
                });
            }
        }
    }

    public boolean acceptsSuccess() {
        return true;
    }

    public boolean acceptsFailure() {
        return true;
    }

    public CommandSourceStack createCommandSourceStack() {
        return new CommandSourceStack((CommandSource)this, Vec3.ZERO, Vec2.ZERO, DiscordIntegrationMod.server.getLevel(ServerLevel.OVERWORLD), 4, this.name.getString(), this.name, DiscordIntegrationMod.server, (Entity)null);
    }

    public boolean shouldInformAdmins() {
        return true;
    }
}

