/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.mixin;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.architectury.util.SerializeComponentUtils;
import de.erdbeerbaerlp.dcintegration.architectury.util.ServerInterface;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.MCSubCommand;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.McCommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Commands.class})
public class CommandManagerMixin {
    @Inject(method={"performCommand(Lcom/mojang/brigadier/ParseResults;Ljava/lang/String;)V"}, cancellable=true, at={@At(value="HEAD")})
    public void execute(ParseResults<CommandSourceStack> parseResults, String command, CallbackInfo ci) {
        CommandSourceStack source2 = (CommandSourceStack)parseResults.getContext().getSource();
        String name = source2.getTextName();
        command = command.replaceFirst(Pattern.quote("/"), "");
        if (DiscordIntegration.INSTANCE != null) {
            if (!Configuration.instance().commandLog.channelID.equals("0") && (!Configuration.instance().commandLog.commandWhitelist && !ArrayUtils.contains((Object[])Configuration.instance().commandLog.ignoredCommands, (Object)command.split(" ")[0]) || Configuration.instance().commandLog.commandWhitelist && ArrayUtils.contains((Object[])Configuration.instance().commandLog.ignoredCommands, (Object)command.split(" ")[0]))) {
                DiscordIntegration.INSTANCE.sendMessage(Configuration.instance().commandLog.message.replace("%sender%", name).replace("%cmd%", command).replace("%cmd-no-args%", command.split(" ")[0]), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().commandLog.channelID));
            }
            boolean raw = false;
            if (command.startsWith("say") && Configuration.instance().messages.sendOnSayCommand || command.startsWith("me") && Configuration.instance().messages.sendOnMeCommand) {
                Object msg = command.replace("say ", "");
                if (command.startsWith("say")) {
                    msg = ((String)msg).replaceFirst("say ", "");
                }
                if (command.startsWith("me")) {
                    raw = true;
                    msg = "*" + MessageUtils.escapeMarkdown(((String)msg).replaceFirst("me ", "").trim()) + "*";
                }
                if (Configuration.instance().webhook.enable && name.equals("Rcon") && Configuration.instance().webhook.useServerNameForRcon) {
                    name = Configuration.instance().webhook.serverName;
                } else if (Configuration.instance().webhook.enable && name.equals("Server") && Configuration.instance().webhook.useServerNameForConsole) {
                    name = Configuration.instance().webhook.serverName;
                }
                Entity sourceEntity = source2.getEntity();
                if (sourceEntity instanceof Player && DiscordIntegration.INSTANCE.getServerInterface().isPlayerVanish(sourceEntity.getUUID())) {
                    return;
                }
                DiscordIntegration.INSTANCE.sendMessage(name, sourceEntity != null ? sourceEntity.getUUID().toString() : "0000000", new DiscordMessage(null, (String)msg, !raw), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID));
                return;
            }
            if (command.startsWith("discord ") || command.startsWith("dc ")) {
                String[] args2 = command.replace("discord ", "").replace("dc ", "").split(" ");
                for (MCSubCommand mcSubCommand : McCommandRegistry.getCommands()) {
                    if (!args2[0].equals(mcSubCommand.getName())) continue;
                    String[] cmdArgs = args2.length > 1 ? Arrays.copyOfRange(args2, 1, args2.length) : new String[]{};
                    switch (mcSubCommand.getType()) {
                        case CONSOLE_ONLY: {
                            String txt;
                            try {
                                source2.getPlayerOrException();
                                source2.sendFailure((Component)Component.literal((String)Localization.instance().commands.consoleOnly));
                            }
                            catch (CommandSyntaxException e) {
                                txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, null));
                                source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, VanillaRegistries.createLookup()), false);
                            }
                            break;
                        }
                        case PLAYER_ONLY: {
                            ServerPlayer player;
                            String txt;
                            try {
                                player = source2.getPlayerOrException();
                                if (!mcSubCommand.needsOP() && ((ServerInterface)DiscordIntegration.INSTANCE.getServerInterface()).playerHasPermissions((Player)player, MinecraftPermission.RUN_DISCORD_COMMAND, MinecraftPermission.USER)) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.getUUID()));
                                    source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, player.level().registryAccess()), false);
                                    break;
                                }
                                if (((ServerInterface)DiscordIntegration.INSTANCE.getServerInterface()).playerHasPermissions((Player)player, MinecraftPermission.RUN_DISCORD_COMMAND_ADMIN)) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.getUUID()));
                                    source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, player.level().registryAccess()), false);
                                    break;
                                }
                                if (source2.hasPermission(4)) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.getUUID()));
                                    source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, player.level().registryAccess()), false);
                                    break;
                                }
                                source2.sendFailure((Component)Component.literal((String)Localization.instance().commands.noPermission));
                            }
                            catch (CommandSyntaxException e) {
                                source2.sendFailure((Component)Component.literal((String)Localization.instance().commands.ingameOnly));
                            }
                            break;
                        }
                        case BOTH: {
                            ServerPlayer player;
                            String txt;
                            try {
                                player = source2.getPlayerOrException();
                                if (!mcSubCommand.needsOP() && ((ServerInterface)DiscordIntegration.INSTANCE.getServerInterface()).playerHasPermissions((Player)player, MinecraftPermission.RUN_DISCORD_COMMAND, MinecraftPermission.USER)) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.getUUID()));
                                    source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, VanillaRegistries.createLookup()), false);
                                    break;
                                }
                                if (((ServerInterface)DiscordIntegration.INSTANCE.getServerInterface()).playerHasPermissions((Player)player, MinecraftPermission.RUN_DISCORD_COMMAND_ADMIN)) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.getUUID()));
                                    source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, VanillaRegistries.createLookup()), false);
                                    break;
                                }
                                if (source2.hasPermission(4)) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.getUUID()));
                                    source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, VanillaRegistries.createLookup()), false);
                                    break;
                                }
                                source2.sendFailure((Component)Component.literal((String)Localization.instance().commands.noPermission));
                                break;
                            }
                            catch (CommandSyntaxException e) {
                                txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, null));
                                source2.sendSuccess(() -> SerializeComponentUtils.fromJson(txt, VanillaRegistries.createLookup()), false);
                            }
                        }
                    }
                }
                ci.cancel();
            }
        }
    }
}

