/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.com.vdurmont.emoji.EmojiParser;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import dcshadow.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import de.erdbeerbaerlp.dcintegration.architectury.DiscordIntegrationMod;
import de.erdbeerbaerlp.dcintegration.architectury.command.DCCommandSender;
import de.erdbeerbaerlp.dcintegration.architectury.util.SerializeComponentUtils;
import de.erdbeerbaerlp.dcintegration.architectury.util.forge.ServerInterfaceImpl;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.util.ComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.util.McServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.requests.RestAction;
import net.minecraft.core.Holder;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class ServerInterface
implements McServerInterface {
    @Override
    public int getMaxPlayers() {
        return DiscordIntegrationMod.server.getMaxPlayers();
    }

    @Override
    public int getOnlinePlayers() {
        return DiscordIntegrationMod.server.getPlayerCount();
    }

    @Override
    public void sendIngameMessage(Component msg) {
        List l = DiscordIntegrationMod.server.getPlayerList().getPlayers();
        try {
            for (ServerPlayer p : l) {
                if (!this.playerHasPermissions((Player)p, MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER) || DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.getUUID())) continue;
                Map.Entry<Boolean, Component> ping = ComponentUtils.parsePing(msg, p.getUUID(), p.getName().getString());
                String jsonComp = ((String)GsonComponentSerializer.gson().serialize(ping.getValue())).replace("\\\\n", "\n");
                MutableComponent comp = SerializeComponentUtils.fromJson(jsonComp, p.level().registryAccess());
                if (LinkManager.isPlayerLinked(p.getUUID())) {
                    PlayerLink link = LinkManager.getLink(null, p.getUUID());
                    if (link.settings.ignoreDiscordChatIngame) continue;
                    if (ping.getKey().booleanValue() && LinkManager.isPlayerLinked(p.getUUID()) && link.settings.pingSound) {
                        p.connection.send((Packet)new ClientboundSoundPacket((Holder)SoundEvents.NOTE_BLOCK_PLING, SoundSource.MASTER, p.position().x, p.position().y, p.position().z, 1.0f, 1.0f, DiscordIntegrationMod.server.overworld().getSeed()));
                    }
                }
                p.sendSystemMessage((net.minecraft.network.chat.Component)comp, false);
            }
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msg)).replace("\\\\n", "\n");
            MutableComponent comp = SerializeComponentUtils.fromJson(jsonComp, VanillaRegistries.createLookup());
            DiscordIntegrationMod.server.sendSystemMessage((net.minecraft.network.chat.Component)comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendIngameReaction(Member member, RestAction<Message> retrieveMessage, UUID targetUUID, EmojiUnion reactionEmote) {
        List l = DiscordIntegrationMod.server.getPlayerList().getPlayers();
        for (ServerPlayer p : l) {
            if (!this.playerHasPermissions((Player)p, MinecraftPermission.READ_MESSAGES, MinecraftPermission.USER) || !p.getUUID().equals(targetUUID) || DiscordIntegration.INSTANCE.ignoringPlayers.contains(p.getUUID())) continue;
            if (LinkManager.isPlayerLinked(p.getUUID())) {
                PlayerLink link = LinkManager.getLink(null, p.getUUID());
                if (link.settings.ignoreDiscordChatIngame || link.settings.ignoreReactions) continue;
            }
            Object emote = reactionEmote.getType() == Emoji.Type.UNICODE ? EmojiParser.parseToAliases(reactionEmote.getName()) : ":" + reactionEmote.getName() + ":";
            Style.Builder memberStyle = Style.style();
            if (Configuration.instance().messages.discordRoleColorIngame) {
                memberStyle = memberStyle.color(TextColor.color(member.getColorRaw()));
            }
            Component user = Component.text(member.getEffectiveName()).style((Style.Builder)memberStyle.clickEvent(ClickEvent.suggestCommand("@" + (member.getUser().getDiscriminator().equals("0000") ? member.getUser().getName() : member.getUser().getAsTag()))).hoverEvent(HoverEvent.showText(Component.text(Localization.instance().discordUserHover.replace("%user#tag%", member.getUser().getDiscriminator().equals("0000") ? member.getUser().getName() : member.getUser().getAsTag()).replace("%user%", member.getEffectiveName()).replace("%id%", member.getUser().getId())))));
            TextReplacementConfig userReplacer = ComponentUtils.replaceLiteral("%user%", user);
            TextReplacementConfig usernameReplacer = ComponentUtils.replaceLiteral("%name%", user);
            TextReplacementConfig emoteReplacer = ComponentUtils.replaceLiteral("%emote%", (String)emote);
            Component out = LegacyComponentSerializer.legacySection().deserialize(Localization.instance().reactionMessage).replaceText(userReplacer).replaceText(usernameReplacer).replaceText(emoteReplacer);
            if (Localization.instance().reactionMessage.contains("%msg%")) {
                retrieveMessage.submit().thenAccept(m -> {
                    String msg = MessageUtils.formatEmoteMessage(m.getMentions().getCustomEmojis(), m.getContentDisplay());
                    TextReplacementConfig msgReplacer = ComponentUtils.replaceLiteral("%msg%", msg);
                    this.sendReactionMCMessage(p, out.replaceText(msgReplacer));
                });
                continue;
            }
            this.sendReactionMCMessage(p, out);
        }
    }

    private void sendReactionMCMessage(ServerPlayer target, Component msgComp) {
        String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msgComp)).replace("\\\\n", "\n");
        try {
            MutableComponent comp = SerializeComponentUtils.fromJson(jsonComp, target.level().registryAccess());
            target.sendSystemMessage((net.minecraft.network.chat.Component)comp, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void runMcCommand(String cmd, CompletableFuture<InteractionHook> cmdMsg, User user) {
        DCCommandSender s = new DCCommandSender(cmdMsg, user);
        try {
            DiscordIntegrationMod.server.getCommands().getDispatcher().execute(cmd.trim(), (Object)s.createCommandSourceStack());
        }
        catch (CommandSyntaxException e) {
            s.sendSystemMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)e.getMessage()));
        }
    }

    @Override
    public HashMap<UUID, String> getPlayers() {
        HashMap<UUID, String> players = new HashMap<UUID, String>();
        for (ServerPlayer p : DiscordIntegrationMod.server.getPlayerList().getPlayers()) {
            players.put(p.getUUID(), p.getDisplayName().getString().isEmpty() ? p.getName().getString() : p.getDisplayName().getString());
        }
        return players;
    }

    @Override
    public void sendIngameMessage(String msg, UUID player) {
        ServerPlayer p = DiscordIntegrationMod.server.getPlayerList().getPlayer(player);
        if (p != null) {
            p.sendSystemMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)msg));
        }
    }

    @Override
    public boolean isOnlineMode() {
        return Configuration.instance().bungee.isBehindBungee || DiscordIntegrationMod.server.usesAuthentication();
    }

    @Override
    public String getNameFromUUID(UUID uuid) {
        return ((GameProfile)DiscordIntegrationMod.server.services().profileResolver().fetchById(uuid).orElseThrow()).name();
    }

    @Override
    public boolean playerHasPermissions(UUID player, String ... permissions) {
        return ServerInterface.playerHasPermissionsX(player, permissions);
    }

    public boolean playerHasPermissions(Player player, String ... permissions) {
        return ServerInterface.playerHasPermissionsX(player, permissions);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean playerHasPermissionsX(UUID player, String ... permissions) {
        void var1_1;
        return ServerInterfaceImpl.playerHasPermissionsX(player, (String[])var1_1);
    }

    @Override
    public String runMCCommand(String cmd) {
        DCCommandSender s = new DCCommandSender();
        try {
            DiscordIntegrationMod.server.getCommands().getDispatcher().execute(cmd.trim(), (Object)s.createCommandSourceStack());
            return s.message.toString();
        }
        catch (CommandSyntaxException e) {
            return e.getMessage();
        }
    }

    @Override
    public boolean isPlayerVanish(UUID player) {
        return ServerInterface.checkVanish(player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean checkVanish(UUID player) {
        return ServerInterfaceImpl.checkVanish(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean playerHasPermissionsX(Player player, String ... permissions) {
        void var1_1;
        return ServerInterfaceImpl.playerHasPermissionsX(player, (String[])var1_1);
    }

    public boolean playerHasPermissions(Player player, MinecraftPermission ... permissions) {
        String[] permissionStrings = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            permissionStrings[i] = permissions[i].getAsString();
        }
        return this.playerHasPermissions(player, permissionStrings);
    }

    @Override
    public String getLoaderName() {
        return ServerInterface.getLoaderNameX();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static String getLoaderNameX() {
        return ServerInterfaceImpl.getLoaderNameX();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getLoaderVersion() {
        return ServerInterfaceImpl.getLoaderVersion();
    }
}

