/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands;

import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.DiscordCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.configCmd.ConfigCommand;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;

public class CommandFromConfig
extends DiscordCommand {
    private final String mcCmd;
    private final boolean admin;
    private final ConfigCommand.CommandArgument[] args;
    private final boolean hidden;
    private final String textToSend;

    public CommandFromConfig(String cmd, String description, String mcCommand, boolean adminOnly, ConfigCommand.CommandArgument[] args2, boolean hidden, String textToSend) throws IllegalArgumentException {
        super(cmd, description);
        this.textToSend = textToSend;
        this.isConfigCmd = true;
        this.admin = adminOnly;
        this.mcCmd = mcCommand;
        this.hidden = hidden;
        if (args2 != null) {
            this.args = args2;
            for (ConfigCommand.CommandArgument argument : args2) {
                this.addOption(OptionType.STRING, argument.name, argument.description, !argument.optional);
            }
        } else {
            this.args = new ConfigCommand.CommandArgument[0];
        }
    }

    @Override
    public boolean adminOnly() {
        return this.admin;
    }

    @Override
    public void execute(SlashCommandInteractionEvent ev, ReplyCallbackAction reply) {
        reply = reply.setEphemeral(this.hidden);
        if (!this.textToSend.isEmpty()) {
            reply = (ReplyCallbackAction)reply.setContent(this.textToSend);
        }
        CompletableFuture<InteractionHook> submit = reply.submit();
        if (!this.mcCmd.isEmpty()) {
            String cmd = this.mcCmd;
            for (ConfigCommand.CommandArgument arg : this.args) {
                OptionMapping option = ev.getOption(arg.name);
                cmd = cmd.replace("%" + arg.name + "%", option == null ? "" : option.getAsString());
            }
            DiscordIntegration.INSTANCE.getServerInterface().runMcCommand(cmd, submit, ev.getUser());
        }
    }
}

