/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.mixin;

import com.mojang.authlib.GameProfile;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.architectury.util.MessageUtilsImpl;
import de.erdbeerbaerlp.dcintegration.architectury.util.SerializeComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.WorkThread;
import de.erdbeerbaerlp.dcintegration.common.compat.FloodgateUtils;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import java.net.SocketAddress;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    @Inject(method={"canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"}, at={@At(value="HEAD")}, cancellable=true)
    public void canJoin(SocketAddress address, GameProfile profile, CallbackInfoReturnable<Component> cir) {
        if (DiscordIntegration.INSTANCE == null) {
            return;
        }
        LinkManager.checkGlobalAPI(profile.getId());
        dcshadow.net.kyori.adventure.text.Component eventKick = DiscordIntegration.INSTANCE.callEventO(e -> e.onPlayerJoin(profile.getId()));
        if (eventKick != null) {
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(eventKick)).replace("\\\\n", "\n");
            try {
                MutableComponent comp = SerializeComponentUtils.fromJson(jsonComp, VanillaRegistries.createLookup());
                cir.setReturnValue((Object)comp);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (Configuration.instance().linking.whitelistMode && DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            try {
                if (!LinkManager.isPlayerLinked(profile.getId())) {
                    cir.setReturnValue((Object)Component.literal((String)Localization.instance().linking.notWhitelistedCode.replace("%code%", "" + (FloodgateUtils.isBedrockPlayer(profile.getId()) ? LinkManager.genBedrockLinkNumber(profile.getId()) : LinkManager.genLinkNumber(profile.getId())))));
                } else if (!DiscordIntegration.INSTANCE.canPlayerJoin(profile.getId())) {
                    cir.setReturnValue((Object)Component.literal((String)Localization.instance().linking.notWhitelistedRole));
                }
            }
            catch (IllegalStateException e3) {
                cir.setReturnValue((Object)Component.literal((String)("An error occured\nPlease check Server Log for more information\n\n" + String.valueOf(e3))));
                e3.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"})
    private void onPlayerJoin(Connection connection, ServerPlayer p, CommonListenerCookie commonListenerCookie, CallbackInfo ci) {
        if (DiscordIntegration.INSTANCE != null) {
            if (DiscordIntegration.INSTANCE.getServerInterface().isPlayerVanish(p.getUUID())) {
                return;
            }
            if (LinkManager.isPlayerLinked(p.getUUID()) && LinkManager.getLink(null, (UUID)p.getUUID()).settings.hideFromDiscord) {
                return;
            }
            LinkManager.checkGlobalAPI(p.getUUID());
            if (!Localization.instance().playerJoin.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerJoinMessage.asEmbed) {
                    String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", p.getUUID().toString()).replace("%uuid_dashless%", p.getUUID().toString().replace("-", "")).replace("%name%", p.getName().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.playerJoinMessage.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbedJson(Configuration.instance().embedMode.playerJoinMessage.customJSON.replace("%uuid%", p.getUUID().toString()).replace("%uuid_dashless%", p.getUUID().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(p)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID(p.getUUID()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbed();
                        b.setAuthor(MessageUtilsImpl.formatPlayerName(p), null, avatarURL).setDescription(Localization.instance().playerJoin.replace("%player%", MessageUtilsImpl.formatPlayerName(p)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerJoin.replace("%player%", MessageUtilsImpl.formatPlayerName(p)), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
            WorkThread.executeJob(() -> {
                UUID uuid = p.getUUID();
                if (!LinkManager.isPlayerLinked(uuid)) {
                    return;
                }
                Member member = DiscordIntegration.INSTANCE.getMemberById(LinkManager.getLink(null, (UUID)uuid).discordID);
                if (Configuration.instance().linking.shouldNickname) {
                    member.modifyNickname(MessageUtilsImpl.formatPlayerName(p)).queue();
                }
                if (Configuration.instance().linking.linkedRoleID.equals("0")) {
                    return;
                }
                Guild guild = DiscordIntegration.INSTANCE.getChannel().getGuild();
                Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
                if (!member.getRoles().contains(linkedRole)) {
                    guild.addRoleToMember(member, linkedRole).queue();
                }
            });
        }
    }
}

