/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;

public class DownloadSourceChecker {
    public static final ArrayList<String> trustedSources = new ArrayList();

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean checkDownloadSource(File f) {
        if (Configuration.instance().general.ignoreFileSource) {
            return true;
        }
        try {
            String line;
            HttpsURLConnection url = (HttpsURLConnection)new URL("https://api.erdbeerbaerlp.de/trusted-urls.txt").openConnection();
            url.setConnectTimeout(3000);
            url.setReadTimeout(3000);
            url.connect();
            if (url.getResponseCode() != 200) {
                return true;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.getInputStream()));
            while ((line = reader.readLine()) != null) {
                trustedSources.add(line);
            }
            reader.close();
            url.disconnect();
        }
        catch (IOException e) {
            return true;
        }
        File file = new File(f.getAbsolutePath() + ":Zone.Identifier:$DATA");
        try (BufferedReader bf = new BufferedReader(new FileReader(file));){
            for (String line : bf.lines().collect(Collectors.toList())) {
                if (!line.contains("HostUrl=")) continue;
                for (String s : trustedSources) {
                    if (!line.contains(s)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }
}

