/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.com.moandjiezana.toml;

import dcshadow.com.moandjiezana.toml.MapValueWriter;
import dcshadow.com.moandjiezana.toml.TomlComment;
import dcshadow.com.moandjiezana.toml.TomlIgnore;
import dcshadow.com.moandjiezana.toml.ValueWriter;
import dcshadow.com.moandjiezana.toml.ValueWriters;
import dcshadow.com.moandjiezana.toml.WriterContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

class ObjectValueWriter
implements ValueWriter {
    static final ValueWriter OBJECT_VALUE_WRITER = new ObjectValueWriter();

    @Override
    public boolean canWrite(Object value) {
        return true;
    }

    @Override
    public void write(Object value, WriterContext context) {
        this.write(value, context, null);
    }

    private ObjectValueWriter() {
    }

    private static Set<Field> getFields(Class<?> cls) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>(Arrays.asList(cls.getDeclaredFields()));
        while (cls != Object.class) {
            fields.addAll(Arrays.asList(cls.getDeclaredFields()));
            cls = cls.getSuperclass();
        }
        ObjectValueWriter.removeConstantsAndSyntheticFields(fields);
        return fields;
    }

    private static void removeConstantsAndSyntheticFields(Set<Field> fields) {
        Iterator<Field> iterator2 = fields.iterator();
        while (iterator2.hasNext()) {
            Field field = iterator2.next();
            if ((!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) && !field.isSynthetic() && !Modifier.isTransient(field.getModifiers()) && !field.isAnnotationPresent(TomlIgnore.class)) continue;
            iterator2.remove();
        }
    }

    private static Object getFieldValue(Field field, Object o) {
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        Object value = null;
        try {
            value = field.get(o);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field.setAccessible(isAccessible);
        return value;
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    public void write(Object value, WriterContext context, String[] objectComment) {
        LinkedHashMap<String, Object> to = new LinkedHashMap<String, Object>();
        Set<Field> fields = ObjectValueWriter.getFields(value.getClass());
        ArrayList<String[]> comments = new ArrayList<String[]>();
        ArrayList<String[]> objComments = new ArrayList<String[]>();
        block0: for (Field field : fields) {
            Object fieldValue = ObjectValueWriter.getFieldValue(field, value);
            to.put(field.getName(), fieldValue);
            ValueWriter valueWriter = ValueWriters.WRITERS.findWriterFor(fieldValue);
            if (field.isAnnotationPresent(TomlComment.class)) {
                for (Annotation a : field.getAnnotations()) {
                    if (!(a instanceof TomlComment)) continue;
                    TomlComment comment = (TomlComment)a;
                    if (valueWriter == OBJECT_VALUE_WRITER) {
                        objComments.add(comment.value());
                        continue block0;
                    }
                    comments.add(comment.value());
                    continue block0;
                }
                continue;
            }
            if (valueWriter == OBJECT_VALUE_WRITER) {
                objComments.add(null);
                continue;
            }
            comments.add(null);
        }
        ((MapValueWriter)MapValueWriter.MAP_VALUE_WRITER).write(to, context, comments, objComments, objectComment);
    }
}

