/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.dev.vankka.mcdiscordreserializer.discord;

import dcshadow.dev.vankka.mcdiscordreserializer.discord.DiscordSerializerOptions;
import dcshadow.dev.vankka.mcdiscordreserializer.text.Text;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.KeybindComponent;
import dcshadow.net.kyori.adventure.text.ScoreComponent;
import dcshadow.net.kyori.adventure.text.SelectorComponent;
import dcshadow.net.kyori.adventure.text.TextComponent;
import dcshadow.net.kyori.adventure.text.TranslatableComponent;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.format.TextDecoration;
import dcshadow.org.jetbrains.annotations.NotNull;
import java.util.LinkedList;
import java.util.List;

public class DiscordSerializer {
    public static final DiscordSerializer INSTANCE = new DiscordSerializer(){

        @Override
        public void setDefaultOptions(@NotNull DiscordSerializerOptions defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    @NotNull
    private DiscordSerializerOptions defaultOptions;

    public DiscordSerializer() {
        this(DiscordSerializerOptions.defaults());
    }

    public DiscordSerializer(@NotNull DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    public String serialize(@NotNull Component component) {
        DiscordSerializerOptions options = this.getDefaultOptions();
        return this.serialize(component, options);
    }

    @NotNull
    public String serialize(@NotNull Component component, @NotNull DiscordSerializerOptions serializerOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<Text> texts = this.getTexts(new LinkedList<Text>(), component, new Text(), serializerOptions);
        for (Text text : texts) {
            String content = text.getContent();
            if (content.isEmpty()) continue;
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (serializerOptions.isEscapeMarkdown()) {
                content = content.replace("*", "\\*").replace("~", "\\~").replace("_", "\\_").replace("`", "\\`").replace("|", "\\|");
            }
            stringBuilder.append(content);
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            stringBuilder.append("\u200b");
        }
        int length = stringBuilder.length();
        return length < 1 ? "" : stringBuilder.substring(0, length - 1);
    }

    private LinkedList<Text> getTexts(@NotNull List<Text> input, @NotNull Component component, @NotNull Text text, @NotNull DiscordSerializerOptions serializerOptions) {
        Text previous;
        TextDecoration.State strikethrough;
        TextDecoration.State underline;
        TextDecoration.State italic;
        LinkedList<Text> output = new LinkedList<Text>(input);
        String content = component instanceof KeybindComponent ? serializerOptions.getKeybindProvider().apply((KeybindComponent)component) : (component instanceof ScoreComponent ? ((ScoreComponent)component).value() : (component instanceof SelectorComponent ? ((SelectorComponent)component).pattern() : (component instanceof TextComponent ? ((TextComponent)component).content() : (component instanceof TranslatableComponent ? serializerOptions.getTranslationProvider().apply((TranslatableComponent)component) : ""))));
        ClickEvent clickEvent = component.clickEvent();
        if (serializerOptions.isEmbedLinks() && clickEvent != null && clickEvent.action() == ClickEvent.Action.OPEN_URL) {
            text.setContent("[" + content + "](" + clickEvent.value() + ")");
        } else {
            text.setContent(content);
        }
        TextDecoration.State bold = component.decoration(TextDecoration.BOLD);
        if (bold != TextDecoration.State.NOT_SET) {
            text.setBold(bold == TextDecoration.State.TRUE);
        }
        if ((italic = component.decoration(TextDecoration.ITALIC)) != TextDecoration.State.NOT_SET) {
            text.setItalic(italic == TextDecoration.State.TRUE);
        }
        if ((underline = component.decoration(TextDecoration.UNDERLINED)) != TextDecoration.State.NOT_SET) {
            text.setUnderline(underline == TextDecoration.State.TRUE);
        }
        if ((strikethrough = component.decoration(TextDecoration.STRIKETHROUGH)) != TextDecoration.State.NOT_SET) {
            text.setStrikethrough(strikethrough == TextDecoration.State.TRUE);
        }
        if (!output.isEmpty() && text.formattingMatches(previous = output.getLast())) {
            output.removeLast();
            text.setContent(previous.getContent() + text.getContent());
        }
        output.add(text);
        for (Component child : component.children()) {
            Text next = text.clone();
            next.setContent("");
            output = this.getTexts(output, child, next, serializerOptions);
        }
        return output;
    }

    @NotNull
    public DiscordSerializerOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(@NotNull DiscordSerializerOptions defaultOptions) {
        if (defaultOptions == null) {
            throw new NullPointerException("defaultOptions is marked non-null but is null");
        }
        this.defaultOptions = defaultOptions;
    }
}

