/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.erdbeerbaerlp.dcintegration.architectury.util.ServerInterface;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.MCSubCommand;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.McCommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import java.net.URI;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class McCommandDiscord {
    public McCommandDiscord(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder l = Commands.literal((String)"discord");
        if (Configuration.instance().ingameCommand.enabled) {
            ((LiteralArgumentBuilder)l.executes(ctx -> {
                MutableComponent base = Component.literal((String)Configuration.instance().ingameCommand.message);
                MutableComponent hover = Component.literal((String)Configuration.instance().ingameCommand.hoverMessage);
                URI url = URI.create(Configuration.instance().ingameCommand.inviteURL);
                MutableComponent full = base.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(url)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> full, false);
                return 0;
            })).requires(s -> {
                try {
                    return ((ServerInterface)DiscordIntegration.INSTANCE.getServerInterface()).playerHasPermissions((Player)s.getPlayerOrException(), MinecraftPermission.USER, MinecraftPermission.RUN_DISCORD_COMMAND);
                }
                catch (CommandSyntaxException e) {
                    return true;
                }
            });
        }
        for (MCSubCommand cmd : McCommandRegistry.getCommands()) {
            l.then((ArgumentBuilder)Commands.literal((String)cmd.getName()));
        }
        dispatcher.register(l);
    }
}

