/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.mixin;

import de.erdbeerbaerlp.dcintegration.architectury.util.MessageUtilsImpl;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(at={@At(value="TAIL")}, method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"})
    private void onPlayerDeath(DamageSource s, CallbackInfo info) {
        ServerPlayer p = (ServerPlayer)this;
        if (DiscordIntegration.INSTANCE != null) {
            if (DiscordIntegration.INSTANCE.getServerInterface().isPlayerVanish(p.getUUID())) {
                return;
            }
            if (LinkManager.isPlayerLinked(p.getUUID()) && LinkManager.getLink(null, (UUID)p.getUUID()).settings.hideFromDiscord) {
                return;
            }
            Component deathMessage = s.getLocalizedDeathMessage((LivingEntity)p);
            MessageEmbed embed = MessageUtilsImpl.genItemStackEmbedIfAvailable(deathMessage, (Level)p.level());
            if (!Localization.instance().playerDeath.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.deathMessage.asEmbed) {
                    String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", p.getUUID().toString()).replace("%uuid_dashless%", p.getUUID().toString().replace("-", "")).replace("%name%", p.getName().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.deathMessage.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.deathMessage.toEmbedJson(Configuration.instance().embedMode.deathMessage.customJSON.replace("%uuid%", p.getUUID().toString()).replace("%uuid_dashless%", p.getUUID().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(p)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%deathMessage%", ChatFormatting.stripFormatting((String)deathMessage.getString()).replace(MessageUtilsImpl.formatPlayerName(p) + " ", "")).replace("%playerColor%", "" + TextColors.generateFromUUID(p.getUUID()).getRGB()));
                        if (embed != null) {
                            b.addBlankField(false);
                            b.addField(embed.getTitle() + " *(" + embed.getFooter().getText() + ")*", embed.getDescription(), false);
                        }
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.deathsChannelID));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.deathMessage.toEmbed();
                        b.setDescription(":skull: " + Localization.instance().playerDeath.replace("%player%", MessageUtilsImpl.formatPlayerName(p)).replace("%msg%", ChatFormatting.stripFormatting((String)deathMessage.getString()).replace(MessageUtilsImpl.formatPlayerName(p) + " ", "")));
                        if (embed != null) {
                            b.addBlankField(false);
                            b.addField(embed.getTitle() + " *(" + embed.getFooter().getText() + ")*", embed.getDescription(), false);
                        }
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.deathsChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(embed, Localization.instance().playerDeath.replace("%player%", MessageUtilsImpl.formatPlayerName(p)).replace("%msg%", ChatFormatting.stripFormatting((String)deathMessage.getString()).replace(MessageUtilsImpl.formatPlayerName(p) + " ", ""))), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.deathsChannelID));
                }
            }
        }
    }
}

