/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.neoforge;

import de.erdbeerbaerlp.dcintegration.architectury.DiscordIntegrationMod;
import de.erdbeerbaerlp.dcintegration.architectury.neoforge.VanishEventListener;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.compat.DynmapListener;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import java.util.HashMap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;

@Mod(value="dcintegration")
public final class DiscordIntegrationForge {
    public static final HashMap<String, PermissionNode<Boolean>> nodes = new HashMap();

    public DiscordIntegrationForge(IEventBus modEventBus) {
        DiscordIntegrationMod.init();
        if (Configuration.instance().general.botToken.equals("INSERT BOT TOKEN HERE")) {
            DiscordIntegration.LOGGER.error("Please check the config file and set an bot token");
        } else {
            modEventBus.addListener(this::serverSetup);
            NeoForge.EVENT_BUS.register((Object)this);
        }
    }

    public void serverSetup(FMLDedicatedServerSetupEvent ev) {
    }

    @SubscribeEvent
    public void serverStarting(ServerStartingEvent ev) {
        DiscordIntegrationMod.serverStarting(ev.getServer());
        if (ModList.get().getModContainerById("dynmap").isPresent()) {
            new DynmapListener().register();
        }
        if (ModList.get().getModContainerById("vmod").isPresent()) {
            NeoForge.EVENT_BUS.register((Object)new VanishEventListener());
        }
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent ev) {
        DiscordIntegrationMod.serverStarted(ev.getServer());
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent ev) {
        DiscordIntegrationMod.serverStopping(ev.getServer());
    }

    @SubscribeEvent
    public void serverStopped(ServerStoppedEvent ev) {
        DiscordIntegrationMod.serverStopped(ev.getServer());
    }

    @SubscribeEvent
    public void addPermissions(PermissionGatherEvent.Nodes ev) {
        for (MinecraftPermission p : MinecraftPermission.values()) {
            nodes.put(p.getAsString(), (PermissionNode<Boolean>)new PermissionNode("dcintegration", p.getAsString().replace("dcintegration.", ""), PermissionTypes.BOOLEAN, (player, playerUUID, context) -> p.getDefaultValue(), new PermissionDynamicContextKey[0]));
        }
        ev.addNodes(nodes.values().toArray(new PermissionNode[0]));
    }
}

