/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import java.util.ArrayList;
import java.util.List;

public final class Version
implements Comparable<Version> {
    private final String version;
    private final List<Object> sequence;
    private final List<Object> pre;
    private final List<Object> build;

    private static int takeNumber(String s, int i, List<Object> acc) {
        char c = s.charAt(i);
        int d = c - 48;
        int n = s.length();
        while (++i < n && (c = s.charAt(i)) >= '0' && c <= '9') {
            d = d * 10 + (c - 48);
        }
        acc.add(d);
        return i;
    }

    private static int takeString(String s, int i, List<Object> acc) {
        char c;
        int b = i;
        int n = s.length();
        while (++i < n && (c = s.charAt(i)) != '.' && c != '-' && c != '+' && (c < '0' || c > '9')) {
        }
        acc.add(s.substring(b, i));
        return i;
    }

    private Version(String v) {
        if (v == null) {
            throw new IllegalArgumentException("Null version string");
        }
        int n = v.length();
        if (n == 0) {
            throw new IllegalArgumentException("Empty version string");
        }
        int i = 0;
        char c = v.charAt(i);
        if (c < '0' || c > '9') {
            throw new IllegalArgumentException(v + ": Version string does not start with a number");
        }
        ArrayList<Object> sequence2 = new ArrayList<Object>(4);
        ArrayList<Object> pre = new ArrayList<Object>(2);
        ArrayList<Object> build = new ArrayList<Object>(2);
        i = Version.takeNumber(v, i, sequence2);
        while (i < n) {
            c = v.charAt(i);
            if (c == '.') {
                ++i;
                continue;
            }
            if (c == '-' || c == '+') {
                ++i;
                break;
            }
            if (c >= '0' && c <= '9') {
                i = Version.takeNumber(v, i, sequence2);
                continue;
            }
            i = Version.takeString(v, i, sequence2);
        }
        if (c == '-' && i >= n) {
            throw new IllegalArgumentException(v + ": Empty pre-release");
        }
        while (i < n) {
            c = v.charAt(i);
            if (c == '.' || c == '-') {
                ++i;
                continue;
            }
            if (c == '+') {
                ++i;
                break;
            }
            if (c >= '0' && c <= '9') {
                i = Version.takeNumber(v, i, pre);
                continue;
            }
            i = Version.takeString(v, i, pre);
        }
        if (c == '+' && i >= n) {
            throw new IllegalArgumentException(v + ": Empty pre-release");
        }
        while (i < n) {
            c = v.charAt(i);
            if (c == '.' || c == '-' || c == '+') {
                ++i;
                continue;
            }
            if (c >= '0' && c <= '9') {
                i = Version.takeNumber(v, i, build);
                continue;
            }
            i = Version.takeString(v, i, build);
        }
        this.version = v;
        this.sequence = sequence2;
        this.pre = pre;
        this.build = build;
    }

    public static Version parse(String v) {
        return new Version(v);
    }

    private int cmp(Object o1, Object o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    private int compareTokens(List<Object> ts1, List<Object> ts2) {
        int n = Math.min(ts1.size(), ts2.size());
        for (int i = 0; i < n; ++i) {
            int c;
            Object o1 = ts1.get(i);
            Object o2 = ts2.get(i);
            if (o1 instanceof Integer && o2 instanceof Integer || o1 instanceof String && o2 instanceof String) {
                c = this.cmp(o1, o2);
                if (c == 0) continue;
                return c;
            }
            c = o1.toString().compareTo(o2.toString());
            if (c == 0) continue;
            return c;
        }
        List<Object> rest = ts1.size() > ts2.size() ? ts1 : ts2;
        int e = rest.size();
        for (int i = n; i < e; ++i) {
            Object o = rest.get(i);
            if (o instanceof Integer && (Integer)o == 0) continue;
            return ts1.size() - ts2.size();
        }
        return 0;
    }

    @Override
    public int compareTo(Version that) {
        int c = this.compareTokens(this.sequence, that.sequence);
        if (c != 0) {
            return c;
        }
        if (this.pre.isEmpty()) {
            if (!that.pre.isEmpty()) {
                return 1;
            }
        } else if (that.pre.isEmpty()) {
            return -1;
        }
        if ((c = this.compareTokens(this.pre, that.pre)) != 0) {
            return c;
        }
        return this.compareTokens(this.build, that.build);
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)ob) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }
}

