/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AmountSelectionGUI {
    private static final int GUI_SIZE = 27;

    public static void openAmountSelection(Player player, ItemStack item, int maxAmount) {
        AmountSelectionHolder holder = new AmountSelectionHolder(item, maxAmount);
        Component title = Component.text((String)("Select Amount: " + AmountSelectionGUI.getItemName(item))).color((TextColor)NamedTextColor.BLUE);
        Inventory gui = Bukkit.createInventory((InventoryHolder)holder, (int)27, (Component)title);
        ItemStack displayItem = item.clone();
        displayItem.setAmount(1);
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text((String)AmountSelectionGUI.getItemName(item)).color((TextColor)NamedTextColor.YELLOW));
            meta.lore(Arrays.asList((TextComponent)Component.text((String)("Available: " + maxAmount)).color((TextColor)NamedTextColor.GRAY), (TextComponent)Component.text((String)"Click buttons to select amount").color((TextColor)NamedTextColor.GRAY)));
            displayItem.setItemMeta(meta);
        }
        gui.setItem(4, displayItem);
        if (maxAmount >= 1) {
            gui.setItem(10, AmountSelectionGUI.createAmountButton(1));
        }
        if (maxAmount >= 8) {
            gui.setItem(11, AmountSelectionGUI.createAmountButton(8));
        }
        if (maxAmount >= 16) {
            gui.setItem(12, AmountSelectionGUI.createAmountButton(16));
        }
        if (maxAmount >= 32) {
            gui.setItem(13, AmountSelectionGUI.createAmountButton(32));
        }
        if (maxAmount >= 64) {
            gui.setItem(14, AmountSelectionGUI.createAmountButton(64));
        }
        gui.setItem(15, AmountSelectionGUI.createMaxAmountButton(maxAmount));
        gui.setItem(22, AmountSelectionGUI.createCancelButton());
        player.openInventory(gui);
    }

    private static ItemStack createAmountButton(int amount) {
        ItemStack button = new ItemStack(Material.GREEN_WOOL);
        ItemMeta meta = button.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text((String)("Select " + amount)).color((TextColor)NamedTextColor.GREEN));
            meta.lore(Arrays.asList((TextComponent)Component.text((String)("Click to select " + amount + " items")).color((TextColor)NamedTextColor.GRAY)));
            button.setItemMeta(meta);
        }
        return button;
    }

    private static ItemStack createMaxAmountButton(int maxAmount) {
        ItemStack button = new ItemStack(Material.GREEN_WOOL);
        ItemMeta meta = button.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text((String)("Select All (" + maxAmount + ")")).color((TextColor)NamedTextColor.GREEN));
            meta.lore(Arrays.asList((TextComponent)Component.text((String)("Click to select all " + maxAmount + " items")).color((TextColor)NamedTextColor.GRAY)));
            button.setItemMeta(meta);
        }
        return button;
    }

    private static ItemStack createCancelButton() {
        ItemStack button = new ItemStack(Material.RED_WOOL);
        ItemMeta meta = button.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text((String)"Cancel").color((TextColor)NamedTextColor.RED));
            meta.lore(Arrays.asList((TextComponent)Component.text((String)"Click to cancel").color((TextColor)NamedTextColor.GRAY)));
            button.setItemMeta(meta);
        }
        return button;
    }

    private static String getItemName(ItemStack item) {
        Component displayName;
        if (item.hasItemMeta() && item.getItemMeta().displayName() != null && (displayName = item.getItemMeta().displayName()) != null) {
            return PlainTextComponentSerializer.plainText().serialize(displayName);
        }
        return item.getType().name().toLowerCase().replace("_", " ");
    }

    public static boolean isAmountSelectionGUI(Inventory inventory) {
        return inventory.getHolder() instanceof AmountSelectionHolder;
    }

    public static int getSelectedAmount(ItemStack clickedItem, Inventory inventory) {
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return -1;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null || meta.displayName() == null) {
            return -1;
        }
        Component displayNameComponent = meta.displayName();
        if (displayNameComponent == null) {
            return -1;
        }
        String displayName = PlainTextComponentSerializer.plainText().serialize(displayNameComponent);
        if (displayName.equals("Cancel")) {
            return -1;
        }
        if (displayName.startsWith("Select ") && !displayName.startsWith("Select All")) {
            try {
                String amountStr = displayName.substring("Select ".length());
                return Integer.parseInt(amountStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        if (displayName.startsWith("Select All")) {
            if (displayName.contains("(") && displayName.contains(")")) {
                try {
                    int startIndex = displayName.indexOf("(") + 1;
                    int endIndex = displayName.indexOf(")");
                    String amountStr = displayName.substring(startIndex, endIndex);
                    return Integer.parseInt(amountStr);
                }
                catch (NumberFormatException | StringIndexOutOfBoundsException startIndex) {
                    // empty catch block
                }
            }
            if (inventory != null && inventory.getHolder() instanceof AmountSelectionHolder) {
                AmountSelectionHolder holder = (AmountSelectionHolder)inventory.getHolder();
                return holder.getMaxAmount();
            }
        }
        return -1;
    }

    @Deprecated
    public static int getSelectedAmount(ItemStack clickedItem) {
        return AmountSelectionGUI.getSelectedAmount(clickedItem, null);
    }

    public static class AmountSelectionHolder
    implements InventoryHolder {
        private final ItemStack item;
        private final int maxAmount;

        public AmountSelectionHolder(ItemStack item, int maxAmount) {
            this.item = item;
            this.maxAmount = maxAmount;
        }

        public Inventory getInventory() {
            return null;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }
}

