/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import me.yourname.p2pTrader.AmountSelectionGUI;
import me.yourname.p2pTrader.NewTradeManager;
import me.yourname.p2pTrader.TradeSession;
import me.yourname.p2pTrader.TradeValidator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NewTradeCommand
implements CommandExecutor {
    private final NewTradeManager tradeManager;

    public NewTradeCommand(NewTradeManager tradeManager) {
        this.tradeManager = tradeManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"This command can only be used by players!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("P2PTrader.trade")) {
            player.sendMessage(Component.text((String)"You don't have permission to use this command!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            this.showHelp(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "request": {
                return this.handleTradeRequest(player, args);
            }
            case "accept": {
                return this.handleTradeAccept(player, args);
            }
            case "add": {
                return this.handleAddItem(player);
            }
            case "remove": {
                return this.handleRemoveItem(player, args);
            }
            case "confirm": {
                return this.handleConfirm(player);
            }
            case "cancel": {
                return this.handleCancel(player);
            }
            case "status": {
                return this.handleStatus(player);
            }
        }
        return this.handleTradeRequest(player, args);
    }

    private boolean handleTradeRequest(Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Usage: /trade <player> or /trade request <player>").color((TextColor)NamedTextColor.RED));
            return true;
        }
        String targetName = args.length > 1 ? args[1] : args[0];
        Player target = Bukkit.getPlayerExact((String)targetName);
        TradeValidator.TradeValidationResult validation = TradeValidator.validateTradeRequest(player, target);
        if (!validation.isValid()) {
            player.sendMessage(Component.text((String)validation.getErrorMessage()).color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.tradeManager.hasActiveTrade(player.getUniqueId())) {
            player.sendMessage(Component.text((String)"You are already in a trading session!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.tradeManager.hasActiveTrade(target.getUniqueId())) {
            player.sendMessage(Component.text((String)(target.getName() + " is already in a trading session!")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.tradeManager.hasPendingRequest(player, target)) {
            TradeSession session = this.tradeManager.acceptTradeRequest(player, target);
            if (session != null) {
                player.sendMessage(Component.text((String)("Trade started with " + target.getName() + "!")).color((TextColor)NamedTextColor.GREEN));
                target.sendMessage(Component.text((String)(player.getName() + " accepted your trade request!")).color((TextColor)NamedTextColor.GREEN));
                session.updateBothPlayers();
            }
        } else {
            this.tradeManager.sendTradeRequest(player, target);
            player.sendMessage(Component.text((String)("Trade request sent to " + target.getName())).color((TextColor)NamedTextColor.GREEN));
            target.sendMessage(Component.text((String)(player.getName() + " wants to trade with you!")).color((TextColor)NamedTextColor.YELLOW));
            target.sendMessage(Component.text((String)("Type '/trade accept " + player.getName() + "' to accept.")).color((TextColor)NamedTextColor.YELLOW));
        }
        return true;
    }

    private boolean handleTradeAccept(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(Component.text((String)"Usage: /trade accept <player>").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (target == null) {
            player.sendMessage(Component.text((String)"Player not found!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.tradeManager.hasActiveTrade(player.getUniqueId())) {
            player.sendMessage(Component.text((String)"You are already in a trading session!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.tradeManager.hasActiveTrade(target.getUniqueId())) {
            player.sendMessage(Component.text((String)(target.getName() + " is already in a trading session!")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.tradeManager.hasPendingRequest(player, target)) {
            TradeSession session = this.tradeManager.acceptTradeRequest(player, target);
            if (session != null) {
                player.sendMessage(Component.text((String)("Trade started with " + target.getName() + "!")).color((TextColor)NamedTextColor.GREEN));
                target.sendMessage(Component.text((String)(player.getName() + " accepted your trade request!")).color((TextColor)NamedTextColor.GREEN));
                session.updateBothPlayers();
            }
        } else {
            player.sendMessage(Component.text((String)("No pending trade request from " + target.getName())).color((TextColor)NamedTextColor.RED));
        }
        return true;
    }

    private boolean handleAddItem(Player player) {
        TradeSession session = this.tradeManager.getTradeSession(player.getUniqueId());
        if (session == null) {
            player.sendMessage(Component.text((String)"You are not in a trade!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem == null || handItem.getType() == Material.AIR) {
            player.sendMessage(Component.text((String)"You must hold an item in your hand!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        int totalAmount = 0;
        for (ItemStack invItem : player.getInventory().getContents()) {
            if (invItem == null || !invItem.isSimilar(handItem)) continue;
            totalAmount += invItem.getAmount();
        }
        if (totalAmount == 0) {
            player.sendMessage(Component.text((String)"You don't have this item!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (handItem.getMaxStackSize() > 1 && totalAmount > 1) {
            AmountSelectionGUI.openAmountSelection(player, handItem, totalAmount);
        } else {
            session.addItemToOffer(player.getUniqueId(), handItem, 1);
            player.sendMessage(Component.text((String)("Added " + this.getItemName(handItem) + " to your trade offer!")).color((TextColor)NamedTextColor.GREEN));
        }
        return true;
    }

    private boolean handleRemoveItem(Player player, String[] args) {
        TradeSession session = this.tradeManager.getTradeSession(player.getUniqueId());
        if (session == null) {
            player.sendMessage(Component.text((String)"You are not in a trade!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(Component.text((String)"Usage: /trade remove <item_number>").color((TextColor)NamedTextColor.RED));
            return true;
        }
        try {
            int itemIndex = Integer.parseInt(args[1]) - 1;
            session.removeItemFromOffer(player.getUniqueId(), itemIndex);
            player.sendMessage(Component.text((String)"Removed item from your trade offer!").color((TextColor)NamedTextColor.GREEN));
        }
        catch (NumberFormatException e) {
            player.sendMessage(Component.text((String)"Invalid item number!").color((TextColor)NamedTextColor.RED));
        }
        return true;
    }

    private boolean handleConfirm(Player player) {
        TradeSession session = this.tradeManager.getTradeSession(player.getUniqueId());
        if (session == null) {
            player.sendMessage(Component.text((String)"You are not in a trade!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (session.confirmTrade(player.getUniqueId())) {
            this.tradeManager.completeTrade(player.getUniqueId());
        }
        return true;
    }

    private boolean handleCancel(Player player) {
        TradeSession session = this.tradeManager.getTradeSession(player.getUniqueId());
        if (session == null) {
            player.sendMessage(Component.text((String)"You are not in a trade!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player otherPlayer = session.getOtherPlayer(player.getUniqueId());
        this.tradeManager.cancelTrade(player.getUniqueId());
        player.sendMessage(Component.text((String)"Trade cancelled!").color((TextColor)NamedTextColor.RED));
        if (otherPlayer != null) {
            otherPlayer.sendMessage(Component.text((String)("Trade cancelled by " + player.getName() + "!")).color((TextColor)NamedTextColor.RED));
        }
        return true;
    }

    private boolean handleStatus(Player player) {
        TradeSession session = this.tradeManager.getTradeSession(player.getUniqueId());
        if (session == null) {
            player.sendMessage(Component.text((String)"You are not in a trade!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        session.updateBothPlayers();
        return true;
    }

    private void showHelp(Player player) {
        player.sendMessage(Component.text((String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557").color((TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text((String)"\u2551                    P2PTrader v1.0.0                          \u2551").color((TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text((String)"\u2551              Professional Trading Commands                   \u2551").color((TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text((String)"\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563").color((TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text((String)"\u2551 /trade <player>      - Send secure trade request             \u2551").color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(Component.text((String)"\u2551 /trade accept <player> - Accept trade request                \u2551").color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(Component.text((String)"\u2551 /trade add           - Add item from hand to trade           \u2551").color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(Component.text((String)"\u2551 /trade remove <#>    - Remove item from trade                \u2551").color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(Component.text((String)"\u2551 /trade confirm       - Confirm your trade                    \u2551").color((TextColor)NamedTextColor.GREEN));
        player.sendMessage(Component.text((String)"\u2551 /trade cancel        - Cancel current trade                  \u2551").color((TextColor)NamedTextColor.RED));
        player.sendMessage(Component.text((String)"\u2551 /trade status        - Show detailed trade status            \u2551").color((TextColor)NamedTextColor.AQUA));
        player.sendMessage(Component.text((String)"\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563").color((TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text((String)"\u2551 Features: Anti-Scam \u2022 Hover Info \u2022 Session Protection        \u2551").color((TextColor)NamedTextColor.GRAY));
        player.sendMessage(Component.text((String)"\u2551 Developed by Nouridin - https://github.com/Nouridin          \u2551").color((TextColor)NamedTextColor.GRAY));
        player.sendMessage(Component.text((String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\ufffd\ufffd\ufffd\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 \u2550\u2550\u2550\u2550\u255d").color((TextColor)NamedTextColor.GOLD));
    }

    private String getItemName(ItemStack item) {
        Component displayName;
        if (item.hasItemMeta() && item.getItemMeta().displayName() != null && (displayName = item.getItemMeta().displayName()) != null) {
            return PlainTextComponentSerializer.plainText().serialize(displayName);
        }
        return item.getType().name().toLowerCase().replace("_", " ");
    }
}

