/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import java.util.UUID;
import me.yourname.p2pTrader.AmountSelectionGUI;
import me.yourname.p2pTrader.NewTradeManager;
import me.yourname.p2pTrader.TradeSession;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NewTradeEventHandler
implements Listener {
    private final NewTradeManager tradeManager;

    public NewTradeEventHandler(NewTradeManager tradeManager) {
        this.tradeManager = tradeManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        if (AmountSelectionGUI.isAmountSelectionGUI(e.getInventory())) {
            e.setCancelled(true);
            ItemStack clickedItem = e.getCurrentItem();
            if (clickedItem == null) {
                return;
            }
            int selectedAmount = AmountSelectionGUI.getSelectedAmount(clickedItem, e.getInventory());
            if (selectedAmount == -1) {
                player.closeInventory();
                player.sendMessage(Component.text((String)"Item selection cancelled.").color((TextColor)NamedTextColor.YELLOW));
                return;
            }
            ItemStack displayItem = e.getInventory().getItem(4);
            if (displayItem == null) {
                player.closeInventory();
                player.sendMessage(Component.text((String)"Error: Could not find item to add.").color((TextColor)NamedTextColor.RED));
                return;
            }
            TradeSession session = this.tradeManager.getTradeSession(player.getUniqueId());
            if (session != null) {
                ItemStack itemToAdd = displayItem.clone();
                itemToAdd.setAmount(1);
                if (itemToAdd.hasItemMeta()) {
                    ItemMeta meta = itemToAdd.getItemMeta();
                    meta.displayName(null);
                    meta.lore(null);
                    itemToAdd.setItemMeta(meta);
                }
                session.addItemToOffer(player.getUniqueId(), itemToAdd, selectedAmount);
                player.sendMessage(Component.text((String)("Added " + selectedAmount + "x " + this.getItemName(itemToAdd) + " to your trade offer!")).color((TextColor)NamedTextColor.GREEN));
            }
            player.closeInventory();
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player otherPlayer;
        UUID uuid = e.getPlayer().getUniqueId();
        TradeSession session = this.tradeManager.getTradeSession(uuid);
        if (session != null && (otherPlayer = session.getOtherPlayer(uuid)) != null && otherPlayer.isOnline()) {
            otherPlayer.sendMessage(Component.text((String)("Trade cancelled: " + e.getPlayer().getName() + " left the game.")).color((TextColor)NamedTextColor.RED));
        }
        this.tradeManager.cleanupPlayer(uuid);
    }

    private String getItemName(ItemStack item) {
        Component displayName;
        if (item.hasItemMeta() && item.getItemMeta().displayName() != null && (displayName = item.getItemMeta().displayName()) != null) {
            return PlainTextComponentSerializer.plainText().serialize(displayName);
        }
        return item.getType().name().toLowerCase().replace("_", " ");
    }
}

