/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.yourname.p2pTrader.TradeSession;
import org.bukkit.entity.Player;

public class NewTradeManager {
    private final Map<UUID, UUID> pendingRequests = new HashMap<UUID, UUID>();
    private final Map<UUID, TradeSession> activeTrades = new HashMap<UUID, TradeSession>();

    public void sendTradeRequest(Player requester, Player target) {
        this.pendingRequests.put(target.getUniqueId(), requester.getUniqueId());
    }

    public boolean hasPendingRequest(Player player, Player target) {
        UUID requesterId = this.pendingRequests.get(player.getUniqueId());
        return requesterId != null && requesterId.equals(target.getUniqueId());
    }

    public TradeSession acceptTradeRequest(Player player, Player target) {
        if (this.hasPendingRequest(player, target)) {
            this.pendingRequests.remove(player.getUniqueId());
            TradeSession session = new TradeSession(target, player);
            this.activeTrades.put(player.getUniqueId(), session);
            this.activeTrades.put(target.getUniqueId(), session);
            return session;
        }
        return null;
    }

    public TradeSession getTradeSession(UUID playerId) {
        return this.activeTrades.get(playerId);
    }

    public boolean hasActiveTrade(UUID playerId) {
        return this.activeTrades.containsKey(playerId);
    }

    public void cancelTrade(UUID playerId) {
        TradeSession session = this.activeTrades.get(playerId);
        if (session != null) {
            Player player1 = session.getPlayer1();
            Player player2 = session.getPlayer2();
            if (player1 != null) {
                this.activeTrades.remove(player1.getUniqueId());
            }
            if (player2 != null) {
                this.activeTrades.remove(player2.getUniqueId());
            }
        }
    }

    public void completeTrade(UUID playerId) {
        this.cancelTrade(playerId);
    }

    public void cleanupPlayer(UUID playerId) {
        this.pendingRequests.remove(playerId);
        this.cancelTrade(playerId);
        this.pendingRequests.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(playerId));
    }

    public void removePendingRequest(UUID playerId) {
        this.pendingRequests.remove(playerId);
    }
}

