/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.inventory.ItemStack;

public class TradeItem {
    private final ItemStack itemStack;
    private final int amount;
    private final String displayName;
    private final String description;

    public TradeItem(ItemStack itemStack, int amount) {
        this.itemStack = itemStack.clone();
        this.amount = amount;
        this.displayName = this.getItemDisplayName(itemStack);
        this.description = this.getItemDescription(itemStack);
    }

    private String getItemDisplayName(ItemStack item) {
        Component displayName;
        if (item.hasItemMeta() && item.getItemMeta().displayName() != null && (displayName = item.getItemMeta().displayName()) != null) {
            return PlainTextComponentSerializer.plainText().serialize(displayName);
        }
        return item.getType().name().toLowerCase().replace("_", " ");
    }

    private String getItemDescription(ItemStack item) {
        StringBuilder desc = new StringBuilder();
        desc.append("Type: ").append(item.getType().name());
        if (item.hasItemMeta()) {
            if (item.getItemMeta().lore() != null && !item.getItemMeta().lore().isEmpty()) {
                desc.append("\nLore: ");
                for (Component loreComponent : item.getItemMeta().lore()) {
                    String loreText = PlainTextComponentSerializer.plainText().serialize(loreComponent);
                    desc.append("\n  - ").append(loreText);
                }
            }
            if (item.getItemMeta().hasEnchants()) {
                desc.append("\nEnchantments: ");
                item.getItemMeta().getEnchants().forEach((enchant, level) -> desc.append("\n  - ").append(enchant.getKey().getKey()).append(" ").append(level));
            }
        }
        return desc.toString();
    }

    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public int getAmount() {
        return this.amount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ItemStack createItemStackWithAmount() {
        ItemStack result = this.itemStack.clone();
        result.setAmount(this.amount);
        return result;
    }
}

