/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class TradeManager {
    private final Map<UUID, UUID> pendingRequests = new HashMap<UUID, UUID>();
    private final Map<UUID, Inventory> activeTrades = new HashMap<UUID, Inventory>();
    private final Set<UUID> confirmedTrades = new HashSet<UUID>();
    private final Map<Inventory, UUID> leftSidePlayers = new HashMap<Inventory, UUID>();

    public void addPendingRequest(UUID requester, UUID target) {
        this.pendingRequests.put(target, requester);
    }

    public boolean hasPendingRequest(UUID requester, UUID target) {
        return this.pendingRequests.containsKey(requester) && this.pendingRequests.get(requester).equals(target);
    }

    public void removePendingRequest(UUID playerId) {
        this.pendingRequests.remove(playerId);
    }

    public void addActiveTrade(UUID player1, UUID player2, Inventory inventory) {
        this.activeTrades.put(player1, inventory);
        this.activeTrades.put(player2, inventory);
        this.leftSidePlayers.put(inventory, player1);
    }

    public boolean hasActiveTrade(UUID playerId) {
        return this.activeTrades.containsKey(playerId);
    }

    public Inventory getTradeInventory(UUID playerId) {
        return this.activeTrades.get(playerId);
    }

    public Player getOtherPlayer(UUID currentPlayer, Inventory inv) {
        for (Map.Entry<UUID, Inventory> entry : this.activeTrades.entrySet()) {
            if (!entry.getValue().equals(inv) || entry.getKey().equals(currentPlayer)) continue;
            return Bukkit.getPlayer((UUID)entry.getKey());
        }
        return null;
    }

    public boolean isPlayerLeftSide(UUID playerId, Inventory inv) {
        UUID leftSidePlayer = this.leftSidePlayers.get(inv);
        return leftSidePlayer != null && leftSidePlayer.equals(playerId);
    }

    public void addConfirmation(UUID playerId) {
        this.confirmedTrades.add(playerId);
    }

    public boolean hasConfirmed(UUID playerId) {
        return this.confirmedTrades.contains(playerId);
    }

    public void resetConfirmations(Inventory inv) {
        List<UUID> playersInTrade = this.getPlayersInTrade(inv);
        for (UUID playerId : playersInTrade) {
            this.confirmedTrades.remove(playerId);
        }
    }

    public List<UUID> getPlayersInTrade(Inventory inv) {
        ArrayList<UUID> players = new ArrayList<UUID>();
        for (Map.Entry<UUID, Inventory> entry : this.activeTrades.entrySet()) {
            if (!entry.getValue().equals(inv)) continue;
            players.add(entry.getKey());
        }
        return players;
    }

    public boolean areBothPlayersConfirmed(Inventory inv) {
        List<UUID> players = this.getPlayersInTrade(inv);
        if (players.size() != 2) {
            return false;
        }
        return this.confirmedTrades.contains(players.get(0)) && this.confirmedTrades.contains(players.get(1));
    }

    public void removeTrade(Inventory inv) {
        List<UUID> players = this.getPlayersInTrade(inv);
        for (UUID playerId : players) {
            this.activeTrades.remove(playerId);
            this.confirmedTrades.remove(playerId);
        }
        this.leftSidePlayers.remove(inv);
    }

    public void cleanupPlayer(UUID playerId) {
        this.pendingRequests.remove(playerId);
        if (this.activeTrades.containsKey(playerId)) {
            Inventory inv = this.activeTrades.get(playerId);
            this.leftSidePlayers.remove(inv);
        }
        this.activeTrades.remove(playerId);
        this.confirmedTrades.remove(playerId);
    }

    @Deprecated
    public void cleanupTradeOnClose(UUID playerId) {
        if (this.activeTrades.containsKey(playerId)) {
            Inventory inv = this.activeTrades.get(playerId);
            this.activeTrades.values().removeIf(value -> value.equals(inv));
            this.activeTrades.remove(playerId);
            this.confirmedTrades.remove(playerId);
            this.leftSidePlayers.remove(inv);
        }
    }
}

