/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.yourname.p2pTrader.TradeItem;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TradeOffer {
    private final UUID playerId;
    private final String playerName;
    private final List<TradeItem> items;
    private boolean confirmed;

    public TradeOffer(Player player) {
        this.playerId = player.getUniqueId();
        this.playerName = player.getName();
        this.items = new ArrayList<TradeItem>();
        this.confirmed = false;
    }

    public void addItem(ItemStack itemStack, int amount) {
        for (TradeItem existingItem : this.items) {
            if (!existingItem.getItemStack().isSimilar(itemStack)) continue;
            this.items.remove(existingItem);
            this.items.add(new TradeItem(itemStack, existingItem.getAmount() + amount));
            return;
        }
        this.items.add(new TradeItem(itemStack, amount));
    }

    public void removeItem(int index) {
        if (index >= 0 && index < this.items.size()) {
            this.items.remove(index);
        }
    }

    public void clearItems() {
        this.items.clear();
    }

    public List<TradeItem> getItems() {
        return new ArrayList<TradeItem>(this.items);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void resetConfirmation() {
        this.confirmed = false;
    }

    public boolean validateInventory(Player player) {
        for (TradeItem tradeItem : this.items) {
            if (this.hasEnoughItems(player, tradeItem.getItemStack(), tradeItem.getAmount())) continue;
            return false;
        }
        return true;
    }

    private boolean hasEnoughItems(Player player, ItemStack itemStack, int requiredAmount) {
        int totalAmount = 0;
        for (ItemStack invItem : player.getInventory().getContents()) {
            if (invItem == null || !invItem.isSimilar(itemStack)) continue;
            totalAmount += invItem.getAmount();
        }
        return totalAmount >= requiredAmount;
    }

    public boolean removeItemsFromInventory(Player player) {
        if (!this.validateInventory(player)) {
            return false;
        }
        for (TradeItem tradeItem : this.items) {
            this.removeItemFromInventory(player, tradeItem.getItemStack(), tradeItem.getAmount());
        }
        return true;
    }

    private void removeItemFromInventory(Player player, ItemStack itemStack, int amountToRemove) {
        int remaining = amountToRemove;
        for (int i = 0; i < player.getInventory().getSize() && remaining > 0; ++i) {
            ItemStack invItem = player.getInventory().getItem(i);
            if (invItem == null || !invItem.isSimilar(itemStack)) continue;
            int takeAmount = Math.min(remaining, invItem.getAmount());
            remaining -= takeAmount;
            if (takeAmount >= invItem.getAmount()) {
                player.getInventory().setItem(i, null);
                continue;
            }
            invItem.setAmount(invItem.getAmount() - takeAmount);
        }
    }

    public boolean validateInventorySpace(Player player) {
        ItemStack[] inventoryContents = (ItemStack[])player.getInventory().getContents().clone();
        for (TradeItem tradeItem : this.items) {
            ItemStack itemToAdd = tradeItem.createItemStackWithAmount();
            if (!this.canFitInInventory(inventoryContents, itemToAdd)) {
                return false;
            }
            this.addItemToInventorySimulation(inventoryContents, itemToAdd);
        }
        return true;
    }

    private boolean canFitInInventory(ItemStack[] inventory, ItemStack itemToAdd) {
        int remainingAmount = itemToAdd.getAmount();
        for (int i = 0; i < inventory.length && remainingAmount > 0; ++i) {
            int maxStack;
            int canAdd;
            ItemStack[] slot = inventory[i];
            if (slot == null || !slot.isSimilar(itemToAdd) || (canAdd = (maxStack = slot.getMaxStackSize()) - slot.getAmount()) <= 0) continue;
            remainingAmount -= Math.min(canAdd, remainingAmount);
        }
        if (remainingAmount > 0) {
            int emptySlots = 0;
            for (ItemStack slot : inventory) {
                if (slot != null) continue;
                ++emptySlots;
            }
            int maxStack = itemToAdd.getMaxStackSize();
            int slotsNeeded = (int)Math.ceil((double)remainingAmount / (double)maxStack);
            return emptySlots >= slotsNeeded;
        }
        return true;
    }

    private void addItemToInventorySimulation(ItemStack[] inventory, ItemStack itemToAdd) {
        int i;
        int remainingAmount = itemToAdd.getAmount();
        for (i = 0; i < inventory.length && remainingAmount > 0; ++i) {
            int maxStack;
            int canAdd;
            ItemStack slot = inventory[i];
            if (slot == null || !slot.isSimilar(itemToAdd) || (canAdd = (maxStack = slot.getMaxStackSize()) - slot.getAmount()) <= 0) continue;
            int addAmount = Math.min(canAdd, remainingAmount);
            slot.setAmount(slot.getAmount() + addAmount);
            remainingAmount -= addAmount;
        }
        for (i = 0; i < inventory.length && remainingAmount > 0; ++i) {
            if (inventory[i] != null) continue;
            int maxStack = itemToAdd.getMaxStackSize();
            int addAmount = Math.min(maxStack, remainingAmount);
            ItemStack newStack = itemToAdd.clone();
            newStack.setAmount(addAmount);
            inventory[i] = newStack;
            remainingAmount -= addAmount;
        }
    }

    public int getRequiredInventorySlots(Player player) {
        ItemStack[] inventoryContents = (ItemStack[])player.getInventory().getContents().clone();
        int slotsUsed = 0;
        for (TradeItem tradeItem : this.items) {
            ItemStack itemToAdd = tradeItem.createItemStackWithAmount();
            int remainingAmount = itemToAdd.getAmount();
            for (int i = 0; i < inventoryContents.length && remainingAmount > 0; ++i) {
                int maxStack;
                int canAdd;
                ItemStack slot = inventoryContents[i];
                if (slot == null || !slot.isSimilar(itemToAdd) || (canAdd = (maxStack = slot.getMaxStackSize()) - slot.getAmount()) <= 0) continue;
                int addAmount = Math.min(canAdd, remainingAmount);
                slot.setAmount(slot.getAmount() + addAmount);
                remainingAmount -= addAmount;
            }
            if (remainingAmount <= 0) continue;
            int maxStack = itemToAdd.getMaxStackSize();
            slotsUsed += (int)Math.ceil((double)remainingAmount / (double)maxStack);
        }
        return slotsUsed;
    }

    public boolean giveItemsToPlayer(Player player) {
        if (!this.validateInventorySpace(player)) {
            return false;
        }
        for (TradeItem tradeItem : this.items) {
            ItemStack itemToGive = tradeItem.createItemStackWithAmount();
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{itemToGive});
            if (leftover.isEmpty()) continue;
            for (ItemStack leftoverItem : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), leftoverItem);
            }
        }
        return true;
    }
}

