/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.yourname.p2pTrader.TradeItem;
import me.yourname.p2pTrader.TradeOffer;
import me.yourname.p2pTrader.TradeValidator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public class TradeSession {
    private final UUID sessionId = UUID.randomUUID();
    private final TradeOffer player1Offer;
    private final TradeOffer player2Offer;
    private final long createdTime;

    public TradeSession(Player player1, Player player2) {
        this.player1Offer = new TradeOffer(player1);
        this.player2Offer = new TradeOffer(player2);
        this.createdTime = System.currentTimeMillis();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public TradeOffer getPlayerOffer(UUID playerId) {
        if (this.player1Offer.getPlayerId().equals(playerId)) {
            return this.player1Offer;
        }
        if (this.player2Offer.getPlayerId().equals(playerId)) {
            return this.player2Offer;
        }
        return null;
    }

    public TradeOffer getOtherPlayerOffer(UUID playerId) {
        if (this.player1Offer.getPlayerId().equals(playerId)) {
            return this.player2Offer;
        }
        if (this.player2Offer.getPlayerId().equals(playerId)) {
            return this.player1Offer;
        }
        return null;
    }

    public boolean containsPlayer(UUID playerId) {
        return this.player1Offer.getPlayerId().equals(playerId) || this.player2Offer.getPlayerId().equals(playerId);
    }

    public Player getPlayer1() {
        return Bukkit.getPlayer((UUID)this.player1Offer.getPlayerId());
    }

    public Player getPlayer2() {
        return Bukkit.getPlayer((UUID)this.player2Offer.getPlayerId());
    }

    public Player getOtherPlayer(UUID playerId) {
        if (this.player1Offer.getPlayerId().equals(playerId)) {
            return this.getPlayer2();
        }
        if (this.player2Offer.getPlayerId().equals(playerId)) {
            return this.getPlayer1();
        }
        return null;
    }

    public void addItemToOffer(UUID playerId, ItemStack itemStack, int amount) {
        TradeOffer offer = this.getPlayerOffer(playerId);
        if (offer != null) {
            offer.addItem(itemStack, amount);
            offer.resetConfirmation();
            TradeOffer otherOffer = this.getOtherPlayerOffer(playerId);
            if (otherOffer != null) {
                otherOffer.resetConfirmation();
            }
            this.updateBothPlayers();
        }
    }

    public void removeItemFromOffer(UUID playerId, int itemIndex) {
        TradeOffer offer = this.getPlayerOffer(playerId);
        if (offer != null) {
            offer.removeItem(itemIndex);
            offer.resetConfirmation();
            TradeOffer otherOffer = this.getOtherPlayerOffer(playerId);
            if (otherOffer != null) {
                otherOffer.resetConfirmation();
            }
            this.updateBothPlayers();
        }
    }

    public boolean confirmTrade(UUID playerId) {
        TradeOffer offer = this.getPlayerOffer(playerId);
        if (offer != null) {
            offer.setConfirmed(true);
            Player player = Bukkit.getPlayer((UUID)playerId);
            Player otherPlayer = this.getOtherPlayer(playerId);
            if (player != null && otherPlayer != null) {
                player.sendMessage(Component.text((String)"You confirmed the trade!").color((TextColor)NamedTextColor.GREEN));
                otherPlayer.sendMessage(Component.text((String)(player.getName() + " confirmed their trade!")).color((TextColor)NamedTextColor.YELLOW));
                if (this.areBothPlayersConfirmed()) {
                    return this.executeTrade();
                }
                this.updateBothPlayers();
            }
        }
        return false;
    }

    public boolean areBothPlayersConfirmed() {
        return this.player1Offer.isConfirmed() && this.player2Offer.isConfirmed();
    }

    private boolean executeTrade() {
        Player player1 = this.getPlayer1();
        Player player2 = this.getPlayer2();
        if (player1 == null || player2 == null) {
            return false;
        }
        if (!this.player1Offer.validateInventory(player1)) {
            player1.sendMessage(Component.text((String)"Trade failed: You don't have all the required items!").color((TextColor)NamedTextColor.RED));
            player2.sendMessage(Component.text((String)("Trade failed: " + player1.getName() + " doesn't have all required items!")).color((TextColor)NamedTextColor.RED));
            return false;
        }
        if (!this.player2Offer.validateInventory(player2)) {
            player1.sendMessage(Component.text((String)("Trade failed: " + player2.getName() + " doesn't have all required items!")).color((TextColor)NamedTextColor.RED));
            player2.sendMessage(Component.text((String)"Trade failed: You don't have all the required items!").color((TextColor)NamedTextColor.RED));
            return false;
        }
        if (!TradeValidator.arePlayersCloseEnough(player1, player2)) {
            player1.sendMessage(Component.text((String)"Trade failed: You are too far apart!").color((TextColor)NamedTextColor.RED));
            player2.sendMessage(Component.text((String)"Trade failed: You are too far apart!").color((TextColor)NamedTextColor.RED));
            return false;
        }
        if (!this.player2Offer.validateInventorySpace(player1)) {
            int slotsNeeded = this.player2Offer.getRequiredInventorySlots(player1);
            player1.sendMessage(Component.text((String)("Trade failed: You need " + slotsNeeded + " more inventory slots!")).color((TextColor)NamedTextColor.RED));
            player2.sendMessage(Component.text((String)("Trade failed: " + player1.getName() + " doesn't have enough inventory space!")).color((TextColor)NamedTextColor.RED));
            return false;
        }
        if (!this.player1Offer.validateInventorySpace(player2)) {
            int slotsNeeded = this.player1Offer.getRequiredInventorySlots(player2);
            player1.sendMessage(Component.text((String)("Trade failed: " + player2.getName() + " doesn't have enough inventory space!")).color((TextColor)NamedTextColor.RED));
            player2.sendMessage(Component.text((String)("Trade failed: You need " + slotsNeeded + " more inventory slots!")).color((TextColor)NamedTextColor.RED));
            return false;
        }
        if (this.player1Offer.removeItemsFromInventory(player1) && this.player2Offer.removeItemsFromInventory(player2)) {
            boolean success1 = this.player1Offer.giveItemsToPlayer(player2);
            boolean success2 = this.player2Offer.giveItemsToPlayer(player1);
            if (success1 && success2) {
                player1.sendMessage(Component.text((String)("Trade completed successfully with " + player2.getName() + "!")).color((TextColor)NamedTextColor.GREEN));
                player2.sendMessage(Component.text((String)("Trade completed successfully with " + player1.getName() + "!")).color((TextColor)NamedTextColor.GREEN));
                return true;
            }
            player1.sendMessage(Component.text((String)"Trade completed but some items were dropped on the ground!").color((TextColor)NamedTextColor.YELLOW));
            player2.sendMessage(Component.text((String)"Trade completed but some items were dropped on the ground!").color((TextColor)NamedTextColor.YELLOW));
            return true;
        }
        player1.sendMessage(Component.text((String)"Trade failed: Could not remove items from inventory!").color((TextColor)NamedTextColor.RED));
        player2.sendMessage(Component.text((String)"Trade failed: Could not remove items from inventory!").color((TextColor)NamedTextColor.RED));
        return false;
    }

    public void updateBothPlayers() {
        Player player1 = this.getPlayer1();
        Player player2 = this.getPlayer2();
        if (player1 != null) {
            this.sendTradeUpdate(player1);
        }
        if (player2 != null) {
            this.sendTradeUpdate(player2);
        }
    }

    private void sendTradeUpdate(Player player) {
        player.sendMessage(Component.text((String)"=== TRADE STATUS ===").color((TextColor)NamedTextColor.GOLD));
        TradeOffer myOffer = this.getPlayerOffer(player.getUniqueId());
        TradeOffer otherOffer = this.getOtherPlayerOffer(player.getUniqueId());
        Player otherPlayer = this.getOtherPlayer(player.getUniqueId());
        if (myOffer != null && otherOffer != null && otherPlayer != null) {
            Component itemComponent;
            TradeItem item;
            int i;
            player.sendMessage(Component.text((String)"Your offer:").color((TextColor)NamedTextColor.YELLOW));
            if (myOffer.isEmpty()) {
                player.sendMessage(Component.text((String)"  (No items)").color((TextColor)NamedTextColor.GRAY));
            } else {
                for (i = 0; i < myOffer.getItems().size(); ++i) {
                    item = myOffer.getItems().get(i);
                    itemComponent = this.createItemComponent(item, i + 1);
                    player.sendMessage(itemComponent);
                }
            }
            player.sendMessage(Component.text((String)(otherPlayer.getName() + "'s offer:")).color((TextColor)NamedTextColor.YELLOW));
            if (otherOffer.isEmpty()) {
                player.sendMessage(Component.text((String)"  (No items)").color((TextColor)NamedTextColor.GRAY));
            } else {
                for (i = 0; i < otherOffer.getItems().size(); ++i) {
                    item = otherOffer.getItems().get(i);
                    itemComponent = this.createItemComponent(item, i + 1);
                    player.sendMessage(itemComponent);
                }
            }
            Component myStatus = myOffer.isConfirmed() ? Component.text((String)"CONFIRMED").color((TextColor)NamedTextColor.GREEN) : Component.text((String)"NOT CONFIRMED").color((TextColor)NamedTextColor.RED);
            Component otherStatus = otherOffer.isConfirmed() ? Component.text((String)"CONFIRMED").color((TextColor)NamedTextColor.GREEN) : Component.text((String)"NOT CONFIRMED").color((TextColor)NamedTextColor.RED);
            player.sendMessage(Component.text((String)"Status:").color((TextColor)NamedTextColor.YELLOW));
            player.sendMessage(((TextComponent)Component.text((String)"  You: ").color((TextColor)NamedTextColor.WHITE)).append(myStatus));
            player.sendMessage(((TextComponent)Component.text((String)("  " + otherPlayer.getName() + ": ")).color((TextColor)NamedTextColor.WHITE)).append(otherStatus));
            int slotsNeeded = otherOffer.getRequiredInventorySlots(player);
            int emptySlots = this.getEmptyInventorySlots(player);
            if (slotsNeeded > 0) {
                Component spaceStatus = emptySlots >= slotsNeeded ? Component.text((String)("\u2713 Enough space (" + emptySlots + "/" + slotsNeeded + " slots)")).color((TextColor)NamedTextColor.GREEN) : Component.text((String)("\u2717 Need " + (slotsNeeded - emptySlots) + " more slots (" + emptySlots + "/" + slotsNeeded + ")")).color((TextColor)NamedTextColor.RED);
                player.sendMessage(((TextComponent)Component.text((String)"Inventory Space: ").color((TextColor)NamedTextColor.YELLOW)).append(spaceStatus));
            }
            player.sendMessage(Component.text((String)"Commands:").color((TextColor)NamedTextColor.AQUA));
            player.sendMessage(Component.text((String)"  /trade add - Add item from hand").color((TextColor)NamedTextColor.WHITE));
            player.sendMessage(Component.text((String)"  /trade remove <number> - Remove item").color((TextColor)NamedTextColor.WHITE));
            player.sendMessage(Component.text((String)"  /trade confirm - Confirm trade").color((TextColor)NamedTextColor.WHITE));
            player.sendMessage(Component.text((String)"  /trade cancel - Cancel trade").color((TextColor)NamedTextColor.WHITE));
        }
        player.sendMessage(Component.text((String)"==================").color((TextColor)NamedTextColor.GOLD));
    }

    private Component createItemComponent(TradeItem item, int index) {
        Component mainText = Component.text((String)("  " + index + ". " + item.getDisplayName() + " x" + item.getAmount())).color((TextColor)NamedTextColor.WHITE);
        Component hoverText = this.createItemHoverText(item);
        return mainText.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText));
    }

    private Component createItemHoverText(TradeItem item) {
        ItemStack itemStack = item.getItemStack();
        ArrayList<Component> components = new ArrayList<Component>();
        Component itemName = Component.text((String)item.getDisplayName()).color((TextColor)this.getItemRarityColor(itemStack));
        components.add(itemName);
        components.add((Component)Component.newline());
        components.add(Component.text((String)("Type: " + this.formatMaterialName(itemStack.getType().name()))).color((TextColor)NamedTextColor.GRAY));
        components.add((Component)Component.newline());
        components.add(Component.text((String)("Amount: " + item.getAmount())).color((TextColor)NamedTextColor.GRAY));
        components.add((Component)Component.newline());
        if (itemStack.getType().getMaxDurability() > 0) {
            int currentDurability = itemStack.getType().getMaxDurability() - itemStack.getDurability();
            short maxDurability = itemStack.getType().getMaxDurability();
            double durabilityPercent = (double)currentDurability / (double)maxDurability * 100.0;
            NamedTextColor durabilityColor = this.getDurabilityColor(durabilityPercent);
            components.add(Component.text((String)("Durability: " + currentDurability + "/" + maxDurability + " (" + String.format("%.1f", durabilityPercent) + "%)")).color((TextColor)durabilityColor));
            components.add((Component)Component.newline());
            String durabilityStatus = this.getDurabilityStatus(durabilityPercent);
            components.add(Component.text((String)("Condition: " + durabilityStatus)).color((TextColor)durabilityColor));
            components.add((Component)Component.newline());
        }
        if (itemStack.getType().name().equals("ENCHANTED_BOOK")) {
            EnchantmentStorageMeta bookMeta;
            components.add(Component.text((String)"Enchantment Book").color((TextColor)NamedTextColor.LIGHT_PURPLE));
            components.add((Component)Component.newline());
            if (itemStack.hasItemMeta() && (bookMeta = (EnchantmentStorageMeta)itemStack.getItemMeta()).hasStoredEnchants()) {
                components.add(Component.text((String)"Stored Enchantments:").color((TextColor)NamedTextColor.LIGHT_PURPLE));
                components.add((Component)Component.newline());
                bookMeta.getStoredEnchants().forEach((enchant, level) -> {
                    String enchantName = this.formatEnchantmentName(enchant.getKey().getKey());
                    String levelRoman = this.getRomanNumeral((int)level);
                    NamedTextColor enchantColor = this.getEnchantmentColor(enchant.getKey().getKey());
                    components.add(Component.text((String)("  " + enchantName + " " + levelRoman)).color((TextColor)enchantColor));
                    components.add((Component)Component.newline());
                    String description = this.getEnchantmentDescription(enchant.getKey().getKey(), (int)level);
                    if (!description.isEmpty()) {
                        components.add(Component.text((String)("    " + description)).color((TextColor)NamedTextColor.DARK_GRAY));
                        components.add((Component)Component.newline());
                    }
                });
            }
        } else if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants()) {
            components.add(Component.text((String)"Enchantments:").color((TextColor)NamedTextColor.LIGHT_PURPLE));
            components.add((Component)Component.newline());
            itemStack.getItemMeta().getEnchants().forEach((enchant, level) -> {
                String enchantName = this.formatEnchantmentName(enchant.getKey().getKey());
                String levelRoman = this.getRomanNumeral((int)level);
                NamedTextColor enchantColor = this.getEnchantmentColor(enchant.getKey().getKey());
                components.add(Component.text((String)("  " + enchantName + " " + levelRoman)).color((TextColor)enchantColor));
                components.add((Component)Component.newline());
                String description = this.getEnchantmentDescription(enchant.getKey().getKey(), (int)level);
                if (!description.isEmpty()) {
                    components.add(Component.text((String)("    " + description)).color((TextColor)NamedTextColor.DARK_GRAY));
                    components.add((Component)Component.newline());
                }
            });
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().lore() != null && !itemStack.getItemMeta().lore().isEmpty()) {
            components.add(Component.text((String)"Description:").color((TextColor)NamedTextColor.DARK_PURPLE));
            components.add((Component)Component.newline());
            for (Component loreComponent : itemStack.getItemMeta().lore()) {
                components.add(Component.text((String)"  ").append(loreComponent.color((TextColor)NamedTextColor.DARK_PURPLE)));
                components.add((Component)Component.newline());
            }
        }
        this.addAdditionalItemInfo(itemStack, components);
        TextComponent result = Component.empty();
        for (Component comp : components) {
            result = result.append(comp);
        }
        return result;
    }

    private NamedTextColor getItemRarityColor(ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
            return NamedTextColor.AQUA;
        }
        String materialName = item.getType().name();
        if (materialName.contains("DIAMOND")) {
            return NamedTextColor.AQUA;
        }
        if (materialName.contains("GOLD") || materialName.contains("GOLDEN")) {
            return NamedTextColor.YELLOW;
        }
        if (materialName.contains("IRON")) {
            return NamedTextColor.WHITE;
        }
        if (materialName.contains("STONE")) {
            return NamedTextColor.GRAY;
        }
        if (materialName.contains("WOOD") || materialName.contains("LEATHER")) {
            return NamedTextColor.DARK_GRAY;
        }
        if (materialName.equals("ENCHANTED_BOOK")) {
            return NamedTextColor.LIGHT_PURPLE;
        }
        return NamedTextColor.YELLOW;
    }

    private NamedTextColor getDurabilityColor(double percentage) {
        if (percentage >= 80.0) {
            return NamedTextColor.GREEN;
        }
        if (percentage >= 60.0) {
            return NamedTextColor.YELLOW;
        }
        if (percentage >= 40.0) {
            return NamedTextColor.GOLD;
        }
        if (percentage >= 20.0) {
            return NamedTextColor.RED;
        }
        return NamedTextColor.DARK_RED;
    }

    private String getDurabilityStatus(double percentage) {
        if (percentage >= 90.0) {
            return "Pristine";
        }
        if (percentage >= 80.0) {
            return "Excellent";
        }
        if (percentage >= 60.0) {
            return "Good";
        }
        if (percentage >= 40.0) {
            return "Worn";
        }
        if (percentage >= 20.0) {
            return "Damaged";
        }
        if (percentage >= 10.0) {
            return "Heavily Damaged";
        }
        return "Nearly Broken";
    }

    private String formatEnchantmentName(String enchantKey) {
        String name = enchantKey.replace("minecraft:", "").replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase());
        }
        return formatted.toString();
    }

    private String formatMaterialName(String materialName) {
        String name = materialName.replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase());
        }
        return formatted.toString();
    }

    private String getRomanNumeral(int number) {
        if (number <= 0) {
            return String.valueOf(number);
        }
        String[] romanNumerals = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (number < romanNumerals.length) {
            return romanNumerals[number];
        }
        return String.valueOf(number);
    }

    private NamedTextColor getEnchantmentColor(String enchantKey) {
        if (enchantKey.contains("sharpness") || enchantKey.contains("smite") || enchantKey.contains("bane_of_arthropods") || enchantKey.contains("power")) {
            return NamedTextColor.RED;
        }
        if (enchantKey.contains("protection") || enchantKey.contains("blast_protection") || enchantKey.contains("fire_protection") || enchantKey.contains("projectile_protection")) {
            return NamedTextColor.BLUE;
        }
        if (enchantKey.contains("efficiency") || enchantKey.contains("fortune") || enchantKey.contains("silk_touch") || enchantKey.contains("looting")) {
            return NamedTextColor.GREEN;
        }
        if (enchantKey.contains("unbreaking") || enchantKey.contains("mending")) {
            return NamedTextColor.YELLOW;
        }
        return NamedTextColor.AQUA;
    }

    private String getEnchantmentDescription(String enchantKey, int level) {
        switch (enchantKey.replace("minecraft:", "")) {
            case "sharpness": {
                return "+" + (0.5 * (double)level + 0.5) + " attack damage";
            }
            case "smite": {
                return "+" + 2.5 * (double)level + " damage vs undead";
            }
            case "bane_of_arthropods": {
                return "+" + 2.5 * (double)level + " damage vs arthropods";
            }
            case "protection": {
                return level * 4 + "% damage reduction";
            }
            case "fire_protection": {
                return level * 8 + "% fire damage reduction";
            }
            case "blast_protection": {
                return level * 8 + "% explosion damage reduction";
            }
            case "projectile_protection": {
                return level * 8 + "% projectile damage reduction";
            }
            case "efficiency": {
                return "+" + (level * level + 1) + " mining speed";
            }
            case "fortune": {
                return "Increases block drops";
            }
            case "silk_touch": {
                return "Blocks drop themselves";
            }
            case "unbreaking": {
                return 100 / (level + 1) + "% durability usage";
            }
            case "mending": {
                return "Repairs with XP";
            }
            case "looting": {
                return "+" + level + " max mob drops";
            }
            case "power": {
                return "+" + 25 * level + "% bow damage";
            }
            case "punch": {
                return "+" + 3 * level + " blocks knockback";
            }
            case "flame": {
                return "Arrows set targets on fire";
            }
            case "infinity": {
                return "Infinite arrows (requires 1)";
            }
        }
        return "";
    }

    private void addAdditionalItemInfo(ItemStack item, List<Component> components) {
        int maxStack;
        String materialName = item.getType().name();
        if (materialName.contains("POTION")) {
            components.add(Component.text((String)"Potion Effects:").color((TextColor)NamedTextColor.LIGHT_PURPLE));
            components.add((Component)Component.newline());
            components.add(Component.text((String)"  Check item tooltip for effects").color((TextColor)NamedTextColor.GRAY));
            components.add((Component)Component.newline());
        }
        if (item.getType().isEdible()) {
            components.add(Component.text((String)"Food Item").color((TextColor)NamedTextColor.GREEN));
            components.add((Component)Component.newline());
        }
        if (this.isFuel(materialName)) {
            components.add(Component.text((String)"Can be used as fuel").color((TextColor)NamedTextColor.GOLD));
            components.add((Component)Component.newline());
        }
        if ((maxStack = item.getMaxStackSize()) == 1) {
            components.add(Component.text((String)"Not stackable").color((TextColor)NamedTextColor.GRAY));
        } else {
            components.add(Component.text((String)("Max stack: " + maxStack)).color((TextColor)NamedTextColor.GRAY));
        }
        components.add((Component)Component.newline());
    }

    private boolean isFuel(String materialName) {
        return materialName.contains("COAL") || materialName.contains("WOOD") || materialName.contains("LOG") || materialName.contains("PLANK") || materialName.equals("LAVA_BUCKET") || materialName.equals("BLAZE_ROD");
    }

    private int getEmptyInventorySlots(Player player) {
        int emptySlots = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item != null) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }
}

