/*
 * Decompiled with CFR 0.152.
 */
package me.yourname.p2pTrader;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TradeValidator {
    public static TradeValidationResult validateTradeRequest(Player requester, Player target) {
        if (target == null || !target.isOnline()) {
            return new TradeValidationResult(false, "Player not found or offline.");
        }
        if (requester.equals(target)) {
            return new TradeValidationResult(false, "You can't trade with yourself!");
        }
        if (!requester.getWorld().equals(target.getWorld())) {
            return new TradeValidationResult(false, "You can only trade with players in the same world!");
        }
        double distance = requester.getLocation().distance(target.getLocation());
        if (distance > 10.0) {
            return new TradeValidationResult(false, String.format("You are too far away! You must be within %.1f blocks of %s to trade. (Current distance: %.1f blocks)", 10.0, target.getName(), distance));
        }
        return new TradeValidationResult(true, "");
    }

    public static boolean arePlayersCloseEnough(Player player1, Player player2) {
        if (player1 == null || player2 == null) {
            return false;
        }
        if (!player1.getWorld().equals(player2.getWorld())) {
            return false;
        }
        double distance = player1.getLocation().distance(player2.getLocation());
        return distance <= 10.0;
    }

    public static boolean isSystemItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || meta.displayName() == null) {
            return false;
        }
        Component displayNameComponent = meta.displayName();
        if (displayNameComponent == null) {
            return false;
        }
        String displayName = PlainTextComponentSerializer.plainText().serialize(displayNameComponent);
        return displayName.equals("Click to Confirm") || displayName.equals("\u2713 CONFIRMED") || displayName.equals(" ") || displayName.contains(" - READY") || displayName.contains(" - NOT READY");
    }

    public static boolean isValidTradeSlot(int slot, int column, boolean isLeftSide) {
        if (slot < 0 || slot > 44) {
            return false;
        }
        if (column == 4) {
            return false;
        }
        if (isLeftSide) {
            return column <= 3;
        }
        return column >= 5;
    }

    public static class TradeValidationResult {
        private final boolean valid;
        private final String errorMessage;

        public TradeValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

