/*
 * Decompiled with CFR 0.152.
 */
package com.hightide.mc.neoforge.healthplus.item;

import com.hightide.mc.neoforge.healthplus.modules.HealthManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class HeartContainer
extends Item {
    public HeartContainer(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        if (!HealthManager.isPlayerAtMaxHealth(player)) {
            if (player.gameMode().isSurvival()) {
                player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
            }
            HealthManager.addHeartsToMaximum(player, 1);
            player.playNotifySound(SoundEvents.PLAYER_LEVELUP, SoundSource.UI, 1.0f, 0.9f);
            player.displayClientMessage((Component)Component.translatable((String)"item.health_plus.heart_container.use_success", (Object[])new Object[]{HealthManager.getCurrentPlayerMaxHearts(player)}), true);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.translatable((String)"item.health_plus.heart_container.use_fail", (Object[])new Object[]{HealthManager.getCurrentPlayerMaxHearts(player)}), true);
        return InteractionResult.PASS;
    }
}

