/*
 * Decompiled with CFR 0.152.
 */
package com.hightide.mc.neoforge.healthplus.modules;

import com.hightide.mc.neoforge.healthplus.ModGameRules;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class HealthManager {
    public static int getCurrentPlayerMaxHearts(Player player) {
        int maxHealth = (int)player.getAttributes().getValue(Attributes.MAX_HEALTH);
        return maxHealth / 2;
    }

    public static int getCurrentPlayerMaxHealth(Player player) {
        return (int)player.getAttributes().getValue(Attributes.MAX_HEALTH);
    }

    public static boolean isPlayerAtMaxHealth(Player player) {
        int currentHealth = HealthManager.getCurrentPlayerMaxHearts(player);
        if (!Minecraft.getInstance().isSingleplayer()) {
            return currentHealth >= player.level().getServer().getGameRules().getInt(ModGameRules.MAX_PLAYER_HEARTS);
        }
        return currentHealth >= Minecraft.getInstance().getSingleplayerServer().getGameRules().getInt(ModGameRules.MAX_PLAYER_HEARTS);
    }

    public static void addHeartsToMaximum(Player player, int amount) {
        if (!Minecraft.getInstance().isSingleplayer()) {
            MinecraftServer server = player.level().getServer();
            Commands commandManager = server.getCommands();
            CommandSourceStack commandSource = server.createCommandSourceStack();
            commandManager.performPrefixedCommand(commandSource, String.format("attribute %s minecraft:max_health base set %s", player.getName().getString(), HealthManager.getCurrentPlayerMaxHealth(player) + amount * 2));
        } else {
            IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
            Commands commandManager = server.getCommands();
            CommandSourceStack commandSource = server.createCommandSourceStack();
            commandManager.performPrefixedCommand(commandSource, String.format("attribute %s minecraft:max_health base set %s", player.getName().getString(), HealthManager.getCurrentPlayerMaxHealth(player) + amount * 2));
        }
    }
}

