/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.j677.adventuresmod.block.entity.GloomyPotBlockEntity;
import net.j677.adventuresmod.component.AdventureDataComponentTypes;
import net.j677.adventuresmod.item.AdventureItems;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class GloomyPotBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<GloomyPotBlock> CODEC = GloomyPotBlock.method_54094(GloomyPotBlock::new);
    public static final class_2960 SHERDS_DYNAMIC_DROP_ID = class_2960.method_60655((String)"adventuresmod", (String)"gloomy_sherds");
    private static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 CRACKED = class_2741.field_43307;
    private static final class_2746 WATERLOGGED = class_2741.field_12508;

    public MapCodec<GloomyPotBlock> method_53969() {
        return CODEC;
    }

    public GloomyPotBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)CRACKED, (Comparable)Boolean.FALSE));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910))).method_11657((class_2769)CRACKED, (Comparable)Boolean.FALSE);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof GloomyPotBlockEntity) {
            GloomyPotBlockEntity decoratedPotBlockEntity = (GloomyPotBlockEntity)class_25862;
            if (world.field_9236) {
                return class_9062.field_47729;
            }
            class_1799 itemStack = decoratedPotBlockEntity.method_54079();
            if (!stack.method_7960() && (itemStack.method_7960() || class_1799.method_31577((class_1799)itemStack, (class_1799)stack) && itemStack.method_7947() < itemStack.method_7914())) {
                float f;
                decoratedPotBlockEntity.wobble(GloomyPotBlockEntity.WobbleType.POSITIVE);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                class_1799 itemStack2 = stack.method_60504(1, (class_1309)player);
                if (decoratedPotBlockEntity.method_5442()) {
                    decoratedPotBlockEntity.method_54077(itemStack2);
                    f = (float)itemStack2.method_7947() / (float)itemStack2.method_7914();
                } else {
                    itemStack.method_7933(1);
                    f = (float)itemStack.method_7947() / (float)itemStack.method_7914();
                }
                world.method_8396(null, pos, class_3417.field_46649, class_3419.field_15245, 1.0f, 0.7f + 0.5f * f);
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    serverWorld.method_14199((class_2394)class_2398.field_46763, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.2, (double)pos.method_10260() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedPotBlockEntity.method_5431();
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                return class_9062.field_47728;
            }
            return class_9062.field_47731;
        }
        return class_9062.field_47732;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof GloomyPotBlockEntity) {
            GloomyPotBlockEntity decoratedPotBlockEntity = (GloomyPotBlockEntity)class_25862;
            world.method_8396(null, pos, class_3417.field_46650, class_3419.field_15245, 1.0f, 1.0f);
            decoratedPotBlockEntity.wobble(GloomyPotBlockEntity.WobbleType.NEGATIVE);
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, CRACKED});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GloomyPotBlockEntity(pos, state);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof GloomyPotBlockEntity) {
            GloomyPotBlockEntity decoratedPotBlockEntity = (GloomyPotBlockEntity)blockEntity;
            builder.method_51872(SHERDS_DYNAMIC_DROP_ID, lootConsumer -> {
                for (class_1792 item : decoratedPotBlockEntity.getSherds().stream()) {
                    lootConsumer.accept(item.method_7854());
                }
            });
        }
        return super.method_9560(state, builder);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_1799 itemStack = player.method_6047();
        class_2680 blockState = state;
        if (itemStack.method_31573(class_3489.field_42617) && !class_1890.method_60138((class_1799)itemStack, (class_6862)class_9636.field_51554)) {
            blockState = (class_2680)state.method_11657((class_2769)CRACKED, (Comparable)Boolean.TRUE);
            world.method_8652(pos, blockState, 4);
        }
        return super.method_9576(world, pos, blockState, player);
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_2498 method_9573(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)CRACKED) != false ? class_2498.field_43256 : class_2498.field_42771;
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        GloomyPotBlockEntity.GloomyPotDecorations sherds = (GloomyPotBlockEntity.GloomyPotDecorations)stack.method_57825(AdventureDataComponentTypes.GLOOMY_POT_DECORATIONS, (Object)GloomyPotBlockEntity.GloomyPotDecorations.DEFAULT);
        if (!sherds.equals(GloomyPotBlockEntity.GloomyPotDecorations.DEFAULT)) {
            tooltip.add(class_5244.field_39003);
            Stream.of(sherds.front(), sherds.left(), sherds.right(), sherds.back()).forEach(sherd -> tooltip.add((class_2561)new class_1799((class_1935)sherd.orElse(AdventureItems.GLOOMY_SHERD), 1).method_7964().method_27662().method_27692(class_124.field_1080)));
        }
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 blockPos = hit.method_17777();
        if (!world.field_9236 && projectile.method_36971(world, blockPos) && projectile.method_54457(world)) {
            world.method_8652(blockPos, (class_2680)state.method_11657((class_2769)CRACKED, (Comparable)Boolean.TRUE), 4);
            world.method_8651(blockPos, true, (class_1297)projectile);
        }
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        class_1799 class_17992;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof GloomyPotBlockEntity) {
            GloomyPotBlockEntity decoratedPotBlockEntity = (GloomyPotBlockEntity)class_25862;
            class_17992 = decoratedPotBlockEntity.asStack();
        } else {
            class_17992 = super.method_9574(world, pos, state);
        }
        return class_17992;
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }
}

