/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.block.custom;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.j677.adventuresmod.AdventurersBeyond;
import net.j677.adventuresmod.particle.AdventureParticles;
import net.j677.adventuresmod.world.dimension.AdventureDimensions;
import net.j677.adventuresmod.world.portal.MythicaPortal;
import net.j677.adventuresmod.world.portal.MythicaPortalForcer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4048;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import net.minecraft.class_5819;
import net.minecraft.class_9797;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MythicaPortalBlock
extends class_2248
implements class_9797 {
    public static final MapCodec<MythicaPortalBlock> CODEC = MythicaPortalBlock.method_54094(MythicaPortalBlock::new);
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final class_265 X_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final class_265 Z_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private MythicaPortalForcer portalForcer;

    public MapCodec<MythicaPortalBlock> method_53969() {
        return CODEC;
    }

    public MythicaPortalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048));
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350.class_2351)state.method_11654(AXIS)) {
            case class_2350.class_2351.field_11051 -> Z_SHAPE;
            default -> X_SHAPE;
        };
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_8597().comp_645() && world.method_8450().method_8355(class_1928.field_19390) && random.method_43048(2000) < world.method_8407().method_5461()) {
            while (world.method_8320(pos).method_27852((class_2248)this)) {
                pos = pos.method_10074();
            }
        }
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2350.class_2351 axis = direction.method_10166();
        class_2350.class_2351 axis2 = (class_2350.class_2351)state.method_11654(AXIS);
        boolean bl = axis2 != axis && axis.method_10179();
        return !bl && !neighborState.method_27852((class_2248)this) && !new MythicaPortal(world, pos, axis2).wasAlreadyValid() ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity.method_5822(false)) {
            entity.method_60697((class_9797)this, pos);
        }
    }

    public int method_60772(class_3218 world, class_1297 entity) {
        int n;
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            n = Math.max(1, world.method_8450().method_8356(playerEntity.method_31549().field_7480 ? class_1928.field_46795 : class_1928.field_46794));
        } else {
            n = 0;
        }
        return n;
    }

    @Nullable
    public class_5454 method_60770(class_3218 world, class_1297 entity, class_2338 pos) {
        class_5321<class_1937> registryKey = world.method_27983() == AdventureDimensions.MYTHICA ? class_1937.field_25179 : AdventureDimensions.MYTHICA;
        class_3218 serverWorld = world.method_8503().method_3847(registryKey);
        if (serverWorld == null) {
            return null;
        }
        class_2784 worldBorder = serverWorld.method_8621();
        double d = class_2874.method_31109((class_2874)world.method_8597(), (class_2874)serverWorld.method_8597());
        class_2338 blockPos = worldBorder.method_39538(entity.method_23317() * d, entity.method_23318(), entity.method_23321() * d);
        return this.getOrCreateExitPortalTarget(serverWorld, entity, pos, blockPos, worldBorder);
    }

    @Nullable
    private class_5454 getOrCreateExitPortalTarget(class_3218 world, class_1297 entity, class_2338 pos, class_2338 scaledPos, class_2784 worldBorder) {
        class_5454.class_9823 postDimensionTransition;
        class_5459.class_5460 rectangle;
        MythicaPortalForcer portalForcer = new MythicaPortalForcer(world);
        Optional<class_2338> optional = portalForcer.getPortalPos(scaledPos, worldBorder);
        if (optional.isPresent()) {
            class_2338 blockPos = optional.get();
            class_2680 blockState = world.method_8320(blockPos);
            rectangle = class_5459.method_30574((class_2338)blockPos, (class_2350.class_2351)((class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529)), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> world.method_8320(posx) == blockState);
            postDimensionTransition = class_5454.field_52246.then(entityx -> entityx.method_60950(blockPos));
        } else {
            class_2350.class_2351 axis = entity.method_37908().method_8320(pos).method_28500(AXIS).orElse(class_2350.class_2351.field_11048);
            Optional<class_5459.class_5460> optional2 = portalForcer.createPortal(scaledPos, axis);
            if (optional2.isEmpty()) {
                AdventurersBeyond.LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            rectangle = optional2.get();
            postDimensionTransition = class_5454.field_52246.then(class_5454.field_52247);
        }
        return MythicaPortalBlock.getExitPortalTarget(entity, pos, rectangle, world, postDimensionTransition);
    }

    private static class_5454 getExitPortalTarget(class_1297 entity, class_2338 pos, class_5459.class_5460 exitPortalRectangle, class_3218 world, class_5454.class_9823 postDimensionTransition) {
        class_243 vec3d;
        class_2350.class_2351 axis;
        class_2680 blockState = entity.method_37908().method_8320(pos);
        if (blockState.method_28498((class_2769)class_2741.field_12529)) {
            axis = (class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529);
            class_5459.class_5460 rectangle = class_5459.method_30574((class_2338)pos, (class_2350.class_2351)axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> entity.method_37908().method_8320(posx) == blockState);
            vec3d = entity.method_30633(axis, rectangle);
        } else {
            axis = class_2350.class_2351.field_11048;
            vec3d = new class_243(0.5, 0.0, 0.0);
        }
        return MythicaPortalBlock.getExitPortalTarget(world, exitPortalRectangle, axis, vec3d, entity, entity.method_18798(), entity.method_36454(), entity.method_36455(), postDimensionTransition);
    }

    private static class_5454 getExitPortalTarget(class_3218 world, class_5459.class_5460 exitPortalRectangle, class_2350.class_2351 axis, class_243 positionInPortal, class_1297 entity, class_243 velocity, float yaw, float pitch, class_5454.class_9823 postDimensionTransition) {
        class_2338 blockPos = exitPortalRectangle.field_25936;
        class_2680 blockState = world.method_8320(blockPos);
        class_2350.class_2351 axis2 = blockState.method_28500((class_2769)class_2741.field_12529).orElse(class_2350.class_2351.field_11048);
        double d = exitPortalRectangle.field_25937;
        double e = exitPortalRectangle.field_25938;
        class_4048 entityDimensions = entity.method_18377(entity.method_18376());
        int i = axis == axis2 ? 0 : 90;
        class_243 vec3d = axis == axis2 ? velocity : new class_243(velocity.field_1350, velocity.field_1351, -velocity.field_1352);
        double f = (double)entityDimensions.comp_2185() / 2.0 + (d - (double)entityDimensions.comp_2185()) * positionInPortal.method_10216();
        double g = (e - (double)entityDimensions.comp_2186()) * positionInPortal.method_10214();
        double h = 0.5 + positionInPortal.method_10215();
        boolean bl = axis2 == class_2350.class_2351.field_11048;
        class_243 vec3d2 = new class_243((double)blockPos.method_10263() + (bl ? f : h), (double)blockPos.method_10264() + g, (double)blockPos.method_10260() + (bl ? h : f));
        class_243 vec3d3 = MythicaPortal.findOpenPosition(vec3d2, world, entity, entityDimensions);
        return new class_5454(world, vec3d3, vec3d, yaw + (float)i, pitch, postDimensionTransition);
    }

    public class_9797.class_9798 method_60778() {
        return class_9797.class_9798.field_52061;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(100) == 0) {
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14802, class_3419.field_15245, 0.5f, random.method_43057() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (double)pos.method_10263() + random.method_43058();
            double e = (double)pos.method_10264() + random.method_43058();
            double f = (double)pos.method_10260() + random.method_43058();
            double g = ((double)random.method_43057() - 0.5) * 0.5;
            double h = ((double)random.method_43057() - 0.5) * 0.5;
            double j = ((double)random.method_43057() - 0.5) * 0.5;
            int k = random.method_43048(2) * 2 - 1;
            if (!world.method_8320(pos.method_10067()).method_27852((class_2248)this) && !world.method_8320(pos.method_10078()).method_27852((class_2248)this)) {
                d = (double)pos.method_10263() + 0.5 + 0.25 * (double)k;
                g = random.method_43057() * 2.0f * (float)k;
            } else {
                f = (double)pos.method_10260() + 0.5 + 0.25 * (double)k;
                j = random.method_43057() * 2.0f * (float)k;
            }
            world.method_8406((class_2394)AdventureParticles.MYTHICA_PORTAL, d, e, f, g, h, j);
        }
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return class_1799.field_8037;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11465, class_2470.field_11463 -> {
                switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                    case field_11051: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
                    }
                    case field_11048: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS});
    }
}

