/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.j677.adventuresmod.block.entity.AdventureBlockEntityTypes;
import net.j677.adventuresmod.block.entity.StoneChestBlockEntity;
import net.j677.adventuresmod.component.AdventureDataComponentTypes;
import net.j677.adventuresmod.item.AdventureItems;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4739;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_8567;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class StoneChestBlock
extends class_4739<StoneChestBlockEntity>
implements class_3737 {
    public static final MapCodec<StoneChestBlock> CODEC = StoneChestBlock.method_54094(StoneChestBlock::new);
    public static final class_2960 SLATES_DYNAMIC_DROP_ID = class_2960.method_60655((String)"adventuresmod", (String)"slates");
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 X_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final class_265 Z_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);

    public MapCodec<StoneChestBlock> method_53969() {
        return CODEC;
    }

    public StoneChestBlock(class_4970.class_2251 settings) {
        super(settings, () -> AdventureBlockEntityTypes.STONE_CHEST);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public class_4732.class_4734<? extends class_2595> method_24167(class_2680 state, class_1937 world, class_2338 pos, boolean ignoreBlocked) {
        return class_4732.class_3923::method_24174;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (StoneChestBlock.getDirection(state)) {
            default -> X_SHAPE;
            case class_2350.field_11039, class_2350.field_11034 -> Z_SHAPE;
        };
    }

    public static class_2350 getDirection(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return direction.method_10153();
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_3908 namedScreenHandlerFactory = this.method_17454(state, world, pos);
        if (namedScreenHandlerFactory != null) {
            player.method_17355(namedScreenHandlerFactory);
            player.method_7259(this.getOpenStat());
            class_4838.method_24733((class_1657)player, (boolean)true);
        }
        return class_1269.field_21466;
    }

    protected class_3445<class_2960> getOpenStat() {
        return class_3468.field_15419.method_14956((Object)class_3468.field_15395);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StoneChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? StoneChestBlock.method_31618(type, AdventureBlockEntityTypes.STONE_CHEST, StoneChestBlockEntity::clientTick) : null;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof StoneChestBlockEntity) {
            ((StoneChestBlockEntity)blockEntity).tick();
        }
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        class_1799 class_17992;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChestBlockEntity = (StoneChestBlockEntity)class_25862;
            class_17992 = stoneChestBlockEntity.asStack();
        } else {
            class_17992 = super.method_9574(world, pos, state);
        }
        return class_17992;
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        StoneChestBlockEntity.StoneChestDecorations slates = (StoneChestBlockEntity.StoneChestDecorations)stack.method_57825(AdventureDataComponentTypes.STONE_CHEST_DECORATIONS, (Object)StoneChestBlockEntity.StoneChestDecorations.DEFAULT);
        if (!slates.equals(StoneChestBlockEntity.StoneChestDecorations.DEFAULT)) {
            tooltip.add(class_5244.field_39003);
            Stream.of(slates.lid(), slates.body()).forEach(slate -> tooltip.add((class_2561)new class_1799((class_1935)slate.orElse(AdventureItems.SILENT_SLATE), 1).method_7964().method_27662().method_27692(class_124.field_1080)));
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_31573(class_3489.field_42617) && !class_1890.method_60138((class_1799)itemStack, (class_6862)class_9636.field_51554)) {
            world.method_8652(pos, state, 4);
        }
        return super.method_9576(world, pos, state, player);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChestBlockEntity = (StoneChestBlockEntity)blockEntity;
            builder.method_51872(SLATES_DYNAMIC_DROP_ID, lootConsumer -> {
                for (class_1792 item : stoneChestBlockEntity.getSlates().stream()) {
                    lootConsumer.accept(item.method_7854());
                }
            });
        }
        return super.method_9560(state, builder);
    }
}

