/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.block.custom;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.j677.adventuresmod.block.AdventureBlocks;
import net.minecraft.class_10;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class TourmalineCrystalBlock
extends class_2248
implements class_5688,
class_3737 {
    public static final MapCodec<TourmalineCrystalBlock> CODEC = TourmalineCrystalBlock.method_54094(TourmalineCrystalBlock::new);
    public static final class_2753 VERTICAL_DIRECTION = class_2741.field_28062;
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 UP_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 DOWN_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public MapCodec<TourmalineCrystalBlock> method_53969() {
        return CODEC;
    }

    public TourmalineCrystalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)class_5691.field_28065)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{VERTICAL_DIRECTION, THICKNESS, WATERLOGGED});
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return TourmalineCrystalBlock.canPlaceAtWithDirection(world, pos, (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return state;
        }
        class_2350 direction2 = (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION);
        if (direction2 == class_2350.field_11033 && world.method_8397().method_8674(pos, (Object)this)) {
            return state;
        }
        if (direction == direction2.method_10153() && !this.method_9558(state, (class_4538)world, pos)) {
            if (direction2 == class_2350.field_11033) {
                world.method_39279(pos, (class_2248)this, 2);
            } else {
                world.method_39279(pos, (class_2248)this, 1);
            }
            return state;
        }
        boolean bl = state.method_11654(THICKNESS) == class_5691.field_28064;
        class_5691 thickness = TourmalineCrystalBlock.getThickness((class_4538)world, pos, direction2, bl);
        return (class_2680)state.method_11657(THICKNESS, (Comparable)thickness);
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 blockPos;
        if (!world.field_9236 && projectile.method_36971(world, blockPos = hit.method_17777()) && projectile.method_54457(world) && projectile instanceof class_1665 && projectile.method_18798().method_1033() > 0.6) {
            world.method_22352(blockPos, true);
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (state.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11036 && state.method_11654(THICKNESS) == class_5691.field_28065) {
            entity.method_5747(fallDistance + 2.0f, 2.0f, world.method_48963().method_48837());
        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (TourmalineCrystalBlock.isPointingUp(state) && !this.method_9558(state, (class_4538)world, pos)) {
            world.method_22352(pos, true);
        } else {
            TourmalineCrystalBlock.spawnFallingBlock(state, world, pos);
        }
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (random.method_43057() < 0.075f && TourmalineCrystalBlock.isHeldByTourmaline(state, (class_4538)world, pos) || random.method_43057() < 0.075f && TourmalineCrystalBlock.isPointingUp(state)) {
            TourmalineCrystalBlock.tryGrow(state, world, pos, random);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction;
        class_2338 blockPos;
        class_1937 worldAccess = ctx.method_8045();
        class_2350 direction2 = TourmalineCrystalBlock.getDirectionToPlaceAt((class_4538)worldAccess, blockPos = ctx.method_8037(), direction = ctx.method_32760().method_10153());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !ctx.method_8046();
        class_5691 thickness = TourmalineCrystalBlock.getThickness((class_4538)worldAccess, blockPos, direction2, bl);
        return thickness == null ? null : (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)direction2)).method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_5691 thickness = (class_5691)state.method_11654(THICKNESS);
        class_265 voxelShape = thickness == class_5691.field_28064 ? TIP_MERGE_SHAPE : (thickness == class_5691.field_28065 ? (state.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11033 ? DOWN_TIP_SHAPE : UP_TIP_SHAPE) : (thickness == class_5691.field_28066 ? BASE_SHAPE : (thickness == class_5691.field_28067 ? FRUSTUM_SHAPE : MIDDLE_SHAPE)));
        class_243 vec3d = state.method_26226(world, pos);
        return voxelShape.method_1096(vec3d.field_1352, 0.0, vec3d.field_1350);
    }

    protected boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    protected float method_32913() {
        return 0.125f;
    }

    public void method_10129(class_1937 world, class_2338 pos, class_1540 fallingBlockEntity) {
        if (!fallingBlockEntity.method_5701()) {
            world.method_20290(1045, pos, 0);
        }
    }

    public class_1282 method_32898(class_1297 attacker) {
        return attacker.method_48923().method_48814(attacker);
    }

    private static void spawnFallingBlock(class_2680 state, class_3218 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        class_2680 blockState = state;
        while (TourmalineCrystalBlock.isPointingDown(blockState)) {
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)world, (class_2338)mutable, (class_2680)blockState);
            if (TourmalineCrystalBlock.isTip(blockState, true)) {
                int i = Math.max(1 + pos.method_10264() - mutable.method_10264(), 6);
                float f = i;
                fallingBlockEntity.method_6965(f, 40);
                break;
            }
            mutable.method_10098(class_2350.field_11033);
            blockState = world.method_8320((class_2338)mutable);
        }
    }

    @VisibleForTesting
    public static void tryGrow(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2680 blockState3;
        class_2338 blockPos;
        class_2680 blockState = world.method_8320(pos.method_10086(1));
        class_2680 blockState2 = world.method_8320(pos.method_10087(1));
        if ((TourmalineCrystalBlock.canGrow(blockState) || TourmalineCrystalBlock.canGrow(blockState2)) && (blockPos = TourmalineCrystalBlock.getTipPos(state, (class_1936)world, pos, 5, false)) != null && TourmalineCrystalBlock.canGrow(blockState3 = world.method_8320(blockPos), world, blockPos)) {
            if (TourmalineCrystalBlock.isCrystalFacingDirection(state, class_2350.field_11033)) {
                TourmalineCrystalBlock.tryGrow(world, blockPos, class_2350.field_11033);
            } else {
                TourmalineCrystalBlock.tryGrow(world, blockPos, class_2350.field_11036);
            }
        }
    }

    private static void tryGrow(class_3218 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (TourmalineCrystalBlock.isTip(blockState, direction.method_10153())) {
            TourmalineCrystalBlock.growMerged(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_26215() || blockState.method_27852(class_2246.field_10382)) {
            TourmalineCrystalBlock.place((class_1936)world, blockPos, direction, class_5691.field_28065);
        }
    }

    private static void place(class_1936 world, class_2338 pos, class_2350 direction, class_5691 thickness) {
        class_2680 blockState = (class_2680)((class_2680)((class_2680)AdventureBlocks.TOURMALINE_CRYSTAL.method_9564().method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)direction)).method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910));
        world.method_8652(pos, blockState, 3);
    }

    private static void growMerged(class_2680 state, class_1936 world, class_2338 pos) {
        class_2338 blockPos2;
        class_2338 blockPos;
        if (state.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11036) {
            blockPos = pos;
            blockPos2 = pos.method_10084();
        } else {
            blockPos2 = pos;
            blockPos = pos.method_10074();
        }
        TourmalineCrystalBlock.place(world, blockPos2, class_2350.field_11033, class_5691.field_28064);
        TourmalineCrystalBlock.place(world, blockPos, class_2350.field_11036, class_5691.field_28064);
    }

    @Nullable
    private static class_2338 getTipPos(class_2680 state, class_1936 world, class_2338 pos, int range, boolean allowMerged) {
        if (TourmalineCrystalBlock.isTip(state, allowMerged)) {
            return pos;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION);
        BiPredicate<class_2338, class_2680> biPredicate = (posx, statex) -> statex.method_27852(AdventureBlocks.TOURMALINE_CRYSTAL) && statex.method_11654((class_2769)VERTICAL_DIRECTION) == direction;
        return TourmalineCrystalBlock.searchInDirection(world, pos, direction.method_10171(), biPredicate, statex -> TourmalineCrystalBlock.isTip(statex, allowMerged), range).orElse(null);
    }

    @Nullable
    private static class_2350 getDirectionToPlaceAt(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2350 direction2;
        if (TourmalineCrystalBlock.canPlaceAtWithDirection(world, pos, direction)) {
            direction2 = direction;
        } else {
            if (!TourmalineCrystalBlock.canPlaceAtWithDirection(world, pos, direction.method_10153())) {
                return null;
            }
            direction2 = direction.method_10153();
        }
        return direction2;
    }

    private static class_5691 getThickness(class_4538 world, class_2338 pos, class_2350 direction, boolean tryMerge) {
        class_2350 direction2 = direction.method_10153();
        class_2680 blockState = world.method_8320(pos.method_10093(direction));
        if (TourmalineCrystalBlock.isCrystalFacingDirection(blockState, direction2)) {
            return !tryMerge && blockState.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!TourmalineCrystalBlock.isCrystalFacingDirection(blockState, direction)) {
            return class_5691.field_28065;
        }
        class_5691 thickness = (class_5691)blockState.method_11654(THICKNESS);
        if (thickness != class_5691.field_28065 && thickness != class_5691.field_28064) {
            class_2680 blockState2 = world.method_8320(pos.method_10093(direction2));
            return !TourmalineCrystalBlock.isCrystalFacingDirection(blockState2, direction) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    private static boolean canGrow(class_2680 state, class_3218 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION);
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (!blockState.method_26227().method_15769()) {
            return false;
        }
        return blockState.method_26215() || TourmalineCrystalBlock.isTip(blockState, direction.method_10153());
    }

    private static boolean canPlaceAtWithDirection(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, direction) || TourmalineCrystalBlock.isCrystalFacingDirection(blockState, direction);
    }

    private static boolean isTip(class_2680 state, boolean allowMerged) {
        if (!state.method_27852(AdventureBlocks.TOURMALINE_CRYSTAL)) {
            return false;
        }
        class_5691 thickness = (class_5691)state.method_11654(THICKNESS);
        return thickness == class_5691.field_28065 || allowMerged && thickness == class_5691.field_28064;
    }

    private static boolean isTip(class_2680 state, class_2350 direction) {
        return TourmalineCrystalBlock.isTip(state, false) && state.method_11654((class_2769)VERTICAL_DIRECTION) == direction;
    }

    private static boolean isPointingDown(class_2680 state) {
        return TourmalineCrystalBlock.isCrystalFacingDirection(state, class_2350.field_11033);
    }

    private static boolean isPointingUp(class_2680 state) {
        return TourmalineCrystalBlock.isCrystalFacingDirection(state, class_2350.field_11036);
    }

    private static boolean isHeldByTourmaline(class_2680 state, class_4538 world, class_2338 pos) {
        return TourmalineCrystalBlock.isPointingDown(state) && !world.method_8320(pos.method_10084()).method_27852(AdventureBlocks.TOURMALINE_CRYSTAL);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    private static boolean isCrystalFacingDirection(class_2680 state, class_2350 direction) {
        return state.method_27852(AdventureBlocks.TOURMALINE_CRYSTAL) && state.method_11654((class_2769)VERTICAL_DIRECTION) == direction;
    }

    private static boolean canGrow(class_2680 buddingTourmaline) {
        return buddingTourmaline.method_27852(AdventureBlocks.BUDDING_TOURMALINE);
    }

    private static Optional<class_2338> searchInDirection(class_1936 world, class_2338 pos, class_2350.class_2352 direction, BiPredicate<class_2338, class_2680> continuePredicate, Predicate<class_2680> stopPredicate, int range) {
        class_2350 direction2 = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 1; i < range; ++i) {
            mutable.method_10098(direction2);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.method_10062());
            }
            if (!world.method_31601(mutable.method_10264()) && continuePredicate.test((class_2338)mutable, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

