/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.block.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.j677.adventuresmod.block.entity.AdventureBlockEntityTypes;
import net.j677.adventuresmod.component.AdventureDataComponentTypes;
import net.j677.adventuresmod.item.AdventureItems;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8181;
import net.minecraft.class_8934;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class GloomyPotBlockEntity
extends class_2586
implements class_8934,
class_8181.class_9210 {
    public long lastWobbleTime;
    @Nullable
    public WobbleType lastWobbleType;
    private GloomyPotDecorations sherds;
    private class_1799 stack = class_1799.field_8037;
    @Nullable
    protected class_5321<class_52> lootTableId;
    protected long lootTableSeed;

    public GloomyPotBlockEntity(class_2338 pos, class_2680 state) {
        super(AdventureBlockEntityTypes.GLOOMY_POT, pos, state);
        this.sherds = GloomyPotDecorations.DEFAULT;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.sherds.toNbt(nbt);
        if (!this.method_54872(nbt) && !this.stack.method_7960()) {
            nbt.method_10566("item", this.stack.method_57358(registryLookup));
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.sherds = GloomyPotDecorations.fromNbt(nbt);
        if (!this.method_54871(nbt)) {
            this.stack = nbt.method_10573("item", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("item")).orElse(class_1799.field_8037) : class_1799.field_8037;
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public class_2350 getHorizontalFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    public GloomyPotDecorations getSherds() {
        return this.sherds;
    }

    public void readFrom(class_1799 stack) {
        this.method_58683(stack);
    }

    public class_1799 asStack() {
        class_1799 itemStack = AdventureItems.GLOOMY_POT.method_7854();
        itemStack.method_57365(this.method_57590());
        return itemStack;
    }

    public static class_1799 getStackWith(GloomyPotDecorations sherds) {
        class_1799 itemStack = AdventureItems.GLOOMY_POT.method_7854();
        itemStack.method_57379(AdventureDataComponentTypes.GLOOMY_POT_DECORATIONS, (Object)sherds);
        return itemStack;
    }

    @Nullable
    public class_5321<class_52> method_54869() {
        return this.lootTableId;
    }

    public void method_11285(@Nullable class_5321<class_52> lootTable) {
        this.lootTableId = lootTable;
    }

    public long method_54870() {
        return this.lootTableSeed;
    }

    public void method_54866(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(AdventureDataComponentTypes.GLOOMY_POT_DECORATIONS, (Object)this.sherds);
        componentMapBuilder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493(List.of(this.stack)));
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        this.sherds = (GloomyPotDecorations)components.method_58695(AdventureDataComponentTypes.GLOOMY_POT_DECORATIONS, (Object)GloomyPotDecorations.DEFAULT);
        this.stack = ((class_9288)components.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_58114();
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("gloomy_sherds");
        nbt.method_10551("item");
    }

    public class_1799 method_54079() {
        this.method_54873(null);
        return this.stack;
    }

    public class_1799 method_54078(int count) {
        this.method_54873(null);
        class_1799 itemStack = this.stack.method_7971(count);
        if (this.stack.method_7960()) {
            this.stack = class_1799.field_8037;
        }
        return itemStack;
    }

    public void method_54077(class_1799 stack) {
        this.method_54873(null);
        this.stack = stack;
    }

    public class_2586 method_54080() {
        return this;
    }

    public void wobble(WobbleType wobbleType) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 1, wobbleType.ordinal());
        }
    }

    public boolean method_11004(int type, int data) {
        if (this.field_11863 != null && type == 1 && data >= 0 && data < WobbleType.values().length) {
            this.lastWobbleTime = this.field_11863.method_8510();
            this.lastWobbleType = WobbleType.values()[data];
            return true;
        }
        return super.method_11004(type, data);
    }

    public record GloomyPotDecorations(Optional<class_1792> back, Optional<class_1792> left, Optional<class_1792> right, Optional<class_1792> front) {
        public static final GloomyPotDecorations DEFAULT = new GloomyPotDecorations(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        public static final Codec<GloomyPotDecorations> CODEC = class_7923.field_41178.method_39673().sizeLimitedListOf(4).xmap(GloomyPotDecorations::new, GloomyPotDecorations::stream);
        public static final class_9139<class_9129, GloomyPotDecorations> PACKET_CODEC = class_9135.method_56365((class_5321)class_7924.field_41197).method_56433(class_9135.method_58000((int)4)).method_56432(GloomyPotDecorations::new, GloomyPotDecorations::stream);

        private GloomyPotDecorations(List<class_1792> siltSherds) {
            this(GloomyPotDecorations.getSherd(siltSherds, 0), GloomyPotDecorations.getSherd(siltSherds, 1), GloomyPotDecorations.getSherd(siltSherds, 2), GloomyPotDecorations.getSherd(siltSherds, 3));
        }

        public GloomyPotDecorations(class_1792 back, class_1792 left, class_1792 right, class_1792 front) {
            this(List.of(back, left, right, front));
        }

        private static Optional<class_1792> getSherd(List<class_1792> sherds, int index) {
            if (index >= sherds.size()) {
                return Optional.empty();
            }
            class_1792 item = sherds.get(index);
            return item == AdventureItems.GLOOMY_SHERD ? Optional.empty() : Optional.of(item);
        }

        public void toNbt(class_2487 nbt) {
            if (!this.equals(DEFAULT)) {
                nbt.method_10566("gloomy_sherds", (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow());
            }
        }

        public List<class_1792> stream() {
            return Stream.of(this.back, this.left, this.right, this.front).map(item -> item.orElse(AdventureItems.GLOOMY_SHERD)).toList();
        }

        public static GloomyPotDecorations fromNbt(@Nullable class_2487 nbt) {
            return nbt != null && nbt.method_10545("gloomy_sherds") ? CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("gloomy_sherds")).result().orElse(DEFAULT) : DEFAULT;
        }
    }

    public static enum WobbleType {
        POSITIVE(7),
        NEGATIVE(10);

        public final int lengthInTicks;

        private WobbleType(int lengthInTicks) {
            this.lengthInTicks = lengthInTicks;
        }
    }
}

