/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.block.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.j677.adventuresmod.block.entity.AdventureBlockEntityTypes;
import net.j677.adventuresmod.component.AdventureDataComponentTypes;
import net.j677.adventuresmod.item.AdventureItems;
import net.minecraft.class_1258;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2618;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5560;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class StoneChestBlockEntity
extends class_2621
implements class_2618 {
    private StoneChestDecorations slates;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private final class_5561 stateManager = new class_5561(){

        protected void method_31681(class_1937 world, class_2338 pos, class_2680 state) {
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14952, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
        }

        protected void method_31683(class_1937 world, class_2338 pos, class_2680 state) {
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15206, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
        }

        protected void method_31682(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
            StoneChestBlockEntity.this.onViewerCountUpdate(world, pos, state, oldViewerCount, newViewerCount);
        }

        protected boolean method_31679(class_1657 player) {
            if (!(player.field_7512 instanceof class_1707)) {
                return false;
            }
            class_1263 inventory = ((class_1707)player.field_7512).method_7629();
            return inventory == StoneChestBlockEntity.this || inventory instanceof class_1258 && ((class_1258)inventory).method_5405((class_1263)StoneChestBlockEntity.this);
        }
    };
    private final class_5560 lidAnimator = new class_5560();

    public StoneChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(AdventureBlockEntityTypes.STONE_CHEST, blockPos, blockState);
        this.slates = StoneChestDecorations.DEFAULT;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        }
        this.slates = StoneChestDecorations.fromNbt(nbt);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (!this.method_54872(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        }
        this.slates.toNbt(nbt);
    }

    public int method_5439() {
        return 27;
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    public float method_11274(float tickDelta) {
        return this.lidAnimator.method_31673(tickDelta);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.adventuresmod.stonechest");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return class_1707.method_19245((int)syncId, (class_1661)playerInventory, (class_1263)this);
    }

    protected void onViewerCountUpdate(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        class_2248 block = state.method_26204();
        world.method_8427(pos, block, 1, newViewerCount);
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.stateManager.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.stateManager.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void tick() {
        if (!this.field_11865) {
            this.stateManager.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, StoneChestBlockEntity blockEntity) {
        blockEntity.lidAnimator.method_31672();
    }

    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.lidAnimator.method_31674(data > 0);
            return true;
        }
        return super.method_11004(type, data);
    }

    public StoneChestDecorations getSlates() {
        return this.slates;
    }

    public void readFrom(class_1799 stack) {
        this.method_58683(stack);
    }

    public class_1799 asStack() {
        class_1799 itemStack = AdventureItems.STONE_CHEST.method_7854();
        itemStack.method_57365(this.method_57590());
        return itemStack;
    }

    public static class_1799 getStackWith(StoneChestDecorations slates) {
        class_1799 itemstack = AdventureItems.STONE_CHEST.method_7854();
        itemstack.method_57379(AdventureDataComponentTypes.STONE_CHEST_DECORATIONS, (Object)slates);
        return itemstack;
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(AdventureDataComponentTypes.STONE_CHEST_DECORATIONS, (Object)this.slates);
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        this.slates = (StoneChestDecorations)components.method_58695(AdventureDataComponentTypes.STONE_CHEST_DECORATIONS, (Object)StoneChestDecorations.DEFAULT);
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("slates");
    }

    public record StoneChestDecorations(Optional<class_1792> lid, Optional<class_1792> body) {
        public static final StoneChestDecorations DEFAULT = new StoneChestDecorations(Optional.empty(), Optional.empty());
        public static final Codec<StoneChestDecorations> CODEC = class_7923.field_41178.method_39673().sizeLimitedListOf(2).xmap(StoneChestDecorations::new, StoneChestDecorations::stream);
        public static final class_9139<class_9129, StoneChestDecorations> PACKET_CODEC = class_9135.method_56365((class_5321)class_7924.field_41197).method_56433(class_9135.method_58000((int)2)).method_56432(StoneChestDecorations::new, StoneChestDecorations::stream);

        private StoneChestDecorations(List<class_1792> slates) {
            this(StoneChestDecorations.getSlate(slates, 0), StoneChestDecorations.getSlate(slates, 1));
        }

        public StoneChestDecorations(class_1792 lid, class_1792 body) {
            this(List.of(lid, body));
        }

        private static Optional<class_1792> getSlate(List<class_1792> slates, int index) {
            if (index >= slates.size()) {
                return Optional.empty();
            }
            class_1792 item = slates.get(index);
            return item == AdventureItems.SILENT_SLATE ? Optional.empty() : Optional.of(item);
        }

        public void toNbt(class_2487 nbt) {
            if (!this.equals(DEFAULT)) {
                nbt.method_10566("slates", (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow());
            }
        }

        public List<class_1792> stream() {
            return Stream.of(this.lid, this.body).map(item -> item.orElse(AdventureItems.SILENT_SLATE)).toList();
        }

        public static StoneChestDecorations fromNbt(@Nullable class_2487 nbt) {
            return nbt != null && nbt.method_10545("slates") ? CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("slates")).result().orElse(DEFAULT) : DEFAULT;
        }
    }
}

