/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.config;

import com.mojang.datafixers.util.Pair;
import net.j677.adventuresmod.config.ConfigProvider;
import net.j677.adventuresmod.config.SimpleConfig;

public class AdventurersBeyondConfig {
    public static SimpleConfig CONFIG;
    private static ConfigProvider configs;
    public static float REKINDLED_MAX_HEALTH;
    public static float SCORCH_ATTACK_FIRE_DAMAGE;
    public static float SCORCH_ATTACK_DEBRIS_DAMAGE;
    public static float ERUPTION_FIRE_DAMAGE;
    public static float ERUPTION_DEBRIS_DAMAGE;
    public static float MORTAR_DAMAGE;
    public static float DROWNED_CONJURER_MAX_HEALTH;
    public static float NECROMANCER_SPELL_DAMAGE;
    public static float RUNESTONE_GOLEM_MAX_HEALTH;
    public static float RUNESTONE_GOLEM_ATTACK_DAMAGE;
    public static float RUNESTONE_CRYSTAL_DAMAGE;
    public static float RUNESTONE_CORE_DAMAGE;
    public static float RUNESTONE_SHARD_DAMAGE;

    public static void registerConfigs() {
        configs = new ConfigProvider();
        AdventurersBeyondConfig.createConfigs();
        CONFIG = SimpleConfig.of("adventurers-beyond-config").provider(configs).request();
        AdventurersBeyondConfig.assignConfigs();
    }

    public static void createConfigs() {
        configs.addComment("[Rekindled Boss]");
        configs.addConfig(new Pair((Object)"rekindled_max_health", (Object)"600"), "Rekindled's Max Health");
        configs.addConfig(new Pair((Object)"scorch_attack_fire_damage", (Object)"20"), "Fire damage dealt from Rekindled's Scorch Attack");
        configs.addConfig(new Pair((Object)"scorch_attack_debris_damage", (Object)"10"), "Debris damage dealt from Rekindled's Scorch Attack");
        configs.addConfig(new Pair((Object)"eruption_fire_damage", (Object)"10"), "Fire damage dealt from Eruptions");
        configs.addConfig(new Pair((Object)"eruption_debris_damage", (Object)"5"), "Debris damage dealt from Eruptions");
        configs.addConfig(new Pair((Object)"mortar_damage", (Object)"7"), "Damage dealt from Rekindled's Mortars");
        configs.newLine();
        configs.addComment("[Drowned Conjurer Boss]");
        configs.addConfig(new Pair((Object)"drowned_conjurer_max_health", (Object)"400"), "Drowned Conjurer's Max Health");
        configs.addConfig(new Pair((Object)"necromancer_spell_damage", (Object)"3"), "Damage dealt from Drowned Conjurer's Spells");
        configs.newLine();
        configs.addComment("[Runestone Golem Boss]");
        configs.addConfig(new Pair((Object)"runestone_golem_max_health", (Object)"400"), "Runestone Golem's Max Health");
        configs.addConfig(new Pair((Object)"runestone_golem_attack_damage", (Object)"15"), "Runestone Golem Attack Damage");
        configs.addConfig(new Pair((Object)"runestone_crystal_damage", (Object)"6"), "Damage dealt from Runestone Crystals");
        configs.addConfig(new Pair((Object)"runestone_core_damage", (Object)"5"), "Damage dealt from Runestone Cores");
        configs.addConfig(new Pair((Object)"runestone_shard_damage", (Object)"3"), "Damage dealt from Runestone Shards");
    }

    private static void assignConfigs() {
        REKINDLED_MAX_HEALTH = CONFIG.getOrDefault("rekindled_max_health", 600);
        SCORCH_ATTACK_FIRE_DAMAGE = CONFIG.getOrDefault("scorch_attack_fire_damage", 20);
        SCORCH_ATTACK_DEBRIS_DAMAGE = CONFIG.getOrDefault("scorch_attack_debris_damage", 10);
        ERUPTION_FIRE_DAMAGE = CONFIG.getOrDefault("eruption_fire_damage", 10);
        ERUPTION_DEBRIS_DAMAGE = CONFIG.getOrDefault("eruption_debris_damage", 5);
        MORTAR_DAMAGE = CONFIG.getOrDefault("mortar_damage", 7);
        DROWNED_CONJURER_MAX_HEALTH = CONFIG.getOrDefault("drowned_conjurer_max_health", 400);
        NECROMANCER_SPELL_DAMAGE = CONFIG.getOrDefault("necromancer_spell_damage", 3);
        RUNESTONE_GOLEM_MAX_HEALTH = CONFIG.getOrDefault("runestone_golem_max_health", 400);
        RUNESTONE_GOLEM_ATTACK_DAMAGE = CONFIG.getOrDefault("runestone_golem_attack_damage", 15);
        RUNESTONE_CRYSTAL_DAMAGE = CONFIG.getOrDefault("runestone_crystal_damage", 6);
        RUNESTONE_CORE_DAMAGE = CONFIG.getOrDefault("runestone_core_damage", 5);
        RUNESTONE_SHARD_DAMAGE = CONFIG.getOrDefault("runestone_shard_damage", 3);
        System.out.println("All " + configs.getConfigList().size() + " have been set properly");
    }
}

