/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.AdventureSensorTypes;
import net.j677.adventuresmod.entity.brain.BoreBurrowTowardsTargetTask;
import net.j677.adventuresmod.entity.brain.BoreShootIfStuckTask;
import net.j677.adventuresmod.entity.brain.BoreShootTask;
import net.j677.adventuresmod.entity.brain.BoreSlideTowardsTargetTask;
import net.j677.adventuresmod.entity.custom.BoreEntity;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4818;
import net.minecraft.class_4824;
import net.minecraft.class_4828;

public class BoreBrain {
    public static final List<class_4149<? extends class_4148<? super BoreEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, (Object)class_4149.field_18467, AdventureSensorTypes.BORE_ATTACK_ENTITY_SENSOR);
    public static final List<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_30243, (Object)class_4140.field_19293, (Object)class_4140.field_22355, (Object)class_4140.field_18445, AdventureMemoryModuleTypes.BORE_SHOOT, AdventureMemoryModuleTypes.BORE_SHOOT_CHARGING, AdventureMemoryModuleTypes.BORE_SHOOT_RECOVER, AdventureMemoryModuleTypes.BORE_SHOOT_COOLDOWN, AdventureMemoryModuleTypes.BORE_BURROW_COOLDOWN, AdventureMemoryModuleTypes.BORE_BURROW_DIGGING, (Object[])new class_4140[]{AdventureMemoryModuleTypes.BORE_BURROW_TARGET, AdventureMemoryModuleTypes.BORE_LEAVING_WATER, class_4140.field_18451, class_4140.field_18452, class_4140.field_18449});

    public static class_4095<?> create(BoreEntity boreEntity, class_4095<BoreEntity> brain) {
        BoreBrain.addCoreTasks(brain);
        BoreBrain.addIdleTasks(brain);
        BoreBrain.addFightTasks(boreEntity, brain);
        brain.method_18890(Set.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_22396);
        brain.method_24536();
        return brain;
    }

    private static void addCoreTasks(class_4095<BoreEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90)));
    }

    private static void addIdleTasks(class_4095<BoreEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4824.method_47119(bore -> bore.method_18868().method_18904(class_4140.field_30243))), (Object)Pair.of((Object)1, (Object)class_4824.method_47119(BoreEntity::getHurtBy)), (Object)Pair.of((Object)2, (Object)((Object)new SlideAroundTask(20, 40))), (Object)Pair.of((Object)3, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)new class_4101(20, 100), (Object)1), (Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2))))));
    }

    private static void addFightTasks(BoreEntity bore, class_4095<BoreEntity> brain) {
        brain.method_24529(class_4168.field_22396, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4828.method_47138(livingEntity -> !class_4148.method_36982((class_1309)bore, (class_1309)livingEntity))), (Object)Pair.of((Object)1, (Object)((Object)new BoreShootTask())), (Object)Pair.of((Object)2, (Object)((Object)new BoreBurrowTowardsTargetTask())), (Object)Pair.of((Object)3, (Object)((Object)new BoreShootIfStuckTask())), (Object)Pair.of((Object)4, (Object)((Object)new BoreSlideTowardsTargetTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_18445, (Object)class_4141.field_18457)));
    }

    public static void updateActivities(BoreEntity bore) {
        bore.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
    }

    public static class SlideAroundTask
    extends class_4112 {
        @VisibleForTesting
        public SlideAroundTask(int i, int j) {
            super(i, j);
        }

        protected void method_18982(class_3218 serverWorld, class_1308 mobEntity, long l) {
            super.method_18982(serverWorld, mobEntity, l);
            mobEntity.method_18380(class_4050.field_47246);
        }

        protected void method_18981(class_3218 serverWorld, class_1308 mobEntity, long l) {
            super.method_18981(serverWorld, mobEntity, l);
            mobEntity.method_18380(class_4050.field_18076);
            if (mobEntity.method_18868().method_18896(class_4140.field_22355)) {
                mobEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_SHOOT, (Object)class_3902.field_17274, 60L);
            }
        }
    }
}

