/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.BoreMovementUtil;
import net.j677.adventuresmod.entity.custom.BoreEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4097;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class BoreBurrowTowardsTargetTask
extends class_4097<BoreEntity> {
    private static final int BURROW_INHALING_EXPIRY = Math.round(5.0f);

    public BoreBurrowTowardsTargetTask() {
        super(Map.of(class_4140.field_22355, class_4141.field_18456, AdventureMemoryModuleTypes.BORE_BURROW_COOLDOWN, class_4141.field_18457, AdventureMemoryModuleTypes.BORE_BURROW_DIGGING, class_4141.field_18458, AdventureMemoryModuleTypes.BORE_BURROW_TARGET, class_4141.field_18458, AdventureMemoryModuleTypes.BORE_SHOOT, class_4141.field_18457, class_4140.field_18445, class_4141.field_18457, AdventureMemoryModuleTypes.BORE_LEAVING_WATER, class_4141.field_18458), 20);
    }

    public static boolean shouldBurrow(class_3218 world, BoreEntity bore) {
        if (!bore.method_24828() && !bore.method_5799()) {
            return false;
        }
        if (class_4125.method_55700((class_1308)bore)) {
            return false;
        }
        if (bore.method_18868().method_18876(AdventureMemoryModuleTypes.BORE_BURROW_TARGET, class_4141.field_18456)) {
            return true;
        }
        class_1309 livingEntity = bore.method_18868().method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity == null) {
            return false;
        }
        if (BoreBurrowTowardsTargetTask.isTargetOutOfRange(bore, livingEntity)) {
            bore.method_18868().method_18875(class_4140.field_22355);
            return false;
        }
        if (BoreBurrowTowardsTargetTask.isTargetTooClose(bore, livingEntity)) {
            return false;
        }
        class_2338 blockPos = class_2338.method_49638((class_2374)BoreMovementUtil.getRandomPosBehindTarget(livingEntity, bore.method_59922()));
        class_2680 blockState = world.method_8320(blockPos.method_10074());
        if (bore.method_5864().method_29496(blockState)) {
            return false;
        }
        bore.method_18868().method_18878(AdventureMemoryModuleTypes.BORE_BURROW_TARGET, (Object)blockPos);
        return true;
    }

    protected boolean shouldRun(class_3218 serverWorld, BoreEntity boreEntity) {
        return BoreBurrowTowardsTargetTask.shouldBurrow(serverWorld, boreEntity);
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        return boreEntity.method_18376() != class_4050.field_18076 && !boreEntity.method_18868().method_18896(AdventureMemoryModuleTypes.BORE_BURROW_COOLDOWN);
    }

    protected void run(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        if (boreEntity.method_18868().method_18876(AdventureMemoryModuleTypes.BORE_BURROW_DIGGING, class_4141.field_18457)) {
            boreEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_BURROW_DIGGING, (Object)class_3902.field_17274, (long)BURROW_INHALING_EXPIRY);
        }
        boreEntity.method_18380(class_4050.field_38100);
        serverWorld.method_43129(null, (class_1297)boreEntity, class_3417.field_47724, class_3419.field_15251, 1.0f, 1.0f);
        boreEntity.method_18868().method_18904(AdventureMemoryModuleTypes.BORE_BURROW_TARGET).ifPresent(burrowTarget -> boreEntity.method_5702(class_2183.class_2184.field_9851, burrowTarget.method_46558()));
    }

    protected void keepRunning(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        boolean bl = boreEntity.method_5799();
        if (!bl && boreEntity.method_18868().method_18876(AdventureMemoryModuleTypes.BORE_LEAVING_WATER, class_4141.field_18456)) {
            boreEntity.method_18868().method_18875(AdventureMemoryModuleTypes.BORE_LEAVING_WATER);
        }
        if (BoreBurrowTowardsTargetTask.shouldStopDiggingPose(boreEntity)) {
            class_2338 burrowPos = boreEntity.method_18868().method_18904(AdventureMemoryModuleTypes.BORE_BURROW_TARGET).orElse(null);
            if (burrowPos == null) {
                boreEntity.method_18380(class_4050.field_18076);
                return;
            }
            if (bl) {
                boreEntity.method_18868().method_18878(AdventureMemoryModuleTypes.BORE_LEAVING_WATER, (Object)class_3902.field_17274);
            }
            boreEntity.method_5783(class_3417.field_47196, 1.0f, 1.0f);
            boreEntity.method_18380(class_4050.field_38099);
            boreEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(livingEntity -> this.burrowTo(boreEntity, (class_1937)serverWorld, burrowPos.method_10263(), burrowPos.method_10264(), burrowPos.method_10260()));
        } else if (BoreBurrowTowardsTargetTask.shouldStopEmergingPose(boreEntity)) {
            boreEntity.method_5783(class_3417.field_47197, 1.0f, 1.0f);
            boreEntity.method_18380(class_4050.field_18076);
            boolean bl2 = boreEntity.method_18868().method_18896(class_4140.field_18451);
            boreEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_BURROW_COOLDOWN, (Object)class_3902.field_17274, bl2 ? 2L : 10L);
            boreEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_SHOOT, (Object)class_3902.field_17274, 100L);
        }
    }

    protected void finishRunning(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        if (boreEntity.method_18376() == class_4050.field_38099 || boreEntity.method_18376() == class_4050.field_38100) {
            boreEntity.method_18380(class_4050.field_18076);
        }
        boolean bl2 = boreEntity.method_18868().method_18896(class_4140.field_18451);
        boreEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_BURROW_COOLDOWN, (Object)class_3902.field_17274, bl2 ? 2L : 10L);
        boreEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_SHOOT, (Object)class_3902.field_17274, 100L);
        boreEntity.method_18868().method_18875(AdventureMemoryModuleTypes.BORE_BURROW_TARGET);
        boreEntity.method_18868().method_18875(AdventureMemoryModuleTypes.BORE_BURROW_DIGGING);
        boreEntity.method_18868().method_18875(AdventureMemoryModuleTypes.BORE_LEAVING_WATER);
    }

    private static boolean shouldStopDiggingPose(BoreEntity bore) {
        return bore.method_18868().method_18904(AdventureMemoryModuleTypes.BORE_BURROW_DIGGING).isEmpty() && bore.method_18376() == class_4050.field_38100;
    }

    private static boolean shouldStopEmergingPose(BoreEntity bore) {
        boolean bl = bore.method_18376() == class_4050.field_38099;
        boolean bl2 = bore.method_5799() && bore.method_18868().method_18876(AdventureMemoryModuleTypes.BORE_LEAVING_WATER, class_4141.field_18457);
        return bl && bl2;
    }

    private void burrowTo(BoreEntity bore, class_1937 world, double x, double y, double z) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        while (mutable.method_10264() > world.method_31607() && !world.method_8320((class_2338)mutable).method_51366()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = world.method_8320((class_2338)mutable);
        boolean bl = blockState.method_51366();
        boolean bl2 = blockState.method_26227().method_15767(class_3486.field_15517);
        if (bl && !bl2) {
            class_243 vec3d = bore.method_19538();
            boolean bl3 = bore.method_6082(x, y, z, false);
            if (bl3) {
                world.method_32888((class_6880)class_5712.field_39446, vec3d, class_5712.class_7397.method_43285((class_1297)bore));
                if (!bore.method_5701()) {
                    // empty if block
                }
            }
        }
    }

    private static boolean isTargetOutOfRange(BoreEntity bore, class_1309 target) {
        return !target.method_24516((class_1297)bore, 24.0);
    }

    private static boolean isTargetTooClose(BoreEntity bore, class_1309 target) {
        return target.method_5739((class_1297)bore) - 4.0f <= 0.0f;
    }
}

