/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.BoreEntity;
import net.j677.adventuresmod.entity.custom.TerraChargeEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class BoreShootTask
extends class_4097<BoreEntity> {
    private static final int RECOVER_EXPIRY = Math.round(4.0f);
    private static final int SHOOT_COOLDOWN_EXPIRY = Math.round(10.0f);
    private static final int SHOOT_CHARGING_EXPIRY = Math.round(15.0f);

    @VisibleForTesting
    public BoreShootTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.BORE_SHOOT_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.BORE_SHOOT_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.BORE_SHOOT_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.BORE_SHOOT, (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457), SHOOT_CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, BoreEntity boreEntity) {
        return boreEntity.method_18376() == class_4050.field_18076 && boreEntity.method_18868().method_18904(class_4140.field_22355).map(target -> BoreShootTask.isTargetWithinRange(boreEntity, target)).map(withinRange -> {
            if (!withinRange.booleanValue()) {
                boreEntity.method_18868().method_18875(AdventureMemoryModuleTypes.BORE_SHOOT);
            }
            return withinRange;
        }).orElse(false) != false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        return boreEntity.method_18868().method_18896(class_4140.field_22355) && boreEntity.method_18868().method_18896(AdventureMemoryModuleTypes.BORE_SHOOT);
    }

    protected void run(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        boreEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> boreEntity.method_18380(class_4050.field_47247));
        boreEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_SHOOT_CHARGING, (Object)class_3902.field_17274, (long)SHOOT_CHARGING_EXPIRY);
        boreEntity.method_5783(class_3417.field_47192, 1.0f, 1.0f);
    }

    protected void keepRunning(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        class_4095<BoreEntity> brain = boreEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            boreEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.BORE_SHOOT_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.BORE_SHOOT_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.BORE_SHOOT_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                if (BoreShootTask.isFacingTarget(boreEntity, livingEntity)) {
                    double d = livingEntity.method_23317() - boreEntity.method_23317();
                    double e = livingEntity.method_23323(livingEntity.method_5765() ? 0.8 : 0.3) - boreEntity.method_23323(0.5);
                    double f = livingEntity.method_23321() - boreEntity.method_23321();
                    TerraChargeEntity terraChargeEntity = new TerraChargeEntity(boreEntity, (class_1937)serverWorld);
                    boreEntity.method_5783(class_3417.field_47195, 1.5f, 1.0f);
                    terraChargeEntity.method_7485(d, e, f, 0.7f, 5 - serverWorld.method_8407().method_5461() * 4);
                    serverWorld.method_8649((class_1297)terraChargeEntity);
                }
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, BoreEntity boreEntity, long l) {
        if (boreEntity.method_18376() == class_4050.field_47247) {
            boreEntity.method_18380(class_4050.field_18076);
        }
        boreEntity.method_18868().method_24525(AdventureMemoryModuleTypes.BORE_SHOOT_COOLDOWN, (Object)class_3902.field_17274, (long)SHOOT_COOLDOWN_EXPIRY);
        boreEntity.method_18868().method_18875(AdventureMemoryModuleTypes.BORE_SHOOT);
    }

    @VisibleForTesting
    public static boolean isFacingTarget(BoreEntity bore, class_1309 target) {
        class_243 vec3d2;
        class_243 vec3d = bore.method_5828(1.0f);
        return vec3d.method_1026(vec3d2 = target.method_19538().method_1020(bore.method_19538()).method_1029()) > 0.5;
    }

    private static boolean isTargetWithinRange(BoreEntity bore, class_1309 target) {
        double d = bore.method_19538().method_1025(target.method_19538());
        return d > 4.0 && d < 256.0;
    }
}

