/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.custom.MoltenGuardEntity;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4101;
import net.minecraft.class_4106;
import net.minecraft.class_4107;
import net.minecraft.class_4109;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4116;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4215;
import net.minecraft.class_4219;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_4838;
import net.minecraft.class_5321;
import net.minecraft.class_5418;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class MoltenGuardBrain
extends class_4838 {
    public static class_4095<?> create(MoltenGuardEntity moltenGuard, class_4095<MoltenGuardEntity> brain) {
        MoltenGuardBrain.addCoreActivities(moltenGuard, brain);
        MoltenGuardBrain.addIdleActivities(moltenGuard, brain);
        MoltenGuardBrain.addFightActivities(moltenGuard, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    public static void setCurrentPosAsHome(MoltenGuardEntity moltenGuard) {
        class_4208 globalPos = class_4208.method_19443((class_5321)moltenGuard.method_37908().method_27983(), (class_2338)moltenGuard.method_24515());
        moltenGuard.method_18868().method_18878(class_4140.field_18438, (Object)globalPos);
    }

    private static void addCoreActivities(MoltenGuardEntity moltenGuard, class_4095<MoltenGuardEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)new class_4112(), (Object)class_4107.method_46964(), (Object)class_4829.method_47143()));
    }

    private static void addIdleActivities(MoltenGuardEntity moltenGuard, class_4095<MoltenGuardEntity> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4824.method_47119(MoltenGuardBrain::getTarget), MoltenGuardBrain.getFollowTasks(), MoltenGuardBrain.getIdleTasks(), (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)));
    }

    private static void addFightActivities(MoltenGuardEntity moltenGuard, class_4095<MoltenGuardEntity> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47138(entity -> !MoltenGuardBrain.isTarget(moltenGuard, entity)), (Object)class_4822.method_47094((float)1.0f), (Object)class_4816.method_46987((int)20), (Object)((Object)new UsePotionTask())), class_4140.field_22355);
    }

    private static class_4118<MoltenGuardEntity> getFollowTasks() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_22281, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_25751, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057(AdventureEntityTypes.PIGLIN_SCAVENGER, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057(AdventureEntityTypes.MOLTEN_GUARD, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057(AdventureEntityTypes.INFLAMED, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47056((float)8.0f), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    private static class_4118<MoltenGuardEntity> getIdleTasks() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)class_4106.method_18941((class_1299)class_1299.field_22281, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941((class_1299)class_1299.field_25751, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941(AdventureEntityTypes.PIGLIN_SCAVENGER, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941(AdventureEntityTypes.MOLTEN_GUARD, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941(AdventureEntityTypes.INFLAMED, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_4219.method_47157((class_4140)class_4140.field_18438, (float)0.6f, (int)2, (int)100), (Object)2), (Object)Pair.of((Object)class_4116.method_47153((class_4140)class_4140.field_18438, (float)0.6f, (int)5), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    public static void tick(MoltenGuardEntity moltenGuard) {
        class_4095<MoltenGuardEntity> brain = moltenGuard.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
        class_4168 activity2 = brain.method_24538().orElse(null);
        if (activity != activity2) {
            MoltenGuardBrain.playSoundIfAngry(moltenGuard);
        }
        moltenGuard.method_19540(brain.method_18896(class_4140.field_22355));
    }

    private static boolean isTarget(class_5418 piglin, class_1309 entity) {
        return MoltenGuardBrain.getTarget(piglin).filter(target -> target == entity).isPresent();
    }

    private static Optional<? extends class_1309> getTarget(class_5418 piglin) {
        Optional optional = class_4215.method_24560((class_1309)piglin, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && class_4148.method_37456((class_1309)piglin, (class_1309)((class_1309)optional.get()))) {
            return optional;
        }
        Optional optional2 = MoltenGuardBrain.getTargetIfInRange(piglin, (class_4140<? extends class_1309>)class_4140.field_22354);
        return optional2.isPresent() ? optional2 : piglin.method_18868().method_18904(class_4140.field_25360);
    }

    private static Optional<? extends class_1309> getTargetIfInRange(class_5418 piglin, class_4140<? extends class_1309> targetMemoryModule) {
        return piglin.method_18868().method_18904(targetMemoryModule).filter(target -> target.method_24516((class_1297)piglin, 12.0));
    }

    public static void tryRevenge(MoltenGuardEntity moltenGuard, class_1309 target) {
        if (!(target instanceof class_5418)) {
            class_4838.method_24759((class_5418)moltenGuard, (class_1309)target);
        }
    }

    protected static void setTarget(MoltenGuardEntity moltenGuard, class_1309 target) {
        moltenGuard.method_18868().method_18875(class_4140.field_19293);
        moltenGuard.method_18868().method_24525(class_4140.field_22333, (Object)target.method_5667(), 600L);
    }

    public static void playSoundRandomly(MoltenGuardEntity moltenGuard) {
        if ((double)moltenGuard.method_37908().field_9229.method_43057() < 0.0125) {
            MoltenGuardBrain.playSoundIfAngry(moltenGuard);
        }
    }

    private static void playSoundIfAngry(MoltenGuardEntity moltenGuard) {
        moltenGuard.method_18868().method_24538().ifPresent(activity -> {
            if (activity == class_4168.field_22396) {
                moltenGuard.playAngrySound();
            }
        });
    }

    static class UsePotionTask
    extends class_4097<MoltenGuardEntity> {
        UsePotionTask() {
            super(Map.of(), 200);
        }

        protected boolean shouldRun(class_3218 serverWorld, MoltenGuardEntity moltenGuard) {
            return moltenGuard.method_5809() && !moltenGuard.method_6059(class_1294.field_5918);
        }

        protected boolean shouldKeepRunning(class_3218 serverWorld, MoltenGuardEntity moltenGuard, long l) {
            return moltenGuard.method_6115();
        }

        protected void run(class_3218 serverWorld, MoltenGuardEntity moltenGuard, long l) {
            moltenGuard.method_5673(class_1304.field_6171, class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8987));
            moltenGuard.method_6019(class_1268.field_5810);
            if (!moltenGuard.method_5701()) {
                moltenGuard.method_37908().method_43128(null, moltenGuard.method_23317(), moltenGuard.method_23318(), moltenGuard.method_23321(), AdventureSounds.ENTITY_MOLTEN_GUARD_DRINK, moltenGuard.method_5634(), 1.0f, 0.8f + serverWorld.field_9229.method_43057() * 0.4f);
            }
        }

        protected void finishRunning(class_3218 serverWorld, MoltenGuardEntity moltenGuard, long l) {
            moltenGuard.method_5673(class_1304.field_6171, class_1799.field_8037);
            moltenGuard.method_32876((class_6880)class_5712.field_28734);
        }
    }
}

