/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.j677.adventuresmod.entity.brain.ScavengerCrossbowAttackTask;
import net.j677.adventuresmod.entity.brain.ScavengerHuntHoglinTask;
import net.j677.adventuresmod.entity.brain.ScavengerRemoveOffHandItemTask;
import net.j677.adventuresmod.entity.custom.PiglinScavengerEntity;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4106;
import net.minecraft.class_4107;
import net.minecraft.class_4109;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4760;
import net.minecraft.class_4802;
import net.minecraft.class_4807;
import net.minecraft.class_4813;
import net.minecraft.class_4814;
import net.minecraft.class_4815;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4819;
import net.minecraft.class_4822;
import net.minecraft.class_4823;
import net.minecraft.class_4824;
import net.minecraft.class_4825;
import net.minecraft.class_4827;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5418;
import net.minecraft.class_5430;
import net.minecraft.class_5534;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_7894;
import net.minecraft.class_7898;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public class PiglinScavengerBrain {
    public static final class_1792 BARTERING_ITEM = class_1802.field_8695;
    public static final class_5321<class_52> BARTERING_LOOT_TABLE = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"adventuresmod", (String)"gameplay/piglin_scavenger_bartering"));
    protected static final class_6019 HUNT_MEMORY_DURATION = class_4802.method_24505((int)30, (int)120);
    private static final class_6019 AVOID_MEMORY_DURATION = class_4802.method_24505((int)5, (int)20);

    public static class_4095<?> create(PiglinScavengerEntity piglin, class_4095<PiglinScavengerEntity> brain) {
        PiglinScavengerBrain.addCoreActivities(brain);
        PiglinScavengerBrain.addIdleActivities(brain);
        PiglinScavengerBrain.addAdmireItemActivities(brain);
        PiglinScavengerBrain.addFightActivities(piglin, brain);
        PiglinScavengerBrain.addCelebrateActivities(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    public static void setHuntedRecently(PiglinScavengerEntity piglin, class_5819 random) {
        int i = HUNT_MEMORY_DURATION.method_35008(random);
        piglin.method_18868().method_24525(class_4140.field_22336, (Object)true, (long)i);
    }

    private static void addCoreActivities(class_4095<PiglinScavengerEntity> piglin) {
        piglin.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)new class_4112(), (Object)class_4107.method_46964(), ScavengerRemoveOffHandItemTask.create(), (Object)class_4823.method_47279((int)119), (Object)class_4825.method_47124((int)300, PiglinScavengerBrain::isHuntingTarget), (Object)class_4829.method_47143()));
    }

    private static void addIdleActivities(class_4095<PiglinScavengerEntity> piglin) {
        piglin.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4119.method_47065(PiglinScavengerBrain::isGoldHoldingPlayer, (float)14.0f), (Object)class_4824.method_47120(class_5418::method_30236, PiglinScavengerBrain::getPreferredTarget), (Object)class_7898.method_47227(PiglinScavengerEntity::method_26952, ScavengerHuntHoglinTask.create()), PiglinScavengerBrain.makeRandomFollowTask(), PiglinScavengerBrain.makeRandomWanderTask(), (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)));
    }

    private static void addFightActivities(PiglinScavengerEntity piglin, class_4095<PiglinScavengerEntity> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47138(target -> !PiglinScavengerBrain.isPreferredAttackTarget(piglin, target)), (Object)class_7898.method_47227(PiglinScavengerBrain::isHoldingCrossbow, (class_7894)class_4807.method_46901((int)5, (float)0.75f)), (Object)class_4822.method_47094((float)1.0f), (Object)class_4816.method_46987((int)20), new ScavengerCrossbowAttackTask(), (Object)class_4819.method_47275(), (Object)class_4813.method_46922(PiglinScavengerBrain::getNearestZombifiedPiglin, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static void addCelebrateActivities(class_4095<PiglinScavengerEntity> brain) {
        brain.method_24527(class_4168.field_22397, 10, ImmutableList.of((Object)class_4119.method_47065(PiglinScavengerBrain::isGoldHoldingPlayer, (float)14.0f), (Object)class_4824.method_47119(PiglinScavengerBrain::getPreferredTarget), (Object)class_7898.method_47227(piglin -> !piglin.isDancing(), (class_7894)class_4814.method_46941((class_4140)class_4140.field_22337, (int)2, (float)1.0f)), (Object)class_7898.method_47227(PiglinScavengerEntity::isDancing, (class_7894)class_4814.method_46941((class_4140)class_4140.field_22337, (int)4, (float)0.6f))), class_4140.field_22337);
    }

    private static void addAdmireItemActivities(class_4095<PiglinScavengerEntity> brain) {
        brain.method_24527(class_4168.field_22398, 10, ImmutableList.of((Object)class_4815.method_46947(PiglinScavengerBrain::doesNotHaveGoldInOffHand, (float)1.0f, (boolean)true, (int)9), (Object)class_4827.method_47290((int)9), (Object)class_5430.method_47294((int)200, (int)200)), class_4140.field_22334);
    }

    private static ImmutableList<Pair<class_7894<class_1309>, Integer>> makeFollowTasks() {
        return ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_22281, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47056((float)8.0f), (Object)1));
    }

    private static class_4118<class_1309> makeRandomFollowTask() {
        return new class_4118((List)ImmutableList.builder().addAll(PiglinScavengerBrain.makeFollowTasks()).add((Object)Pair.of((Object)new class_4101(30, 60), (Object)1)).build());
    }

    private static class_4118<PiglinScavengerEntity> makeRandomWanderTask() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)class_4106.method_18941((class_1299)class_1299.field_22281, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_7898.method_47227(PiglinScavengerBrain::canWander, (class_7894)class_4120.method_47104((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    public static void tickActivities(PiglinScavengerEntity piglin) {
        class_4095<PiglinScavengerEntity> brain = piglin.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22398, (Object)class_4168.field_22396, (Object)class_4168.field_22399, (Object)class_4168.field_22397, (Object)class_4168.field_18595));
        class_4168 activity2 = brain.method_24538().orElse(null);
        if (activity != activity2) {
            PiglinScavengerBrain.getCurrentActivitySound(piglin).ifPresent(arg_0 -> ((PiglinScavengerEntity)piglin).method_56078(arg_0));
        }
        piglin.method_19540(brain.method_18896(class_4140.field_22355));
        if (!brain.method_18896(class_4140.field_22337)) {
            brain.method_18875(class_4140.field_25159);
        }
        piglin.setDancing(brain.method_18896(class_4140.field_25159));
    }

    public static void loot(PiglinScavengerEntity piglin, class_1542 drop) {
        class_1799 itemStack;
        PiglinScavengerBrain.stopWalking(piglin);
        if (drop.method_6983().method_31574(class_1802.field_8397)) {
            piglin.method_6103((class_1297)drop, drop.method_6983().method_7947());
            itemStack = drop.method_6983();
            drop.method_31472();
        } else {
            piglin.method_6103((class_1297)drop, 1);
            itemStack = PiglinScavengerBrain.getItemFromStack(drop);
        }
        if (PiglinScavengerBrain.isGoldenItem(itemStack)) {
            piglin.method_18868().method_18875(class_4140.field_25813);
            PiglinScavengerBrain.swapItemWithOffHand(piglin, itemStack);
            PiglinScavengerBrain.setAdmiringItem((class_1309)piglin);
        } else if (PiglinScavengerBrain.isFood(itemStack) && PiglinScavengerBrain.hasAteRecently(piglin)) {
            PiglinScavengerBrain.setEatenRecently(piglin);
        } else {
            boolean bl;
            boolean bl2 = bl = !piglin.method_24523(itemStack).equals(class_1799.field_8037);
            if (!bl) {
                PiglinScavengerBrain.barterItem(piglin, itemStack);
            }
        }
    }

    private static void swapItemWithOffHand(PiglinScavengerEntity piglin, class_1799 stack) {
        if (PiglinScavengerBrain.hasItemInOffHand(piglin)) {
            piglin.method_5775(piglin.method_5998(class_1268.field_5810));
        }
        piglin.equipToOffHand(stack);
    }

    private static class_1799 getItemFromStack(class_1542 stack) {
        class_1799 itemStack = stack.method_6983();
        class_1799 itemStack2 = itemStack.method_7971(1);
        if (itemStack.method_7960()) {
            stack.method_31472();
        } else {
            stack.method_6979(itemStack);
        }
        return itemStack2;
    }

    protected static void consumeOffHandItem(PiglinScavengerEntity piglin, boolean barter) {
        class_1799 itemStack = piglin.method_5998(class_1268.field_5810);
        piglin.method_6122(class_1268.field_5810, class_1799.field_8037);
        if (piglin.method_30236()) {
            boolean bl = PiglinScavengerBrain.acceptsForBarter(itemStack);
            if (barter && bl) {
                PiglinScavengerBrain.doBarter(piglin, PiglinScavengerBrain.getBarteredItem(piglin));
            } else if (!bl) {
                boolean bl2;
                boolean bl3 = bl2 = !piglin.method_24523(itemStack).method_7960();
                if (!bl2) {
                    PiglinScavengerBrain.barterItem(piglin, itemStack);
                }
            }
        } else {
            boolean bl;
            boolean bl4 = bl = !piglin.method_24523(itemStack).method_7960();
            if (!bl) {
                class_1799 itemStack2 = piglin.method_6047();
                if (PiglinScavengerBrain.isGoldenItem(itemStack2)) {
                    PiglinScavengerBrain.barterItem(piglin, itemStack2);
                } else {
                    PiglinScavengerBrain.doBarter(piglin, Collections.singletonList(itemStack2));
                }
                piglin.equipToMainHand(itemStack);
            }
        }
    }

    public static void pickupItemWithOffHand(PiglinScavengerEntity piglin) {
        if (PiglinScavengerBrain.isAdmiringItem(piglin) && !piglin.method_6079().method_7960()) {
            piglin.method_5775(piglin.method_6079());
            piglin.method_6122(class_1268.field_5810, class_1799.field_8037);
        }
    }

    private static void barterItem(PiglinScavengerEntity piglin, class_1799 stack) {
        class_1799 itemStack = piglin.addItem(stack);
        PiglinScavengerBrain.dropBarteredItem(piglin, Collections.singletonList(itemStack));
    }

    private static void doBarter(PiglinScavengerEntity piglin, List<class_1799> items) {
        Optional optional = piglin.method_18868().method_18904(class_4140.field_18444);
        if (optional.isPresent()) {
            PiglinScavengerBrain.dropBarteredItem(piglin, (class_1657)optional.get(), items);
        } else {
            PiglinScavengerBrain.dropBarteredItem(piglin, items);
        }
    }

    private static void dropBarteredItem(PiglinScavengerEntity piglin, List<class_1799> items) {
        PiglinScavengerBrain.drop(piglin, items, PiglinScavengerBrain.findGround(piglin));
    }

    private static void dropBarteredItem(PiglinScavengerEntity piglin, class_1657 player, List<class_1799> items) {
        PiglinScavengerBrain.drop(piglin, items, player.method_19538());
    }

    private static void drop(PiglinScavengerEntity piglin, List<class_1799> items, class_243 pos) {
        if (!items.isEmpty()) {
            piglin.method_6104(class_1268.field_5810);
            for (class_1799 itemStack : items) {
                class_4215.method_19949((class_1309)piglin, (class_1799)itemStack, (class_243)pos.method_1031(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<class_1799> getBarteredItem(PiglinScavengerEntity piglin) {
        class_52 lootTable = Objects.requireNonNull(piglin.method_37908().method_8503()).method_58576().method_58295(BARTERING_LOOT_TABLE);
        return lootTable.method_51878(new class_8567.class_8568((class_3218)piglin.method_37908()).method_51874(class_181.field_1226, (Object)piglin).method_51875(class_173.field_22403));
    }

    private static boolean isHuntingTarget(class_1309 piglin, class_1309 target) {
        return target.method_5864() == class_1299.field_21973 && class_5819.method_43049((long)piglin.method_37908().method_8510()).method_43057() < 0.1f;
    }

    public static boolean canGather(PiglinScavengerEntity piglin, class_1799 stack) {
        if (stack.method_31573(class_3489.field_23064)) {
            return false;
        }
        if (PiglinScavengerBrain.hasBeenHitByPlayer(piglin) && piglin.method_18868().method_18896(class_4140.field_22355)) {
            return false;
        }
        if (PiglinScavengerBrain.acceptsForBarter(stack)) {
            return PiglinScavengerBrain.doesNotHaveGoldInOffHand(piglin);
        }
        boolean bl = piglin.canInsertIntoInventory(stack);
        if (stack.method_31574(class_1802.field_8397)) {
            return bl;
        }
        if (PiglinScavengerBrain.isFood(stack)) {
            return PiglinScavengerBrain.hasAteRecently(piglin) && bl;
        }
        return !PiglinScavengerBrain.isGoldenItem(stack) ? piglin.canEquipStack(stack) : PiglinScavengerBrain.doesNotHaveGoldInOffHand(piglin) && bl;
    }

    public static boolean isGoldenItem(class_1799 stack) {
        return stack.method_31573(class_3489.field_24481);
    }

    private static boolean isPreferredAttackTarget(PiglinScavengerEntity piglin, class_1309 target) {
        return PiglinScavengerBrain.getPreferredTarget(piglin).filter(preferredTarget -> preferredTarget == target).isPresent();
    }

    private static boolean getNearestZombifiedPiglin(PiglinScavengerEntity piglin) {
        class_4095<PiglinScavengerEntity> brain = piglin.method_18868();
        if (brain.method_18896(class_4140.field_22346)) {
            class_1309 livingEntity = (class_1309)brain.method_18904(class_4140.field_22346).get();
            return piglin.method_24516((class_1297)livingEntity, 6.0);
        }
        return false;
    }

    private static Optional<? extends class_1309> getPreferredTarget(PiglinScavengerEntity piglin) {
        Optional optional2;
        class_4095<PiglinScavengerEntity> brain = piglin.method_18868();
        if (PiglinScavengerBrain.getNearestZombifiedPiglin(piglin)) {
            return Optional.empty();
        }
        Optional optional = class_4215.method_24560((class_1309)piglin, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && class_4148.method_37456((class_1309)piglin, (class_1309)((class_1309)optional.get()))) {
            return optional;
        }
        if (brain.method_18896(class_4140.field_25361) && (optional2 = brain.method_18904(class_4140.field_22354)).isPresent()) {
            return optional2;
        }
        optional2 = brain.method_18904(class_4140.field_25360);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional optional3 = brain.method_18904(class_4140.field_22342);
        return optional3.isPresent() && class_4148.method_36982((class_1309)piglin, (class_1309)((class_1309)optional3.get())) ? optional3 : Optional.empty();
    }

    public static class_1269 playerInteract(PiglinScavengerEntity piglin, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (PiglinScavengerBrain.isWillingToTrade(piglin, itemStack)) {
            class_1799 itemStack2 = itemStack.method_60504(1, (class_1309)player);
            PiglinScavengerBrain.swapItemWithOffHand(piglin, itemStack2);
            PiglinScavengerBrain.setAdmiringItem((class_1309)piglin);
            PiglinScavengerBrain.stopWalking(piglin);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public static boolean isWillingToTrade(PiglinScavengerEntity piglin, class_1799 nearbyItems) {
        return !PiglinScavengerBrain.hasBeenHitByPlayer(piglin) && !PiglinScavengerBrain.isAdmiringItem(piglin) && piglin.method_30236() && PiglinScavengerBrain.acceptsForBarter(nearbyItems);
    }

    public static void onAttacked(PiglinScavengerEntity piglin, class_1309 attacker) {
        if (!(attacker instanceof PiglinScavengerEntity)) {
            if (PiglinScavengerBrain.hasItemInOffHand(piglin)) {
                PiglinScavengerBrain.consumeOffHandItem(piglin, false);
            }
            class_4095<PiglinScavengerEntity> brain = piglin.method_18868();
            brain.method_18875(class_4140.field_22337);
            brain.method_18875(class_4140.field_25159);
            brain.method_18875(class_4140.field_22334);
            if (attacker instanceof class_1657) {
                brain.method_24525(class_4140.field_22473, (Object)true, 400L);
            }
            PiglinScavengerBrain.getAvoiding(piglin).ifPresent(avoiding -> {
                if (avoiding.method_5864() != attacker.method_5864()) {
                    brain.method_18875(class_4140.field_22357);
                }
            });
            if (attacker.method_5864() == class_1299.field_21973 && PiglinScavengerBrain.hasOutnumberedHoglins(piglin)) {
                PiglinScavengerBrain.runAwayFrom(piglin, attacker);
                PiglinScavengerBrain.groupRunAwayFrom(piglin, attacker);
            } else {
                PiglinScavengerBrain.tryRevenge(piglin, attacker, piglin);
            }
        }
    }

    protected static void tryRevenge(class_5418 piglin, class_1309 target, PiglinScavengerEntity scavengerEntity) {
        if (!piglin.method_18868().method_18906(class_4168.field_22399) && class_4148.method_37456((class_1309)piglin, (class_1309)target) && !class_4215.method_24558((class_1309)piglin, (class_1309)target, (double)4.0)) {
            if (target.method_5864() == class_1299.field_6097 && piglin.method_37908().method_8450().method_8355(class_1928.field_25402)) {
                PiglinScavengerBrain.becomeAngryWithPlayer(scavengerEntity, target);
                PiglinScavengerBrain.angerNearbyPiglins(piglin, scavengerEntity);
            } else {
                PiglinScavengerBrain.becomeAngryWith(scavengerEntity, target);
                PiglinScavengerBrain.angerAtCloserTargets(scavengerEntity, target);
            }
        }
    }

    public static Optional<class_3414> getCurrentActivitySound(PiglinScavengerEntity piglin) {
        return piglin.method_18868().method_24538().map(activity -> PiglinScavengerBrain.getSound(piglin, activity));
    }

    private static class_3414 getSound(PiglinScavengerEntity piglin, class_4168 activity) {
        if (activity == class_4168.field_22396) {
            return AdventureSounds.ENTITY_PIGLIN_SCAVENGER_ANGRY;
        }
        if (piglin.method_30235()) {
            return class_3417.field_22270;
        }
        if (activity == class_4168.field_22399 && PiglinScavengerBrain.hasTargetToAvoid(piglin)) {
            return class_3417.field_22270;
        }
        if (activity == class_4168.field_22398) {
            return class_3417.field_22263;
        }
        if (activity == class_4168.field_22397) {
            return class_3417.field_22266;
        }
        if (PiglinScavengerBrain.hasPlayerHoldingWantedItemNearby((class_1309)piglin)) {
            return class_3417.field_22268;
        }
        return AdventureSounds.ENTITY_PIGLIN_SCAVENGER_AMBIENT;
    }

    private static boolean hasTargetToAvoid(PiglinScavengerEntity piglin) {
        class_4095<PiglinScavengerEntity> brain = piglin.method_18868();
        return brain.method_18896(class_4140.field_22357) && ((class_1309)brain.method_18904(class_4140.field_22357).get()).method_24516((class_1297)piglin, 12.0);
    }

    protected static List<class_5418> getNearbyVisiblePiglins(PiglinScavengerEntity piglin) {
        return (List)piglin.method_18868().method_18904(class_4140.field_22343).orElse(ImmutableList.of());
    }

    private static List<class_5418> getNearbyPiglins(class_5418 piglin) {
        return (List)piglin.method_18868().method_18904(class_4140.field_25755).orElse(ImmutableList.of());
    }

    public static boolean wearsGoldArmor(class_1309 entity) {
        for (class_1799 itemStack : entity.method_56674()) {
            class_1792 item = itemStack.method_7909();
            if (!(item instanceof class_1738) || !((class_1738)item).method_7686().method_55838(class_1740.field_7895)) continue;
            return true;
        }
        return false;
    }

    private static void stopWalking(PiglinScavengerEntity piglin) {
        piglin.method_18868().method_18875(class_4140.field_18445);
        piglin.method_5942().method_6340();
    }

    protected static void angerAtCloserTargets(PiglinScavengerEntity scavengerEntity, class_1309 target) {
        PiglinScavengerBrain.getNearbyPiglins(scavengerEntity).forEach(nearbyPiglin -> {
            if (target.method_5864() != class_1299.field_21973 || scavengerEntity.method_26952() && ((class_4760)target).method_26945()) {
                PiglinScavengerBrain.angerAtIfCloser(scavengerEntity, target);
            }
        });
    }

    protected static void angerNearbyPiglins(class_5418 piglin, PiglinScavengerEntity scavengerEntity) {
        PiglinScavengerBrain.getNearbyPiglins(piglin).forEach(nearbyPiglin -> PiglinScavengerBrain.getNearestDetectedPlayer(nearbyPiglin).ifPresent(player -> PiglinScavengerBrain.becomeAngryWith(scavengerEntity, (class_1309)player)));
    }

    protected static void becomeAngryWith(PiglinScavengerEntity scavengerEntity, class_1309 target) {
        if (class_4148.method_37456((class_1309)scavengerEntity, (class_1309)target)) {
            scavengerEntity.method_18868().method_18875(class_4140.field_19293);
            scavengerEntity.method_18868().method_24525(class_4140.field_22333, (Object)target.method_5667(), 600L);
            if (target.method_5864() == class_1299.field_21973 && scavengerEntity.method_26952()) {
                PiglinScavengerBrain.rememberHunting(scavengerEntity);
            }
            if (target.method_5864() == class_1299.field_6097 && scavengerEntity.method_37908().method_8450().method_8355(class_1928.field_25402)) {
                scavengerEntity.method_18868().method_24525(class_4140.field_25361, (Object)true, 600L);
            }
        }
    }

    private static void becomeAngryWithPlayer(PiglinScavengerEntity scavengerEntity, class_1309 player) {
        Optional<class_1657> optional = PiglinScavengerBrain.getNearestDetectedPlayer(scavengerEntity);
        if (optional.isPresent()) {
            PiglinScavengerBrain.becomeAngryWith(scavengerEntity, (class_1309)optional.get());
        } else {
            PiglinScavengerBrain.becomeAngryWith(scavengerEntity, player);
        }
    }

    private static void angerAtIfCloser(PiglinScavengerEntity scavengerEntity, class_1309 target) {
        Optional<class_1309> optional = PiglinScavengerBrain.getAngryAt(scavengerEntity);
        class_1309 livingEntity = class_4215.method_24562((class_1309)scavengerEntity, optional, (class_1309)target);
        if (optional.isEmpty() || optional.get() != livingEntity) {
            PiglinScavengerBrain.becomeAngryWith(scavengerEntity, livingEntity);
        }
    }

    private static Optional<class_1309> getAngryAt(class_5418 piglin) {
        return class_4215.method_24560((class_1309)piglin, (class_4140)class_4140.field_22333);
    }

    public static Optional<class_1309> getAvoiding(PiglinScavengerEntity piglin) {
        return piglin.method_18868().method_18896(class_4140.field_22357) ? piglin.method_18868().method_18904(class_4140.field_22357) : Optional.empty();
    }

    public static Optional<class_1657> getNearestDetectedPlayer(class_5418 piglin) {
        return piglin.method_18868().method_18896(class_4140.field_22354) ? piglin.method_18868().method_18904(class_4140.field_22354) : Optional.empty();
    }

    private static boolean isHoldingCrossbow(class_1309 piglin) {
        return piglin.method_24518(class_1802.field_8399);
    }

    private static void groupRunAwayFrom(PiglinScavengerEntity piglin, class_1309 target) {
        PiglinScavengerBrain.getNearbyVisiblePiglins(piglin).stream().filter(nearbyVisiblePiglin -> nearbyVisiblePiglin instanceof PiglinScavengerEntity).forEach(piglinx -> PiglinScavengerBrain.runAwayFromClosestTarget((PiglinScavengerEntity)((Object)piglinx), target));
    }

    private static void runAwayFromClosestTarget(PiglinScavengerEntity piglin, class_1309 target) {
        class_4095<PiglinScavengerEntity> brain = piglin.method_18868();
        class_1309 livingEntity = class_4215.method_24562((class_1309)piglin, (Optional)brain.method_18904(class_4140.field_22357), (class_1309)target);
        livingEntity = class_4215.method_24562((class_1309)piglin, (Optional)brain.method_18904(class_4140.field_22355), (class_1309)livingEntity);
        PiglinScavengerBrain.runAwayFrom(piglin, livingEntity);
    }

    private static boolean hasOutnumberedHoglins(PiglinScavengerEntity piglins) {
        int i = piglins.method_18868().method_18904(class_4140.field_22347).orElse(0) + 1;
        int j = piglins.method_18868().method_18904(class_4140.field_22348).orElse(0);
        return j > i;
    }

    private static void runAwayFrom(PiglinScavengerEntity piglin, class_1309 target) {
        piglin.method_18868().method_18875(class_4140.field_22333);
        piglin.method_18868().method_18875(class_4140.field_22355);
        piglin.method_18868().method_18875(class_4140.field_18445);
        piglin.method_18868().method_24525(class_4140.field_22357, (Object)target, (long)AVOID_MEMORY_DURATION.method_35008(piglin.method_37908().field_9229));
        PiglinScavengerBrain.rememberHunting(piglin);
    }

    protected static void rememberHunting(class_5418 piglin) {
        piglin.method_18868().method_24525(class_4140.field_22336, (Object)true, (long)HUNT_MEMORY_DURATION.method_35008(piglin.method_37908().field_9229));
    }

    private static void setEatenRecently(PiglinScavengerEntity piglin) {
        piglin.method_18868().method_24525(class_4140.field_22350, (Object)true, 200L);
    }

    private static class_243 findGround(PiglinScavengerEntity piglin) {
        class_243 vec3d = class_5534.method_31527((class_1314)piglin, (int)4, (int)2);
        return vec3d == null ? piglin.method_19538() : vec3d;
    }

    private static boolean hasAteRecently(PiglinScavengerEntity piglin) {
        return !piglin.method_18868().method_18896(class_4140.field_22350);
    }

    private static void setAdmiringItem(class_1309 entity) {
        entity.method_18868().method_24525(class_4140.field_22334, (Object)true, 119L);
    }

    private static boolean isAdmiringItem(PiglinScavengerEntity entity) {
        return entity.method_18868().method_18896(class_4140.field_22334);
    }

    private static boolean acceptsForBarter(class_1799 stack) {
        return stack.method_31574(BARTERING_ITEM);
    }

    private static boolean isFood(class_1799 stack) {
        return stack.method_31573(class_3489.field_26988);
    }

    private static boolean hasPlayerHoldingWantedItemNearby(class_1309 entity) {
        return entity.method_18868().method_18896(class_4140.field_22349);
    }

    private static boolean canWander(class_1309 piglin) {
        return !PiglinScavengerBrain.hasPlayerHoldingWantedItemNearby(piglin);
    }

    public static boolean isGoldHoldingPlayer(class_1309 target) {
        return target.method_5864() == class_1299.field_6097 && target.method_24520(PiglinScavengerBrain::isGoldenItem);
    }

    private static boolean hasBeenHitByPlayer(PiglinScavengerEntity piglin) {
        return piglin.method_18868().method_18896(class_4140.field_22473);
    }

    private static boolean hasItemInOffHand(PiglinScavengerEntity piglin) {
        return !piglin.method_6079().method_7960();
    }

    private static boolean doesNotHaveGoldInOffHand(PiglinScavengerEntity piglin) {
        return piglin.method_6079().method_7960() || !PiglinScavengerBrain.isGoldenItem(piglin.method_6079());
    }
}

