/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.custom.PiglinScavengerEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class ScavengerCrossbowAttackTask<E extends PiglinScavengerEntity>
extends class_4097<E> {
    private int chargingCooldown;
    private CrossbowState state = CrossbowState.UNCHARGED;

    public ScavengerCrossbowAttackTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456), 300);
    }

    protected boolean shouldRun(class_3218 serverWorld, E piglinScavenger) {
        class_1309 livingEntity = ScavengerCrossbowAttackTask.getAttackTarget(piglinScavenger);
        return piglinScavenger.method_24518(class_1802.field_8399) && class_4215.method_24565(piglinScavenger, (class_1309)livingEntity) && class_4215.method_25940(piglinScavenger, (class_1309)livingEntity, (int)0);
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, E piglinScavenger, long l) {
        return ((PiglinScavengerEntity)((Object)piglinScavenger)).method_18868().method_18896(class_4140.field_22355) && this.shouldRun(serverWorld, piglinScavenger);
    }

    protected void keepRunning(class_3218 serverWorld, E piglinScavenger, long l) {
        class_1309 livingEntity = ScavengerCrossbowAttackTask.getAttackTarget(piglinScavenger);
        this.setLookTarget((class_1308)piglinScavenger, livingEntity);
        this.tickState(piglinScavenger, livingEntity);
    }

    protected void finishRunning(class_3218 serverWorld, E piglinScavenger, long l) {
        if (piglinScavenger.method_6115()) {
            piglinScavenger.method_6021();
        }
        if (piglinScavenger.method_24518(class_1802.field_8399)) {
            ((PiglinScavengerEntity)((Object)piglinScavenger)).method_7110(false);
            piglinScavenger.method_6030().method_57379(class_9334.field_49649, (Object)class_9278.field_49298);
        }
    }

    private void tickState(E entity, class_1309 target) {
        if (this.state == CrossbowState.UNCHARGED) {
            entity.method_6019(class_1675.method_18812(entity, (class_1792)class_1802.field_8399));
            this.state = CrossbowState.CHARGING;
            ((PiglinScavengerEntity)((Object)entity)).method_7110(true);
        } else if (this.state == CrossbowState.CHARGING) {
            class_1799 itemStack;
            int i;
            if (!entity.method_6115()) {
                this.state = CrossbowState.UNCHARGED;
            }
            if ((i = entity.method_6048()) >= class_1764.method_7775((class_1799)(itemStack = entity.method_6030()), entity)) {
                entity.method_6075();
                this.state = CrossbowState.CHARGED;
                this.chargingCooldown = 3 + entity.method_59922().method_43048(3);
                ((PiglinScavengerEntity)((Object)entity)).method_7110(false);
            }
        } else if (this.state == CrossbowState.CHARGED) {
            --this.chargingCooldown;
            if (this.chargingCooldown == 0) {
                this.state = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.state == CrossbowState.READY_TO_ATTACK) {
            ((PiglinScavengerEntity)((Object)entity)).method_7105(target, 1.0f);
            this.state = CrossbowState.UNCHARGED;
        }
    }

    private void setLookTarget(class_1308 entity, class_1309 target) {
        entity.method_18868().method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)target, true));
    }

    private static class_1309 getAttackTarget(class_1309 entity) {
        return (class_1309)entity.method_18868().method_18904(class_4140.field_22355).get();
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

