/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.SlablingEntity;
import net.j677.adventuresmod.item.AdventureItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4106;
import net.minecraft.class_4109;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4121;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4802;
import net.minecraft.class_4813;
import net.minecraft.class_4815;
import net.minecraft.class_4818;
import net.minecraft.class_4827;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5430;
import net.minecraft.class_5534;
import net.minecraft.class_6019;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public class SlablingBrain {
    public static final class_1792 BARTERING_ITEM = AdventureItems.BISMUTH;
    public static final class_5321<class_52> BARTERING_LOOT_TABLE = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"adventuresmod", (String)"gameplay/slabling_bartering"));
    private static final class_6019 AVOID_MEMORY_DURATION = class_4802.method_24505((int)5, (int)20);

    public static class_4095<?> create(class_4095<SlablingEntity> brain) {
        SlablingBrain.addCoreActivities(brain);
        SlablingBrain.addIdleActivities(brain);
        SlablingBrain.addAdmireItemActivities(brain);
        SlablingBrain.addAvoidActivities(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(class_4095<SlablingEntity> slabling) {
        slabling.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)new class_4112(), RemoveOffHandItemTask.create(), AdmireItemTask.create(119)));
    }

    private static void addIdleActivities(class_4095<SlablingEntity> slabling) {
        slabling.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4119.method_47065(SlablingBrain::isLovedItemHoldingPlayer, (float)14.0f), SlablingBrain.makeRandomFollowTask(), SlablingBrain.makeRandomWanderTask(), (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)));
    }

    private static void addAdmireItemActivities(class_4095<SlablingEntity> brain) {
        brain.method_24527(class_4168.field_22398, 10, ImmutableList.of((Object)class_4815.method_46947(SlablingBrain::doesNotHaveLovedItemInHand, (float)1.0f, (boolean)true, (int)9), (Object)class_4827.method_47290((int)9), (Object)class_5430.method_47294((int)200, (int)200)), class_4140.field_22334);
    }

    private static void addAvoidActivities(class_4095<SlablingEntity> brain) {
        brain.method_24527(class_4168.field_22399, 10, ImmutableList.of((Object)class_4121.method_24603((class_4140)class_4140.field_22357, (float)1.0f, (int)12, (boolean)true), SlablingBrain.makeRandomFollowTask(), SlablingBrain.makeRandomWanderTask(), (Object)class_4813.method_46922(SlablingBrain::shouldRunAwayFromPlayer, (class_4140)class_4140.field_22357)), class_4140.field_22357);
    }

    private static ImmutableList<Pair<class_7894<class_1309>, Integer>> makeFollowTasks() {
        return ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057(AdventureEntityTypes.SLABLING, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47056((float)8.0f), (Object)1));
    }

    private static class_4118<class_1309> makeRandomFollowTask() {
        return new class_4118((List)ImmutableList.builder().addAll(SlablingBrain.makeFollowTasks()).add((Object)Pair.of((Object)new class_4101(30, 60), (Object)1)).build());
    }

    private static class_4118<SlablingEntity> makeRandomWanderTask() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)class_4106.method_18941(AdventureEntityTypes.SLABLING, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_7898.method_47227(SlablingBrain::canWander, (class_7894)class_4120.method_47104((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    public static void updateActivities(SlablingEntity slabling) {
        slabling.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_22398, (Object)class_4168.field_22399, (Object)class_4168.field_18595));
    }

    public static void loot(SlablingEntity slabling, class_1542 drop) {
        SlablingBrain.stopWalking(slabling);
        slabling.method_6103((class_1297)drop, 1);
        class_1799 itemStack = SlablingBrain.getItemFromStack(drop);
        if (SlablingBrain.isLovedItem(itemStack)) {
            slabling.method_18868().method_18875(class_4140.field_25813);
            SlablingBrain.swapItemWithOffHand(slabling, itemStack);
            SlablingBrain.setAdmiringItem((class_1309)slabling);
        } else {
            boolean bl;
            boolean bl2 = bl = !slabling.method_24523(itemStack).equals(class_1799.field_8037);
            if (!bl) {
                SlablingBrain.barterItem(slabling, itemStack);
            }
        }
    }

    private static void swapItemWithOffHand(SlablingEntity slabling, class_1799 stack) {
        if (SlablingBrain.hasItemInHand(slabling)) {
            slabling.method_5775(slabling.method_5998(class_1268.field_5810));
        }
        slabling.equipToOffHand(stack);
    }

    private static class_1799 getItemFromStack(class_1542 stack) {
        class_1799 itemStack = stack.method_6983();
        class_1799 itemStack2 = itemStack.method_7971(1);
        if (itemStack.method_7960()) {
            stack.method_31472();
        } else {
            stack.method_6979(itemStack);
        }
        return itemStack2;
    }

    protected static void consumeOffHandItem(SlablingEntity slabling, boolean barter) {
        class_1799 itemStack = slabling.method_5998(class_1268.field_5810);
        slabling.method_6122(class_1268.field_5810, class_1799.field_8037);
        boolean bl = SlablingBrain.acceptsForBarter(itemStack);
        if (barter && bl) {
            SlablingBrain.doBarter(slabling, SlablingBrain.getBarteredItem(slabling));
        } else if (!bl) {
            boolean bl2;
            boolean bl3 = bl2 = !slabling.method_24523(itemStack).method_7960();
            if (!bl2) {
                SlablingBrain.barterItem(slabling, itemStack);
            }
        }
    }

    private static void barterItem(SlablingEntity slabling, class_1799 stack) {
        class_1799 itemStack = slabling.addItem(stack);
        SlablingBrain.dropBarteredItem(slabling, Collections.singletonList(itemStack));
    }

    private static void doBarter(SlablingEntity slabling, List<class_1799> items) {
        Optional optional = slabling.method_18868().method_18904(class_4140.field_18444);
        if (optional.isPresent()) {
            SlablingBrain.dropBarteredItem(slabling, (class_1657)optional.get(), items);
        } else {
            SlablingBrain.dropBarteredItem(slabling, items);
        }
    }

    private static void dropBarteredItem(SlablingEntity slabling, List<class_1799> items) {
        SlablingBrain.drop(slabling, items, SlablingBrain.findGround(slabling));
    }

    private static void dropBarteredItem(SlablingEntity slabling, class_1657 player, List<class_1799> items) {
        SlablingBrain.drop(slabling, items, player.method_19538());
    }

    private static void drop(SlablingEntity slabling, List<class_1799> items, class_243 pos) {
        if (!items.isEmpty()) {
            slabling.method_6104(class_1268.field_5810);
            for (class_1799 itemStack : items) {
                class_4215.method_19949((class_1309)slabling, (class_1799)itemStack, (class_243)pos.method_1031(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<class_1799> getBarteredItem(SlablingEntity slabling) {
        class_52 lootTable = Objects.requireNonNull(slabling.method_37908().method_8503()).method_58576().method_58295(BARTERING_LOOT_TABLE);
        return lootTable.method_51878(new class_8567.class_8568((class_3218)slabling.method_37908()).method_51874(class_181.field_1226, (Object)slabling).method_51875(class_173.field_22403));
    }

    public static boolean canGather(SlablingEntity slabling, class_1799 stack) {
        if (SlablingBrain.hasBeenHitByPlayer(slabling) && slabling.method_18868().method_18896(class_4140.field_22357)) {
            return false;
        }
        if (SlablingBrain.acceptsForBarter(stack)) {
            return SlablingBrain.doesNotHaveLovedItemInHand(slabling);
        }
        return false;
    }

    public static boolean isLovedItem(class_1799 stack) {
        return stack.method_31574(AdventureItems.BISMUTH);
    }

    public static class_1269 playerInteract(SlablingEntity slabling, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (SlablingBrain.isWillingToTrade(slabling, itemStack)) {
            class_1799 itemStack2 = itemStack.method_60504(1, (class_1309)player);
            SlablingBrain.swapItemWithOffHand(slabling, itemStack2);
            SlablingBrain.setAdmiringItem((class_1309)slabling);
            SlablingBrain.stopWalking(slabling);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public static boolean isWillingToTrade(SlablingEntity slabling, class_1799 nearbyItems) {
        return !SlablingBrain.hasBeenHitByPlayer(slabling) && !SlablingBrain.isAdmiringItem(slabling) && SlablingBrain.acceptsForBarter(nearbyItems);
    }

    public static void onAttacked(SlablingEntity slabling, class_1309 attacker) {
        if (!(attacker instanceof SlablingEntity)) {
            if (SlablingBrain.hasItemInHand(slabling)) {
                SlablingBrain.consumeOffHandItem(slabling, false);
            }
            class_4095<SlablingEntity> brain = slabling.method_18868();
            brain.method_18875(class_4140.field_22334);
            if (attacker instanceof class_1657) {
                brain.method_24525(class_4140.field_22473, (Object)true, 400L);
            }
            SlablingBrain.getAvoiding(slabling).ifPresent(avoiding -> {
                if (avoiding.method_5864() != attacker.method_5864()) {
                    brain.method_18875(class_4140.field_22357);
                }
            });
            if (attacker.method_5864() == class_1299.field_6097) {
                SlablingBrain.runAwayFrom(slabling, attacker);
                SlablingBrain.groupRunAwayFrom(slabling, attacker);
            }
        }
    }

    private static void stopWalking(SlablingEntity slabling) {
        slabling.method_18868().method_18875(class_4140.field_18445);
        slabling.method_5942().method_6340();
    }

    public static Optional<class_1309> getAvoiding(SlablingEntity slabling) {
        return slabling.method_18868().method_18896(class_4140.field_22357) ? slabling.method_18868().method_18904(class_4140.field_22357) : Optional.empty();
    }

    protected static List<SlablingEntity> getNearbyVisibleSlablings(SlablingEntity slabling) {
        return (List)slabling.method_18868().method_18904(AdventureMemoryModuleTypes.NEAREST_VISIBLE_SLABLINGS).orElse(ImmutableList.of());
    }

    private static void groupRunAwayFrom(SlablingEntity slabling, class_1309 target) {
        SlablingBrain.getNearbyVisibleSlablings(slabling).stream().filter(Objects::nonNull).forEach(slablingx -> SlablingBrain.runAwayFromClosestTarget(slablingx, target));
    }

    private static void runAwayFromClosestTarget(SlablingEntity slabling, class_1309 target) {
        class_4095<SlablingEntity> brain = slabling.method_18868();
        class_1309 livingEntity = class_4215.method_24562((class_1309)slabling, (Optional)brain.method_18904(class_4140.field_22357), (class_1309)target);
        SlablingBrain.runAwayFrom(slabling, livingEntity);
    }

    private static boolean shouldRunAwayFromPlayer(SlablingEntity slabling) {
        class_4095<SlablingEntity> brain = slabling.method_18868();
        if (!brain.method_18896(class_4140.field_22357)) {
            return true;
        }
        class_1309 livingEntity = (class_1309)brain.method_18904(class_4140.field_22357).get();
        class_1299 entityType = livingEntity.method_5864();
        if (entityType == class_1299.field_6097) {
            return !SlablingBrain.isAfraidOfPlayer(slabling, livingEntity);
        }
        return true;
    }

    private static boolean isAfraidOfPlayer(SlablingEntity slabling, class_1309 livingEntity) {
        return slabling.method_49107() == livingEntity;
    }

    public static boolean isDeparted(class_1299<?> entityType) {
        return entityType == AdventureEntityTypes.DEPARTED || entityType == AdventureEntityTypes.DEPARTED_KNIGHT;
    }

    private static void runAwayFrom(SlablingEntity slabling, class_1309 target) {
        slabling.method_18868().method_18875(class_4140.field_18445);
        slabling.method_18868().method_24525(class_4140.field_22357, (Object)target, (long)AVOID_MEMORY_DURATION.method_35008(slabling.method_37908().field_9229));
    }

    private static class_243 findGround(SlablingEntity slabling) {
        class_243 vec3d = class_5534.method_31527((class_1314)slabling, (int)4, (int)2);
        return vec3d == null ? slabling.method_19538() : vec3d;
    }

    private static void setAdmiringItem(class_1309 entity) {
        entity.method_18868().method_24525(class_4140.field_22334, (Object)true, 119L);
    }

    private static boolean isAdmiringItem(SlablingEntity entity) {
        return entity.method_18868().method_18896(class_4140.field_22334);
    }

    private static boolean acceptsForBarter(class_1799 stack) {
        return stack.method_31574(BARTERING_ITEM);
    }

    private static boolean hasPlayerHoldingWantedItemNearby(class_1309 entity) {
        return entity.method_18868().method_18896(class_4140.field_22349);
    }

    private static boolean canWander(class_1309 slabling) {
        return !SlablingBrain.hasPlayerHoldingWantedItemNearby(slabling);
    }

    public static boolean isLovedItemHoldingPlayer(class_1309 target) {
        return target.method_5864() == class_1299.field_6097 && target.method_24520(SlablingBrain::isLovedItem);
    }

    private static boolean hasBeenHitByPlayer(SlablingEntity slabling) {
        return slabling.method_18868().method_18896(class_4140.field_22473);
    }

    private static boolean hasItemInHand(SlablingEntity slabling) {
        return !slabling.method_6079().method_7960();
    }

    private static boolean doesNotHaveLovedItemInHand(SlablingEntity slabling) {
        return slabling.method_6079().method_7960() || !SlablingBrain.isLovedItem(slabling.method_6079());
    }

    public static class RemoveOffHandItemTask {
        public static class_7893<SlablingEntity> create() {
            return class_7898.method_47224(context -> context.group((App)context.method_47245(class_4140.field_22334)).apply((Applicative)context, admiringItem -> (world, entity, time) -> {
                if (!entity.method_6079().method_7960()) {
                    SlablingBrain.consumeOffHandItem(entity, true);
                    return true;
                }
                return false;
            }));
        }
    }

    public static class AdmireItemTask {
        public static class_7893<class_1309> create(int duration) {
            return class_7898.method_47224(context -> context.group((App)context.method_47244(class_4140.field_22332), (App)context.method_47245(class_4140.field_22334), (App)context.method_47245(class_4140.field_22473), (App)context.method_47245(class_4140.field_25814)).apply((Applicative)context, (nearestVisibleWantedItem, admiringItem, admiringDisabled, disableWalkToAdmireItem) -> (world, entity, time) -> {
                class_1542 itemEntity = (class_1542)context.method_47243(nearestVisibleWantedItem);
                if (!SlablingBrain.isLovedItem(itemEntity.method_6983())) {
                    return false;
                }
                admiringItem.method_47250((Object)true, (long)duration);
                return true;
            }));
        }
    }
}

