/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.WispEntity;
import net.j677.adventuresmod.util.AdventureTags;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4115;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4818;
import net.minecraft.class_6028;

public class WispBrain {
    public static final ImmutableList<class_4149<? extends class_4148<? super WispEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_18469);
    public static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_39408, AdventureMemoryModuleTypes.TREASURE_SEARCH_TARGET, (Object)class_4140.field_18442, (Object)class_4140.field_38394);

    public static class_4095<?> create(class_4095<WispEntity> brain) {
        WispBrain.addCoreActivities(brain);
        WispBrain.addIdleActivities(brain);
        WispBrain.addSearchActivities(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(class_4095<WispEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_6028(2.5f), (Object)new class_4112(1200, 1200)));
    }

    private static void addIdleActivities(class_4095<WispEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4110(45, 90)), (Object)Pair.of((Object)1, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)6.0f), (Object)1), (Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)1), (Object)Pair.of((Object)new class_4101(5, 20), (Object)2)))), (Object)Pair.of((Object)2, (Object)((Object)new BeginSearchTask()))));
    }

    private static void addSearchActivities(class_4095<WispEntity> brain) {
        brain.method_24529(class_4168.field_38200, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new StructureSearchTask()))), Set.of(Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457), Pair.of(AdventureMemoryModuleTypes.TREASURE_SEARCH_TARGET, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_18445, (Object)class_4141.field_18456)));
    }

    public static void updateActivities(WispEntity wisp) {
        wisp.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_38200, (Object)class_4168.field_18595));
    }

    static class BeginSearchTask
    extends class_4097<WispEntity> {
        BeginSearchTask() {
            super(Map.of(AdventureMemoryModuleTypes.TREASURE_SEARCH_TARGET, class_4141.field_18457), 10);
        }

        protected boolean shouldRun(class_3218 serverWorld, WispEntity wispEntity) {
            return wispEntity.canSearch();
        }

        protected boolean shouldKeepRunning(class_3218 serverWorld, WispEntity wispEntity, long l) {
            return wispEntity.canSearch();
        }

        protected void finishRunning(class_3218 serverWorld, WispEntity wispEntity, long l) {
            boolean bl = this.method_18915(l);
            class_2338 blockPos = wispEntity.method_24515();
            class_2338 pos = serverWorld.method_8487(AdventureTags.Structures.WISP_LOCATED, blockPos, 50, false);
            if (bl && pos != null) {
                wispEntity.method_18868().method_18878(AdventureMemoryModuleTypes.TREASURE_SEARCH_TARGET, (Object)pos);
                wispEntity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(pos, 1.75f, 0));
            }
        }
    }

    static class StructureSearchTask
    extends class_4097<WispEntity> {
        StructureSearchTask() {
            super(Map.of(class_4140.field_18445, class_4141.field_18456, class_4140.field_39408, class_4141.field_18457, AdventureMemoryModuleTypes.TREASURE_SEARCH_TARGET, class_4141.field_18456), 2400);
        }

        protected boolean shouldRun(class_3218 serverWorld, WispEntity wispEntity) {
            return wispEntity.canSearch();
        }

        protected boolean shouldKeepRunning(class_3218 serverWorld, WispEntity wispEntity, long l) {
            if (!wispEntity.canSearch()) {
                return false;
            }
            Optional<class_2338> optional = wispEntity.method_18868().method_18904(class_4140.field_18445).map(class_4142::method_19094).map(class_4115::method_18989);
            Optional optional2 = wispEntity.method_18868().method_18904(AdventureMemoryModuleTypes.TREASURE_SEARCH_TARGET);
            wispEntity.method_37908().method_8421((class_1297)wispEntity, (byte)1);
            return optional.isPresent() && optional2.isPresent() && ((class_2338)optional2.get()).equals((Object)optional.get());
        }

        protected void run(class_3218 world, WispEntity entity, long time) {
        }

        protected void finishRunning(class_3218 serverWorld, WispEntity wispEntity, long l) {
            wispEntity.setHasPayment(false);
            wispEntity.method_18868().method_18875(class_4140.field_38394);
            wispEntity.method_18868().method_18875(class_4140.field_18445);
            wispEntity.method_18868().method_18875(AdventureMemoryModuleTypes.TREASURE_SEARCH_TARGET);
            class_1799 itemStack = wispEntity.method_6118(class_1304.field_6173);
            wispEntity.method_5783(wispEntity.method_18869(itemStack), 1.0f, 1.0f);
            wispEntity.method_37908().method_8421((class_1297)wispEntity, (byte)45);
            wispEntity.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
    }
}

